/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.compile.ConstExpSrc;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.compile.SourceGenerator;
import com.greenpineyu.fel.compile.SourceGeneratorImpl;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.parser.FelNode;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class CompileService {
    private SourceGenerator srcGen = new SourceGeneratorImpl();
    private FelCompiler complier;

    public CompileService() {
        FelCompiler felCompiler;
        String string = this.getCompilerClassName();
        this.complier = felCompiler = this.newCompiler(string);
    }

    public SourceGenerator getSrcGen() {
        return this.srcGen;
    }

    public void setSrcGen(SourceGenerator sourceGenerator) {
        this.srcGen = sourceGenerator;
    }

    public FelCompiler getComplier() {
        return this.complier;
    }

    public void setComplier(FelCompiler felCompiler) {
        this.complier = felCompiler;
    }

    public static List<String> getClassPath(ClassLoader classLoader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (classLoader != null) {
            Object object;
            boolean bl = classLoader instanceof URLClassLoader;
            if (bl) {
                object = (URLClassLoader)classLoader;
                for (URL uRL : ((URLClassLoader)object).getURLs()) {
                    arrayList.add(uRL.getFile());
                }
            } else {
                object = null;
                try {
                    object = classLoader.getResources("/");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (object != null) {
                    while (object.hasMoreElements()) {
                        URL uRL = (URL)object.nextElement();
                        arrayList.add(uRL.getFile());
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FelCompiler newCompiler(String string) {
        FelCompiler felCompiler = null;
        try {
            Class<?> clazz = Class.forName(string);
            felCompiler = (FelCompiler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return felCompiler;
    }

    private String getCompilerClassName() {
        String string = System.getProperty("java.version");
        String string2 = FelCompiler.class.getName();
        string2 = string != null && string.startsWith("1.5") ? string2 + "15" : string2 + "16";
        return string2;
    }

    public Expression compile(FelContext felContext, FelNode felNode, String string) {
        try {
            JavaSource javaSource = this.srcGen.getSource(felContext, felNode);
            if (javaSource instanceof ConstExpSrc) {
                ConstExpSrc constExpSrc = (ConstExpSrc)javaSource;
                return constExpSrc.getValue();
            }
            javaSource.setSource("// \u8868\u8fbe\u5f0f:" + string + "\n" + javaSource.getSource());
            return this.complier.compile(javaSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.getProperties().list(System.out);
    }
}

