/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.common;

import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.function.operator.Add;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtil {
    public static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    public static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    public static boolean toBoolean(Object object) {
        return NumberUtil.toBooleanObj(object);
    }

    public static Boolean toBooleanObj(Object object) {
        if (object == null) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return Boolean.FALSE;
    }

    public static int toInteger(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Integer coercion exception. arg is null");
        }
        if (object instanceof String) {
            if ("".equals(object)) {
                return 0;
            }
            return Integer.parseInt((String)object);
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Integer coercion exception");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new IllegalArgumentException("Integer coercion exception. Can't coerce type: " + object.getClass().getName());
    }

    public static long toLong(Object object) {
        if (object == null) {
            throw new NumberFormatException("Long coercion exception. arg is null");
        }
        if (object instanceof String) {
            if ("".equals(object)) {
                return 0L;
            }
            return Long.parseLong((String)object);
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            throw new NumberFormatException("Boolean->Long coercion exception");
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new NumberFormatException("Long coercion exception. Can't coerce type: " + object.getClass().getName());
    }

    public static BigInteger toBigInteger(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object == null) {
            throw new IllegalArgumentException("BigInteger coercion exception. arg is null");
        }
        if (object instanceof String) {
            String string = (String)object;
            if ("".equals(string.trim())) {
                return BigInteger.ZERO;
            }
            return new BigInteger(string);
        }
        if (object instanceof Number) {
            return new BigInteger(object.toString());
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return BigInteger.valueOf(c);
        }
        throw new IllegalArgumentException("BigInteger coercion exception. Can't coerce type: " + object.getClass().getName());
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object == null) {
            throw new IllegalArgumentException("BigDecimal coercion exception. arg is null");
        }
        if (object instanceof String) {
            String string = (String)object;
            if ("".equals(string.trim())) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(string);
        }
        if (object instanceof Number) {
            return new BigDecimal(object.toString());
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return new BigDecimal(c);
        }
        throw new IllegalArgumentException("BigDecimal coercion exception. Can't coerce type: " + object.getClass().getName());
    }

    public static double toDouble(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Double coercion exception. arg is null");
        }
        if (object instanceof String) {
            String string = (String)object;
            if ("".equals(string.trim())) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return c;
        }
        if (object instanceof Number) {
            return NumberUtil.toDouble((Number)object);
        }
        if (object instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Double coercion exception");
        }
        throw new IllegalArgumentException("Double coercion exception. Can't coerce type: " + object.getClass().getName());
    }

    public static Number narrow(Number number) {
        Number number2;
        if (number == null) {
            return number;
        }
        Number number3 = number;
        if (number instanceof BigDecimal && ((BigDecimal)(number2 = (BigDecimal)number)).compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
            return number;
        }
        if (number instanceof Double || number instanceof Float || number instanceof BigDecimal) {
            double d = number.doubleValue();
            if (d <= 3.4028234663852886E38 && d >= (double)1.4E-45f) {
                number3 = Float.valueOf(number3.floatValue());
            }
        } else {
            if (number instanceof BigInteger && (((BigInteger)(number2 = (BigInteger)number)).compareTo(BIGI_LONG_MAX_VALUE) > 0 || ((BigInteger)number2).compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return number;
            }
            long l = number.longValue();
            return NumberUtil.parseNumber(l);
        }
        return number3;
    }

    public static boolean isFloatingPointNumber(Object object) {
        if (object instanceof Float || object instanceof Double) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.indexOf(46) != -1 || string.indexOf(101) != -1 || string.indexOf(69) != -1;
        }
        return false;
    }

    public static boolean isFloatingPoint(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    public static boolean isNumberable(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Byte || object instanceof Short || object instanceof Character;
    }

    public static Number narrowBigInteger(Object object, Object object2, BigInteger bigInteger) {
        if (!(object instanceof BigInteger) && !(object2 instanceof BigInteger) && bigInteger.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigInteger.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigInteger.longValue();
            if (!(object instanceof Long) && !(object2 instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return Integer.valueOf(l + "");
            }
            return Long.valueOf(l + "");
        }
        return bigInteger;
    }

    public static boolean narrowArguments(Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof Number)) continue;
            Number number = NumberUtil.narrow((Number)object);
            if (number != object) {
                bl = true;
            }
            objectArray[i] = number;
        }
        return bl;
    }

    public static Number parseNumber(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return new Integer(n);
        }
        return new Long(l);
    }

    public static Object parseNumber(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return NumberUtil.parseNumber(l);
        }
        return new Double(d);
    }

    public static Object parseNumber(String string) {
        if (string != null) {
            String string2 = string.trim();
            try {
                return NumberUtil.parseNumber(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double toDouble(Number number) {
        if (number instanceof Float) {
            return Double.parseDouble(number.toString());
        }
        return number.doubleValue();
    }

    public static <T extends Comparable<T>> int compare(T t, T t2) {
        if (t != null && t2 != null) {
            return t.compareTo(t2);
        }
        return t == null ? -1 : 1;
    }

    public static Object calArray(Object object) {
        if (!(object instanceof Object[])) {
            return object;
        }
        Object object2 = new Integer(0);
        if (!ArrayUtils.isEmpty((Object[])object)) {
            for (int i = 0; i < ((Object[])object).length; ++i) {
                object2 = Add.add(object2, ((Object[])object)[i]);
            }
        }
        return object2;
    }

    public static Class<?> arithmeticClass(Class<?> clazz, Class<?> clazz2) {
        if (NumberUtil.isDoubleClass(clazz) || NumberUtil.isDoubleClass(clazz2)) {
            return Double.TYPE;
        }
        if (NumberUtil.isLongClass(clazz) || NumberUtil.isLongClass(clazz2)) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static boolean isDoubleClass(Class<?> clazz) {
        return clazz == Double.class || clazz == Double.TYPE;
    }

    public static boolean isLongClass(Class<?> clazz) {
        return clazz == Long.class || clazz == Long.TYPE;
    }

    public static boolean equals(double d, float f) {
        return d == NumberUtil.toDouble(Float.valueOf(f));
    }

    public static boolean equals(float f, double d) {
        return NumberUtil.toDouble(Float.valueOf(f)) == d;
    }

    public static boolean equals(float f, float f2) {
        return f == f2;
    }

    public static boolean equals(double d, double d2) {
        return d == d2;
    }

    public static boolean equals(long l, int n) {
        return l == (long)n;
    }

    public static boolean equals(int n, long l) {
        return (long)n == l;
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static void main(String[] stringArray) {
        Integer n = 1;
        Long l = 1L;
        float f = 1.0f;
        double d = 1.0;
        System.out.println(NumberUtil.equals((int)n, (long)l));
        System.out.println(NumberUtil.equals(f, f));
        System.out.println(NumberUtil.equals(f, d));
        System.out.println(NumberUtil.equals(d, f));
        System.out.println(NumberUtil.equals(d, d));
    }
}

