/*
 * Decompiled with CFR 0.152.
 */
package com.ybsoftware;

import com.sun.jna.ptr.IntByReference;
import com.ybsoftware.DNAPointConfig;
import com.ybsoftware.DNAPointInstanceInfo;
import com.ybsoftware.DNAPointVal;
import com.ybsoftware.DNAStatVal;
import com.ybsoftware.DNAType;
import com.ybsoftware.DNAVal;
import com.ybsoftware.HISTORY;
import com.ybsoftware.HISTORY_POINT;
import com.ybsoftware.HISTORY_VALUE;
import com.ybsoftware.IRuntime;
import com.ybsoftware.POINT_VALUE;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ApiEntry {
    private SimpleDateFormat _format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean _isConnected = false;
    public static int _key = 0;
    public static Object _lockObj = new Object();
    public static int _count = 0;
    public static int MAX_QUERY_SIZE = 100000;
    public static int MAX_TYPE_SIZE = 10000;
    public static int MAX_INSTANCE_SIZE = 100000;
    public static int MAX_INSTANCE_POINT = 50000;
    public static int MAX_POINT_IN_SERV = 1000000;
    public static double FLOAT_ERROR = -1.7E308;
    static String ip = "10.211.55.7";
    static int port = 10010;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiEntry(String ip, int port) throws Exception {
        if (_key == 0) {
            Object object = _lockObj;
            synchronized (object) {
                if (_key == 0) {
                    IntByReference key = new IntByReference();
                    int ret = IRuntime.INSTANCE.InitCommunicationKey(key, false, "", 0);
                    ret = IRuntime.INSTANCE.ConnectToServer(key.getValue(), ip, (short)port);
                    if (ret != 0) {
                        IRuntime.INSTANCE.DisposeKey(key.getValue());
                        throw new Exception("Connect to eDOS failed");
                    }
                    _key = key.getValue();
                    this._isConnected = true;
                    ++_count;
                } else {
                    ++_count;
                }
                return;
            }
        }
        Object object = _lockObj;
        synchronized (object) {
            ++_count;
            return;
        }
    }

    public ApiEntry(String ip, int port, int timeout) throws Exception {
        this(ip, port);
    }

    public void finalize() {
    }

    public int parseDateStringToUTC(String date) throws ParseException {
        return (int)(this._format.parse(date).getTime() / 1000L);
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    public boolean login(String name, String password) {
        return IRuntime.INSTANCE.Login(_key, name, password) == 0;
    }

    public DNAVal[] getRealtimeTagValues(String ... tagNames) throws Exception {
        DNAVal[] result = new DNAVal[tagNames.length];
        byte[] bt = new byte[14 * tagNames.length];
        int ret = IRuntime.INSTANCE.GetRTValueList(_key, tagNames, bt, tagNames.length);
        if (ret == 0) {
            int i = 0;
            while (i < tagNames.length) {
                result[i] = new DNAVal();
                result[i].DValue = ByteBuffer.wrap(bt, 14 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].Time = ByteBuffer.wrap(bt, 14 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].Status = ByteBuffer.wrap(bt, 14 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
        } else {
            throw new Exception("getRealtimeTagValues error return  " + ret);
        }
        return result;
    }

    public DNAVal[] getHistSnap(String tagName, int tStart, int tEnd, int period) throws Exception {
        int count = (tEnd - tStart) / period + 10;
        byte[] bt = new byte[14 * count];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetHistSnap(_key, tagName, tStart, tEnd, period, bt, count, retsize);
        if (ret == 0) {
            DNAVal[] result = new DNAVal[retsize.getValue()];
            int i = 0;
            while (i < result.length) {
                result[i] = new DNAVal();
                result[i].DValue = ByteBuffer.wrap(bt, 14 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].Time = ByteBuffer.wrap(bt, 14 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].Status = ByteBuffer.wrap(bt, 14 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("GetHistSnap error return  " + ret);
    }

    public DNAVal[] getHistSnapRaw(String tagName, int tStart, int tEnd, int period) throws Exception {
        int count = (tEnd - tStart) / period + 10;
        byte[] bt = new byte[14 * count];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetHistSnapRaw(_key, tagName, tStart, tEnd, period, bt, count, retsize);
        if (ret == 0) {
            DNAVal[] result = new DNAVal[retsize.getValue()];
            int i = 0;
            while (i < result.length) {
                result[i] = new DNAVal();
                result[i].DValue = ByteBuffer.wrap(bt, 14 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].Time = ByteBuffer.wrap(bt, 14 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].Status = ByteBuffer.wrap(bt, 14 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("GetHistSnap error return  " + ret);
    }

    public DNAStatVal[] getHistStat(String tagName, int tStart, int tEnd, int period) throws Exception {
        int count = (tEnd - tStart) / period + 10;
        byte[] bt = new byte[42 * count];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetHistStat(_key, tagName, tStart, tEnd, period, bt, count, retsize);
        if (ret == 0) {
            DNAStatVal[] result = new DNAStatVal[retsize.getValue()];
            int i = 0;
            while (i < result.length) {
                result[i] = new DNAStatVal();
                result[i].max.DValue = ByteBuffer.wrap(bt, 42 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].max.Time = ByteBuffer.wrap(bt, 42 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].max.Status = ByteBuffer.wrap(bt, 42 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].min.DValue = ByteBuffer.wrap(bt, 42 * i + 4 + 14, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].min.Time = ByteBuffer.wrap(bt, 42 * i + 14, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].min.Status = ByteBuffer.wrap(bt, 42 * i + 14 + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].avg.DValue = ByteBuffer.wrap(bt, 42 * i + 4 + 28, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].avg.Time = ByteBuffer.wrap(bt, 42 * i + 28, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].avg.Status = ByteBuffer.wrap(bt, 42 * i + 28 + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("getHistStat error return  " + ret);
    }

    public DNAStatVal[] getHistStatNoFillTime(String tagName, int tStart, int tEnd, int period) throws Exception {
        int count = (tEnd - tStart) / period + 10;
        byte[] bt = new byte[42 * count];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetHistStatNoFillTime(_key, tagName, tStart, tEnd, period, bt, count, retsize);
        if (ret == 0) {
            DNAStatVal[] result = new DNAStatVal[retsize.getValue()];
            int i = 0;
            while (i < result.length) {
                result[i] = new DNAStatVal();
                result[i].max.DValue = ByteBuffer.wrap(bt, 42 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].max.Time = ByteBuffer.wrap(bt, 42 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].max.Status = ByteBuffer.wrap(bt, 42 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].min.DValue = ByteBuffer.wrap(bt, 42 * i + 4 + 14, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].min.Time = ByteBuffer.wrap(bt, 42 * i + 14, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].min.Status = ByteBuffer.wrap(bt, 42 * i + 14 + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].avg.DValue = ByteBuffer.wrap(bt, 42 * i + 4 + 28, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].avg.Time = ByteBuffer.wrap(bt, 42 * i + 28, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].avg.Status = ByteBuffer.wrap(bt, 42 * i + 28 + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("getHistStat error return  " + ret);
    }

    public DNAVal[] getHistRaw(String tagName, int tStart, int tEnd) throws Exception {
        IntByReference retsize;
        byte[] bt;
        int ret;
        int count = tEnd - tStart;
        if (count > 100000) {
            count = MAX_QUERY_SIZE;
        }
        if ((ret = IRuntime.INSTANCE.GetHistRaw(_key, tagName, tStart, tEnd, bt = new byte[14 * count], count, retsize = new IntByReference())) == 0) {
            DNAVal[] result = new DNAVal[retsize.getValue()];
            int i = 0;
            while (i < result.length) {
                result[i] = new DNAVal();
                result[i].DValue = ByteBuffer.wrap(bt, 14 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].Time = ByteBuffer.wrap(bt, 14 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].Status = ByteBuffer.wrap(bt, 14 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("getHistRaw error return  " + ret);
    }

    public void sendMultiPoint(DNAPointVal[] recs) throws Exception {
        POINT_VALUE[] datas = (POINT_VALUE[])new POINT_VALUE().toArray(recs.length);
        int i = 0;
        while (i < recs.length) {
            byte[] nameArray = recs[i].Name.trim().getBytes();
            System.arraycopy(nameArray, 0, datas[i].name, 0, nameArray.length);
            datas[i].name[nameArray.length] = 0;
            datas[i].rec.dValue = recs[i].Val.DValue;
            datas[i].rec.tTime = recs[i].Val.Time;
            datas[i].rec.status = recs[i].Val.Status;
            ++i;
        }
        int ret = IRuntime.INSTANCE.SendMultiPoint(_key, datas, (short)recs.length);
        if (ret != 0) {
            throw new Exception("sendMultiPoint error return  " + ret);
        }
    }

    public void sendSinglePoint(String name, DNAVal[] recs) throws Exception {
        HISTORY_VALUE[] datas = (HISTORY_VALUE[])new HISTORY_VALUE().toArray(recs.length);
        int i = 0;
        while (i < recs.length) {
            datas[i].dValue = recs[i].DValue;
            datas[i].tTime = recs[i].Time;
            datas[i].status = recs[i].Status;
            ++i;
        }
        int ret = IRuntime.INSTANCE.SendSinglePoint(_key, name, datas, (short)datas.length);
        if (ret != 0) {
            throw new Exception("sendSinglePoint error return  " + ret);
        }
    }

    public DNAVal[] getHistMatrix(String[] nameList, int tTime) throws Exception {
        byte[] bt = new byte[14 * nameList.length];
        int ret = IRuntime.INSTANCE.GetHistMatrix(_key, nameList, tTime, bt, nameList.length);
        if (ret == 0) {
            DNAVal[] recs = new DNAVal[nameList.length];
            int i = 0;
            while (i < recs.length) {
                recs[i] = new DNAVal();
                recs[i].DValue = ByteBuffer.wrap(bt, 14 * i + 4, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                recs[i].Time = ByteBuffer.wrap(bt, 14 * i, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                recs[i].Status = ByteBuffer.wrap(bt, 14 * i + 8 + 4, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return recs;
        }
        throw new Exception("getHistMatrix error return  " + ret);
    }

    public void updatePointData(String name, DNAVal[] recs) throws Exception {
        HISTORY_VALUE[] datas = (HISTORY_VALUE[])new HISTORY_VALUE().toArray(recs.length);
        int i = 0;
        while (i < recs.length) {
            datas[i].dValue = recs[i].DValue;
            datas[i].tTime = recs[i].Time;
            datas[i].status = recs[i].Status;
            ++i;
        }
        int ret = IRuntime.INSTANCE.UpdatePointData(_key, name, datas, (short)recs.length);
        if (ret != 0) {
            throw new Exception("updatePointData error return  " + ret);
        }
    }

    public void deletePointData(String name, int tStart, int tEnd) throws Exception {
        int ret = IRuntime.INSTANCE.DeletePointData(_key, name, tStart, tEnd);
        if (ret != 0) {
            throw new Exception("deletePointData error return  " + ret);
        }
    }

    public DNAPointConfig getPointInfo(String name) throws Exception {
        HISTORY_POINT.ByReference ref = new HISTORY_POINT.ByReference();
        int ret = IRuntime.INSTANCE.GetPointInfo(_key, name, ref);
        if (ret == 0) {
            DNAPointConfig result = new DNAPointConfig();
            result.name = new String(ref.name).trim();
            result.description = new String(ref.description).trim();
            result.nPrecision = ref.nPrecision;
            result.deadBand = ref.deadBand;
            result.expireDays = ref.expireDays;
            result.pointType = ref.pointType;
            result.units = new String(ref.units).trim();
            result.instance = new String(ref.instance).trim();
            result.instanceAttribute = new String(ref.instanceAttribute).trim();
            result.instanceAttributeDescription = new String(ref.instanceAttributeDescription).trim();
            result.type = new String(ref.type).trim();
            result.minimumUpdateFreq = ref.minimumUpdateFreq;
            result.dValue = ref.dValue;
            result.tTime = ref.tTime;
            result.status = ref.status;
            return result;
        }
        throw new Exception("getPointInfo error return  " + ret);
    }

    public DNAType[] loadAllTypes() throws Exception {
        byte[] bt = new byte[204 * MAX_TYPE_SIZE];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.LoadAllTypes(_key, bt, MAX_TYPE_SIZE, retsize);
        if (ret == 0) {
            DNAType[] result = new DNAType[retsize.getValue()];
            int i = 0;
            while (i < retsize.getValue()) {
                result[i] = new DNAType();
                result[i].instanceCount = ByteBuffer.wrap(bt, 204 * i + 200, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].Name = new String(bt, 204 * i, 200).trim();
                ++i;
            }
            return result;
        }
        throw new Exception("loadAllTypes error return  " + ret);
    }

    static int byte2int(byte[] res, int offset) {
        int targets = res[offset] & 0xFF | res[offset + 1] << 8 & 0xFF00;
        return targets;
    }

    public DNAPointInstanceInfo[] getPointInstances() throws Exception {
        byte[] bt = new byte[808 * MAX_INSTANCE_SIZE];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetPointInstances(_key, bt, MAX_INSTANCE_SIZE, retsize);
        if (ret == 0) {
            DNAPointInstanceInfo[] result = new DNAPointInstanceInfo[retsize.getValue()];
            int i = 0;
            while (i < retsize.getValue()) {
                result[i] = new DNAPointInstanceInfo();
                result[i].name = new String(bt, 808 * i, 200).trim();
                result[i].count = ByteBuffer.wrap(bt, 808 * i + 200, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].stringCount = ByteBuffer.wrap(bt, 808 * i + 200 + 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].description = new String(bt, 808 * i + 200 + 4 + 4, 200).trim();
                result[i].system = new String(bt, 808 * i + 200 + 4 + 4 + 200, 200).trim();
                result[i].subSystem = new String(bt, 808 * i + 200 + 4 + 4 + 200 + 200, 200).trim();
                ++i;
            }
            return result;
        }
        throw new Exception("getPointInstances error return  " + ret);
    }

    public DNAPointConfig[] getInstancePoints(String instance) throws Exception {
        byte[] bt = new byte[1284 * MAX_INSTANCE_POINT];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetInstancePoints(_key, instance, 0, MAX_INSTANCE_POINT, bt, MAX_INSTANCE_POINT, retsize);
        if (ret == 0) {
            DNAPointConfig[] result = new DNAPointConfig[retsize.getValue()];
            int i = 0;
            while (i < retsize.getValue()) {
                result[i] = new DNAPointConfig();
                result[i].name = new String(bt, 1284 * i, 200).trim();
                result[i].description = new String(bt, 1284 * i + 200, 200).trim();
                result[i].nPrecision = ByteBuffer.wrap(bt, 1284 * i + 400, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].deadBand = ByteBuffer.wrap(bt, 1284 * i + 402, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].expireDays = ByteBuffer.wrap(bt, 1284 * i + 410, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].pointType = ByteBuffer.wrap(bt, 1284 * i + 414, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].units = new String(bt, 1284 * i + 416, 50).trim();
                result[i].instance = new String(bt, 1284 * i + 466, 200).trim();
                result[i].instanceAttribute = new String(bt, 1284 * i + 666, 200).trim();
                result[i].instanceAttributeDescription = new String(bt, 1284 * i + 866, 200).trim();
                result[i].type = new String(bt, 1284 * i + 1066, 200).trim();
                result[i].minimumUpdateFreq = ByteBuffer.wrap(bt, 1284 * i + 1266, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].dValue = ByteBuffer.wrap(bt, 1284 * i + 1270, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].tTime = ByteBuffer.wrap(bt, 1284 * i + 1278, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].status = ByteBuffer.wrap(bt, 1284 * i + 1282, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("getInstancePoints error return  " + ret);
    }

    public DNAPointInstanceInfo[] searchInstance(String type, String description, String system, String subSystem) throws Exception {
        byte[] bt = new byte[808 * MAX_INSTANCE_SIZE];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.SearchInstance(_key, type, description, system, subSystem, bt, MAX_INSTANCE_SIZE, retsize);
        if (ret == 0) {
            DNAPointInstanceInfo[] result = new DNAPointInstanceInfo[retsize.getValue()];
            int i = 0;
            while (i < retsize.getValue()) {
                result[i] = new DNAPointInstanceInfo();
                result[i].name = new String(bt, 808 * i, 200).trim();
                result[i].count = ByteBuffer.wrap(bt, 808 * i + 200, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].stringCount = ByteBuffer.wrap(bt, 808 * i + 200 + 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].description = new String(bt, 808 * i + 200 + 4 + 4, 200).trim();
                result[i].system = new String(bt, 808 * i + 200 + 4 + 4 + 200, 200).trim();
                result[i].subSystem = new String(bt, 808 * i + 200 + 4 + 4 + 200 + 200, 200).trim();
                ++i;
            }
            return result;
        }
        throw new Exception("searchInstance error return  " + ret);
    }

    public DNAPointConfig[] getHistoryPoints(String filterName, String filterDesc, String instance, String filterInstanceAttribute, String filterInstanceAttributeDescription, String type) throws Exception {
        byte[] bt = new byte[1284 * MAX_POINT_IN_SERV];
        IntByReference retsize = new IntByReference();
        int ret = IRuntime.INSTANCE.GetHistoryPoints(_key, new HISTORY(), filterName, filterDesc, instance, filterInstanceAttribute, filterInstanceAttributeDescription, type, bt, MAX_POINT_IN_SERV, retsize);
        if (ret == 0) {
            DNAPointConfig[] result = new DNAPointConfig[retsize.getValue()];
            int i = 0;
            while (i < retsize.getValue()) {
                result[i] = new DNAPointConfig();
                result[i].name = new String(bt, 1284 * i, 200).trim();
                result[i].description = new String(bt, 1284 * i + 200, 200).trim();
                result[i].nPrecision = ByteBuffer.wrap(bt, 1284 * i + 400, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].deadBand = ByteBuffer.wrap(bt, 1284 * i + 402, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].expireDays = ByteBuffer.wrap(bt, 1284 * i + 410, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].pointType = ByteBuffer.wrap(bt, 1284 * i + 414, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                result[i].units = new String(bt, 1284 * i + 416, 50).trim();
                result[i].instance = new String(bt, 1284 * i + 466, 200).trim();
                result[i].instanceAttribute = new String(bt, 1284 * i + 666, 200).trim();
                result[i].instanceAttributeDescription = new String(bt, 1284 * i + 866, 200).trim();
                result[i].type = new String(bt, 1284 * i + 1066, 200).trim();
                result[i].minimumUpdateFreq = ByteBuffer.wrap(bt, 1284 * i + 1266, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].dValue = ByteBuffer.wrap(bt, 1284 * i + 1270, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                result[i].tTime = ByteBuffer.wrap(bt, 1284 * i + 1278, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                result[i].status = ByteBuffer.wrap(bt, 1284 * i + 1282, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
                ++i;
            }
            return result;
        }
        throw new Exception("getHistoryPoints error return  " + ret);
    }

    public void createPoint(DNAPointConfig point) throws Exception {
        HISTORY_POINT.ByValue tPoint = new HISTORY_POINT.ByValue();
        tPoint.deadBand = point.deadBand;
        byte[] descriptionArray = point.description.trim().getBytes();
        System.arraycopy(descriptionArray, 0, tPoint.description, 0, descriptionArray.length);
        tPoint.dValue = point.dValue;
        tPoint.expireDays = point.expireDays;
        byte[] instanceArray = point.instance.trim().getBytes();
        System.arraycopy(instanceArray, 0, tPoint.instance, 0, instanceArray.length);
        byte[] instanceAttributeArray = point.instanceAttribute.trim().getBytes();
        System.arraycopy(instanceAttributeArray, 0, tPoint.instanceAttribute, 0, instanceAttributeArray.length);
        byte[] instanceAttributeDescArray = point.instanceAttributeDescription.trim().getBytes();
        System.arraycopy(instanceAttributeDescArray, 0, tPoint.instanceAttributeDescription, 0, instanceAttributeDescArray.length);
        tPoint.minimumUpdateFreq = point.minimumUpdateFreq;
        byte[] nameArray = point.name.trim().getBytes();
        System.arraycopy(nameArray, 0, tPoint.name, 0, nameArray.length);
        tPoint.nPrecision = point.nPrecision;
        tPoint.pointType = point.pointType;
        tPoint.status = point.status;
        tPoint.tTime = point.tTime;
        byte[] typeArray = point.type.trim().getBytes();
        System.arraycopy(typeArray, 0, tPoint.type, 0, typeArray.length);
        byte[] unitArray = point.units.trim().getBytes();
        System.arraycopy(unitArray, 0, tPoint.units, 0, unitArray.length);
        int ret = IRuntime.INSTANCE.CreatePoint(_key, tPoint, null, null, (short)0);
        if (ret != 0) {
            throw new Exception("createPoint error return  " + ret);
        }
    }

    public void updatePoint(DNAPointConfig point) throws Exception {
        HISTORY_POINT.ByValue tPoint = new HISTORY_POINT.ByValue();
        tPoint.deadBand = point.deadBand;
        byte[] descriptionArray = point.description.trim().getBytes();
        System.arraycopy(descriptionArray, 0, tPoint.description, 0, descriptionArray.length);
        tPoint.dValue = point.dValue;
        tPoint.expireDays = point.expireDays;
        byte[] instanceArray = point.instance.trim().getBytes();
        System.arraycopy(instanceArray, 0, tPoint.instance, 0, instanceArray.length);
        byte[] instanceAttributeArray = point.instanceAttribute.trim().getBytes();
        System.arraycopy(instanceAttributeArray, 0, tPoint.instanceAttribute, 0, instanceAttributeArray.length);
        byte[] instanceAttributeDescArray = point.instanceAttributeDescription.trim().getBytes();
        System.arraycopy(instanceAttributeDescArray, 0, tPoint.instanceAttributeDescription, 0, instanceAttributeDescArray.length);
        tPoint.minimumUpdateFreq = point.minimumUpdateFreq;
        byte[] nameArray = point.name.trim().getBytes();
        System.arraycopy(nameArray, 0, tPoint.name, 0, nameArray.length);
        tPoint.nPrecision = point.nPrecision;
        tPoint.pointType = point.pointType;
        tPoint.status = point.status;
        tPoint.tTime = point.tTime;
        byte[] typeArray = point.type.trim().getBytes();
        System.arraycopy(typeArray, 0, tPoint.type, 0, typeArray.length);
        byte[] unitArray = point.type.trim().getBytes();
        System.arraycopy(unitArray, 0, tPoint.units, 0, unitArray.length);
        int ret = IRuntime.INSTANCE.UpdatePoint(_key, tPoint, null, null, (short)0);
        if (ret != 0) {
            throw new Exception("updatePoint error return  " + ret);
        }
    }

    public void deletePoint(DNAPointConfig point) throws Exception {
        HISTORY_POINT.ByValue tPoint = new HISTORY_POINT.ByValue();
        tPoint.deadBand = point.deadBand;
        byte[] descriptionArray = point.description.trim().getBytes();
        System.arraycopy(descriptionArray, 0, tPoint.description, 0, descriptionArray.length);
        tPoint.dValue = point.dValue;
        tPoint.expireDays = point.expireDays;
        byte[] instanceArray = point.instance.trim().getBytes();
        System.arraycopy(instanceArray, 0, tPoint.instance, 0, instanceArray.length);
        byte[] instanceAttributeArray = point.instanceAttribute.trim().getBytes();
        System.arraycopy(instanceAttributeArray, 0, tPoint.instanceAttribute, 0, instanceAttributeArray.length);
        byte[] instanceAttributeDescArray = point.instanceAttributeDescription.trim().getBytes();
        System.arraycopy(instanceAttributeDescArray, 0, tPoint.instanceAttributeDescription, 0, instanceAttributeDescArray.length);
        tPoint.minimumUpdateFreq = point.minimumUpdateFreq;
        byte[] nameArray = point.name.trim().getBytes();
        System.arraycopy(nameArray, 0, tPoint.name, 0, nameArray.length);
        tPoint.nPrecision = point.nPrecision;
        tPoint.pointType = point.pointType;
        tPoint.status = point.status;
        tPoint.tTime = point.tTime;
        byte[] typeArray = point.type.trim().getBytes();
        System.arraycopy(typeArray, 0, tPoint.type, 0, typeArray.length);
        byte[] unitArray = point.type.trim().getBytes();
        System.arraycopy(unitArray, 0, tPoint.units, 0, unitArray.length);
        int ret = IRuntime.INSTANCE.DeletePoint(_key, tPoint);
        if (ret != 0) {
            throw new Exception("deletePoint error return  " + ret);
        }
    }

    static void apiGetRealtimeTagValues(String ... points) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAVal[] result = entry.getRealtimeTagValues(points);
        long end = System.currentTimeMillis();
        DNAVal[] dNAValArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            DNAVal set = dNAValArray[n2];
            System.out.println(String.valueOf(set.DValue) + " ");
            ++n2;
        }
        System.out.println("getRealtimeTagValues cost : " + (end - start) + " ms.");
    }

    static void apiGetHistSnap(String point, String startTime, String endTime, int period) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAVal[] result = entry.getHistSnap(point, entry.parseDateStringToUTC(startTime), entry.parseDateStringToUTC(endTime), period);
        long end = System.currentTimeMillis();
        DNAVal[] dNAValArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            DNAVal set = dNAValArray[n2];
            System.out.println(String.valueOf(set.DValue) + " " + set.Time);
            ++n2;
        }
        System.out.println("getHistSnap cost : " + (end - start) + " ms.");
    }

    static void apiGetHistStat(String point, String startTime, String endTime, int period) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAStatVal[] result = entry.getHistStat(point, entry.parseDateStringToUTC(startTime), entry.parseDateStringToUTC(endTime), period);
        long end = System.currentTimeMillis();
        DNAStatVal[] dNAStatValArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            DNAStatVal set = dNAStatValArray[n2];
            System.out.println(String.valueOf(set.avg.DValue) + " ");
            System.out.println(String.valueOf(set.max.DValue) + " ");
            System.out.println(String.valueOf(set.min.DValue) + " ");
            System.out.println("------------------------------------------");
            ++n2;
        }
        System.out.println("getHistStat cost : " + (end - start) + " ms.");
    }

    static void apiGetHistRaw(String point, String startTime, String endTime) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAVal[] result = entry.getHistRaw(point, entry.parseDateStringToUTC(startTime), entry.parseDateStringToUTC(endTime));
        long end = System.currentTimeMillis();
        DNAVal[] dNAValArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            DNAVal set = dNAValArray[n2];
            System.out.println(String.valueOf(set.DValue) + " " + set.Time);
            ++n2;
        }
        System.out.println("getHistRaw cost : " + (end - start) + " ms.");
    }

    static void apiSendMultiPoint() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        DNAPointVal[] result = new DNAPointVal[2];
        result[0] = new DNAPointVal();
        result[0].Name = "XBQ1";
        result[0].Val.Time = 10;
        result[0].Val.Status = (short)3;
        result[0].Val.DValue = 123.0;
        result[1] = new DNAPointVal();
        result[1].Name = "XBQ.ToAct";
        result[1].Val.Time = 10;
        result[1].Val.Status = (short)3;
        result[1].Val.DValue = 123.0;
        entry.sendMultiPoint(result);
    }

    static void apiSendSinglePoint() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        DNAVal[] recs = new DNAVal[2];
        recs[0] = new DNAVal();
        recs[0].Time = 10;
        recs[0].Status = (short)3;
        recs[0].DValue = 123.0;
        recs[1] = new DNAVal();
        recs[1].Time = 12;
        recs[1].Status = (short)3;
        recs[1].DValue = 144.0;
        entry.sendSinglePoint("00000002", recs);
    }

    static void apiGetHistMatrix(String time, String ... points) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAVal[] result = entry.getHistMatrix(points, entry.parseDateStringToUTC(time));
        long end = System.currentTimeMillis();
        DNAVal[] dNAValArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            DNAVal set = dNAValArray[n2];
            System.out.println(String.valueOf(set.DValue) + " " + set.Time);
            ++n2;
        }
        System.out.println("getHistMatrix cost : " + (end - start) + " ms.");
    }

    static void apiUpdatePointData() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        DNAVal[] recs = new DNAVal[2];
        recs[0] = new DNAVal();
        recs[0].Time = 10;
        recs[0].Status = (short)3;
        recs[0].DValue = 123.0;
        recs[1] = new DNAVal();
        recs[1].Time = 12;
        recs[1].Status = (short)3;
        recs[1].DValue = 144.0;
        entry.updatePointData("00000002", recs);
    }

    static void apiDeletePointData() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        entry.deletePointData("00000002", entry.parseDateStringToUTC("2013-11-25 00:52:08"), entry.parseDateStringToUTC("2013-11-25 05:41:28"));
    }

    static DNAPointConfig apiGetPointInfo(String point) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        DNAPointConfig config = entry.getPointInfo(point);
        System.out.println(String.valueOf(config.name) + " " + config.description + " " + config.instanceAttributeDescription + " " + config.dValue + " " + config.tTime);
        return config;
    }

    static void apiLoadAllType() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAType[] types = entry.loadAllTypes();
        long end = System.currentTimeMillis();
        DNAType[] dNATypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            DNAType type = dNATypeArray[n2];
            System.out.println(String.valueOf(type.Name) + " : " + type.instanceCount);
            ++n2;
        }
        System.out.println("loadAllTypes cost : " + (end - start) + " ms.");
    }

    static void apiGetPointInstances() throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAPointInstanceInfo[] instances = entry.getPointInstances();
        long end = System.currentTimeMillis();
        DNAPointInstanceInfo[] dNAPointInstanceInfoArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            DNAPointInstanceInfo instance = dNAPointInstanceInfoArray[n2];
            System.out.println(String.valueOf(instance.name) + " (" + instance.description + "): " + instance.count);
            ++n2;
        }
        System.out.println(String.valueOf(instances.length) + " getPointInstances cost : " + (end - start) + " ms.");
    }

    static void apiSearchInstances(String type, String description, String system, String subSystem) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAPointInstanceInfo[] instances = entry.searchInstance(type, description, system, subSystem);
        long end = System.currentTimeMillis();
        DNAPointInstanceInfo[] dNAPointInstanceInfoArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            DNAPointInstanceInfo instance = dNAPointInstanceInfoArray[n2];
            System.out.println(String.valueOf(instance.name) + " (" + instance.description + "): " + instance.count);
            ++n2;
        }
        System.out.println("searchInstance cost : " + (end - start) + " ms.");
    }

    static void apiGetInstancePoints(String instance) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAPointConfig[] configs = entry.getInstancePoints(instance);
        long end = System.currentTimeMillis();
        DNAPointConfig[] dNAPointConfigArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            DNAPointConfig config = dNAPointConfigArray[n2];
            System.out.println(config.description);
            ++n2;
        }
        System.out.println(String.valueOf(configs.length) + " getInstancePoints cost : " + (end - start) + " ms.");
    }

    static void apiGetHistoryPoints(String name, String desc, String instance, String instanceAttribute, String instanceAttributeDesc, String type) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        DNAPointConfig[] configs = entry.getHistoryPoints(name, desc, instance, instanceAttribute, instanceAttributeDesc, type);
        long end = System.currentTimeMillis();
        DNAPointConfig[] dNAPointConfigArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            DNAPointConfig config = dNAPointConfigArray[n2];
            System.out.println(config.description);
            ++n2;
        }
        System.out.println(String.valueOf(configs.length) + " getHistoryPoints cost : " + (end - start) + " ms.");
    }

    static void apiCreatePoint(DNAPointConfig point) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        entry.login("ybsystem", "ybSoftwareEdos20130607");
        long start = System.currentTimeMillis();
        entry.createPoint(point);
        long end = System.currentTimeMillis();
    }

    static void apiUpdatePoint(DNAPointConfig point) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        entry.updatePoint(point);
        long end = System.currentTimeMillis();
    }

    static void apiDeletePoint(DNAPointConfig point) throws Exception {
        ApiEntry entry = new ApiEntry(ip, port);
        long start = System.currentTimeMillis();
        entry.deletePoint(point);
        long end = System.currentTimeMillis();
    }

    private static String fill(String input, int size, char symbol) {
        while (input.length() < size) {
            input = String.valueOf(symbol) + input;
        }
        return input;
    }

    public static void main(String[] args) throws Exception {
        String[] points = new String[10000];
        int i = 0;
        while (i < points.length) {
            points[i] = ApiEntry.fill(String.valueOf(i + 1), 8, '0');
            ++i;
        }
        DNAPointConfig config = ApiEntry.apiGetPointInfo("WLDF_11P01005");
        config.name = "567";
        config.instanceAttribute = "attr";
        ApiEntry.apiCreatePoint(config);
    }
}

