/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.views.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class TagUtils {
    public static final String KEY_SCRIPT_REF_MAP = "hcks_taglib_script_ref_map";
    public static final String KEY_CSS_MAP = "hcks_taglib_css_map";
    public static final String KEY_SCRIPT_ONREADY = "hcks_taglib_script_onready";

    private static Map getJspContextMap(String mapKey, JspContext pageContext, boolean trySetIfNull) {
        HashMap refMap = (HashMap)pageContext.getAttribute(mapKey);
        if (trySetIfNull && refMap == null) {
            refMap = new HashMap();
            pageContext.setAttribute(mapKey, refMap);
        }
        return refMap;
    }

    private static List getJspContextList(String listKey, JspContext pageContext, boolean trySetIfNull) {
        ArrayList list = (ArrayList)pageContext.getAttribute(listKey);
        if (trySetIfNull && list == null) {
            list = new ArrayList();
            pageContext.setAttribute(listKey, list);
        }
        return list;
    }

    public static Map getScriptRefMap(JspContext pageContext) {
        return TagUtils.getJspContextMap(KEY_SCRIPT_REF_MAP, pageContext, false);
    }

    public static List getOnreadyScript(JspContext pageContext) {
        return TagUtils.getJspContextList(KEY_SCRIPT_ONREADY, pageContext, false);
    }

    public static boolean registerRefScript(String key, String scriptLink, JspContext pageContext) {
        Map scriptMap = TagUtils.getJspContextMap(KEY_SCRIPT_REF_MAP, pageContext, true);
        if (scriptMap.containsKey(key)) {
            return false;
        }
        if (scriptLink.startsWith("/") && pageContext instanceof PageContext) {
            scriptLink = String.valueOf(((PageContext)pageContext).getServletContext().getContextPath()) + scriptLink;
        }
        scriptMap.put(key, scriptLink);
        return true;
    }

    public static boolean registerRefCss(String key, String cssLink, JspContext pageContext) {
        Map cssMap = TagUtils.getJspContextMap(KEY_CSS_MAP, pageContext, true);
        if (cssMap.containsKey(key)) {
            return false;
        }
        if (cssLink.startsWith("/") && pageContext instanceof PageContext) {
            cssLink = String.valueOf(((PageContext)pageContext).getServletContext().getContextPath()) + cssLink;
        }
        cssMap.put(key, cssLink);
        return true;
    }

    public static void registerOnreadyScript(String script, JspContext pageContext) {
        List scriptList = TagUtils.getJspContextList(KEY_SCRIPT_ONREADY, pageContext, true);
        scriptList.add(script);
    }

    public static void outputJs(String script, boolean addTag, JspContext pageContext) throws JspException {
        try {
            if (addTag) {
                pageContext.getOut().println("<script type='text/javascript'>");
            }
            pageContext.getOut().println(script);
            if (addTag) {
                pageContext.getOut().println("</script>");
            }
        }
        catch (IOException e) {
            throw new JspException("Errors occured when output the script.", (Throwable)e);
        }
    }

    public static void outputJs(String script, boolean addTag, JspWriter writer) throws JspException {
        try {
            if (addTag) {
                writer.println("<script type='text/javascript'>");
            }
            writer.println(script);
            if (addTag) {
                writer.println("</script>");
            }
        }
        catch (IOException e) {
            throw new JspException("Errors occured when output the script.", (Throwable)e);
        }
    }
}

