/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.views.components.grid;

import cn.gyee.appsoft.framework.commons.util.StringUtils;
import cn.gyee.appsoft.framework.core.web.views.components.JeeComponent;
import cn.gyee.appsoft.framework.core.web.views.components.grid.GridColumn;
import cn.gyee.appsoft.framework.core.web.views.components.grid.Group;
import cn.gyee.appsoft.framework.core.web.views.components.grid.Pager;
import cn.gyee.appsoft.framework.core.web.views.tag.TagUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class Grid
extends JeeComponent {
    public static final String TEMPLATE = "grid.ftl";
    public static final String KEY_DEFAULT_SORTNAME = "sortname";
    public static final String KEY_DEFAULT_SORTORDER = "sortorder";
    private Collection list;
    private Pager pager;
    private Iterator rowIterator;
    private Iterator<GridColumn> colIterator;
    private List<String> rowsHTML = new ArrayList<String>();
    private List<Group> groups = new ArrayList<Group>();
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private StringBuilder rowDataBuffer;
    private StringBuilder headerDataBuffer;
    private int currIndex = 0;
    private Object currItem;
    private String itemName;
    private String multiSelect = "false";
    private String height;
    private String width;
    private String resizable;
    private String columnsTogglable;
    private String title;
    private String displayHeader = "true";
    private String useAjax;
    private String loadUrl;
    private String method;
    private String sortName;
    private String sortOrder;
    private String selectField = null;
    private String selectName;
    private String filterField = null;
    private String filterValue = null;
    private String ajaxDataHandler = null;
    private String loadSuccessHandler = null;
    private String restHeight;
    private String plain;
    private String dbclickHandler;
    private String contextMenu;
    private String status;
    private Object[] selectedValues = null;
    private String hideOnEmpty;
    private String cssStyle;
    private int num;
    private String realTime;
    private String striped;
    private String refreshSecond;

    public Grid(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    @Override
    public boolean usesBody() {
        return true;
    }

    @Override
    public boolean startTag(Writer writer) throws JspException {
        if (this.getList() == null && StringUtils.isTrue(this.getHideOnEmpty())) {
            return false;
        }
        if (this.getSortName() == null) {
            this.setSortName(this.req.getParameter(KEY_DEFAULT_SORTNAME));
        }
        if (this.getSortOrder() == null) {
            this.setSortOrder(this.req.getParameter(KEY_DEFAULT_SORTORDER));
        }
        this.println((JspWriter)writer, "<table id=\"%s\" style=\"%s\" >", this.id, this.cssStyle);
        return super.startTag(writer);
    }

    @Override
    public boolean endTag(Writer writer, String body) throws JspException {
        if (this.getCurrIndex() != 0 || !StringUtils.isTrue(this.getHideOnEmpty())) {
            this.printRows(writer);
            this.println((JspWriter)writer, "</table>");
            TagUtils.outputJs(this.mergeTemplate(TEMPLATE, this, this.getStack()), false, (JspWriter)writer);
        }
        return false;
    }

    public void appendColumnData(String columnData) {
        this.rowDataBuffer.append(columnData);
    }

    public void appendHeaderData(String headerData) {
        this.headerDataBuffer.append(headerData);
    }

    public void appendRowData(String rowHTML) {
        this.rowsHTML.add(rowHTML);
    }

    public void addGridColumn(GridColumn gridColumn) {
        this.columns.add(gridColumn);
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public void printRows(Writer writer) throws JspException {
        try {
            if (StringUtils.isTrue(this.displayHeader)) {
                writer.write("<thead>");
                writer.write(this.headerDataBuffer.toString());
                writer.write("</thead>");
            }
            writer.write("<tbody>");
            for (String rowHTML : this.rowsHTML) {
                writer.write(rowHTML);
            }
            writer.write("</tbody>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private void ensureRowIterator() {
        if (this.rowIterator == null) {
            if (this.list == null) {
                this.rowIterator = new ArrayList(0).iterator();
                return;
            }
            boolean needSort = false;
            if (!this.groups.isEmpty()) {
                for (Group group : this.groups) {
                    if (group.getFunctionFields().isEmpty()) continue;
                    needSort = true;
                    break;
                }
            }
            if (needSort) {
                ArrayList items = new ArrayList(this.list);
                Collections.sort(items, new ItemComparator(this.getStack()));
                this.rowIterator = items.iterator();
            } else {
                this.rowIterator = this.list.iterator();
            }
        }
    }

    private void ensureOutputReady() {
        if (this.rowDataBuffer != null) {
            this.rowDataBuffer.append("</tr>");
            this.rowsHTML.add(this.rowDataBuffer.toString());
        }
        if (this.headerDataBuffer == null) {
            this.headerDataBuffer = new StringBuilder();
            this.headerDataBuffer.append("<tr>\n");
        } else if (this.currIndex <= 1) {
            this.headerDataBuffer.append("</tr>");
        }
    }

    private void outputNewLine() {
        if (this.rowDataBuffer == null) {
            this.rowDataBuffer = new StringBuilder();
        } else {
            this.rowDataBuffer.delete(0, this.rowDataBuffer.length());
        }
        this.rowDataBuffer.append("<tr>");
    }

    public boolean iterateRow() {
        this.ensureRowIterator();
        this.ensureOutputReady();
        if (this.itemName != null) {
            this.getPageContext().removeAttribute(this.itemName);
        }
        if (this.status != null) {
            this.getPageContext().removeAttribute(this.status);
        }
        if (this.currIndex > 0) {
            this.stack.pop();
            if (StringUtils.isTrue(this.useAjax)) {
                return false;
            }
        }
        this.currItem = null;
        if (this.rowIterator.hasNext()) {
            this.currItem = this.rowIterator.next();
            if (StringUtils.notEmp(this.itemName)) {
                this.getPageContext().setAttribute(this.itemName, this.currItem);
            }
            if (StringUtils.notEmp(this.status)) {
                this.getPageContext().setAttribute(this.status, (Object)new IteratorStatus(this.currIndex, this.list.size()));
            }
            this.stack.push(this.currItem);
            this.outputNewLine();
            ++this.currIndex;
            if (this.currIndex > 1) {
                this.colIterator = this.columns.iterator();
            }
            return true;
        }
        return false;
    }

    public int getNum() {
        return this.num;
    }

    public String getLoadSuccessHandler() {
        return this.loadSuccessHandler;
    }

    public void setLoadSuccessHandler(String loadSuccessHandler) {
        this.loadSuccessHandler = loadSuccessHandler;
    }

    public String getRefreshSecond() {
        return this.refreshSecond;
    }

    public void setRefreshSecond(String refreshSecond) {
        this.refreshSecond = refreshSecond;
    }

    public String getStriped() {
        return this.striped;
    }

    public void setStriped(String striped) {
        this.striped = striped;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public GridColumn iterateColumn() {
        if (this.currIndex <= 1) {
            return null;
        }
        return this.colIterator.next();
    }

    public Collection getList() {
        return this.list;
    }

    public boolean setList(Collection list) {
        Collection collection = this.list = list == null ? new ArrayList(0) : list;
        return this.list.size() > 0;
    }

    public Pager getPager() {
        return this.pager;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public Iterator getRowIterator() {
        return this.rowIterator;
    }

    public void setRowIterator(Iterator rowIterator) {
        this.rowIterator = rowIterator;
    }

    public Iterator<GridColumn> getColIterator() {
        return this.colIterator;
    }

    public void setColIterator(Iterator<GridColumn> colIterator) {
        this.colIterator = colIterator;
    }

    public List<String> getRowsHTML() {
        return this.rowsHTML;
    }

    public void setRowsHTML(List<String> rowsHTML) {
        this.rowsHTML = rowsHTML;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public List<GridColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<GridColumn> columns) {
        this.columns = columns;
    }

    public StringBuilder getRowDataBuffer() {
        return this.rowDataBuffer;
    }

    public void setRowDataBuffer(StringBuilder rowDataBuffer) {
        this.rowDataBuffer = rowDataBuffer;
    }

    public StringBuilder getHeaderDataBuffer() {
        return this.headerDataBuffer;
    }

    public void setHeaderDataBuffer(StringBuilder headerDataBuffer) {
        this.headerDataBuffer = headerDataBuffer;
    }

    public int getCurrIndex() {
        return this.currIndex;
    }

    public void setCurrIndex(int currIndex) {
        this.currIndex = currIndex;
    }

    public Object getCurrItem() {
        return this.currItem;
    }

    public void setCurrItem(Object currItem) {
        this.currItem = currItem;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(String multiSelect) {
        this.multiSelect = multiSelect;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getResizable() {
        return this.resizable;
    }

    public void setResizable(String resizable) {
        this.resizable = resizable;
    }

    public String getColumnsTogglable() {
        return this.columnsTogglable;
    }

    public void setColumnsTogglable(String columnsTogglable) {
        this.columnsTogglable = columnsTogglable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDisplayHeader() {
        return this.displayHeader;
    }

    public void setDisplayHeader(String displayHeader) {
        this.displayHeader = displayHeader;
    }

    public String getUseAjax() {
        return this.useAjax;
    }

    public void setUseAjax(String useAjax) {
        this.useAjax = useAjax;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public void setLoadUrl(String loadUrl) {
        this.loadUrl = loadUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSelectField() {
        return this.selectField;
    }

    public void setSelectField(String selectField) {
        this.selectField = selectField;
    }

    public String getSelectName() {
        return this.selectName;
    }

    public void setSelectName(String selectName) {
        this.selectName = selectName;
    }

    public String getFilterField() {
        return this.filterField;
    }

    public void setFilterField(String filterField) {
        this.filterField = filterField;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public String getAjaxDataHandler() {
        return this.ajaxDataHandler;
    }

    public void setAjaxDataHandler(String ajaxDataHandler) {
        this.ajaxDataHandler = ajaxDataHandler;
    }

    public String getRestHeight() {
        return this.restHeight;
    }

    public void setRestHeight(String restHeight) {
        this.restHeight = restHeight;
    }

    public String getPlain() {
        return this.plain;
    }

    public void setPlain(String plain) {
        this.plain = plain;
    }

    public String getDbclickHandler() {
        return this.dbclickHandler;
    }

    public void setDbclickHandler(String dbclickHandler) {
        this.dbclickHandler = dbclickHandler;
    }

    public String getContextMenu() {
        return this.contextMenu;
    }

    public void setContextMenu(String contextMenu) {
        this.contextMenu = contextMenu;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Object[] getSelectedValues() {
        return this.selectedValues;
    }

    public void setSelectedValues(Object[] selectedValues) {
        this.selectedValues = selectedValues;
    }

    public String getHideOnEmpty() {
        return this.hideOnEmpty;
    }

    public void setHideOnEmpty(String hideOnEmpty) {
        this.hideOnEmpty = hideOnEmpty;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getRealTime() {
        return this.realTime;
    }

    public void setRealTime(String realTime) {
        this.realTime = realTime;
    }

    class ItemComparator
    implements Comparator {
        private ValueStack _vs;

        ItemComparator(ValueStack stack) {
            this._vs = stack;
        }

        public int compare(Object obj, Object objnext) {
            if (obj == objnext) {
                return 0;
            }
            if (obj == null) {
                return -1;
            }
            if (objnext == null) {
                return 1;
            }
            Object[] prop1 = new Object[Grid.this.groups.size()];
            Object[] prop2 = new Object[Grid.this.groups.size()];
            try {
                int i = Grid.this.groups.size() - 1;
                while (i >= 0) {
                    Group gm = (Group)Grid.this.groups.get(i);
                    if (gm.getField() != null) {
                        Comparable obj2;
                        Comparable obj1;
                        int r;
                        this._vs.push(obj);
                        prop1[i] = this._vs.findValue(gm.getField());
                        this._vs.pop();
                        this._vs.push(objnext);
                        prop2[i] = this._vs.findValue(gm.getField());
                        this._vs.pop();
                        if (prop1[i] instanceof Comparable && prop2[i] instanceof Comparable && (r = (obj1 = (Comparable)prop1[i]).compareTo(obj2 = (Comparable)prop2[i])) != 0) {
                            return "desc".equals(gm.getOrder()) ? -1 * r : r;
                        }
                    }
                    --i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to compare the property.", e);
            }
            return 0;
        }
    }

    public static class IteratorStatus {
        int index;
        int count;

        public IteratorStatus() {
        }

        public IteratorStatus(int index, int count) {
            this.index = index;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isEven() {
            return this.index % 2 == 0;
        }

        public boolean isOdd() {
            return this.index % 2 == 1;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.count - 1;
        }

        public void next() {
            if (this.index < this.count - 1) {
                ++this.index;
            }
        }
    }
}

