/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.views.components.grid;

import cn.gyee.appsoft.framework.commons.util.TextUtils;
import cn.gyee.appsoft.framework.core.web.views.components.JeeComponent;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class Formatter
extends JeeComponent {
    private String value;
    private String format;
    private boolean escape;
    private String defaultValue;

    public Formatter(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
    }

    @Override
    public boolean startTag(Writer writer) throws JspException {
        boolean result = super.startTag(writer);
        try {
            Object r = null;
            if (this.format == null) {
                r = this.getStack().findValue("%{" + this.value + "}");
            } else {
                StringBuilder key = new StringBuilder().append("%{getText('").append(this.format).append("', {").append(this.value).append("})}");
                r = this.getStack().findValue(key.toString());
            }
            if (r == null || "null".equals(r)) {
                r = this.defaultValue;
            }
            if (r != null) {
                if (r instanceof String && this.escape) {
                    r = TextUtils.htmlEncode((String)r);
                }
                ((JspWriter)writer).print(r);
            }
            result = false;
        }
        catch (IOException e) {
            result = false;
            throw new JspException((Throwable)e);
        }
        return result;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

