/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.interceptor;

import cn.gyee.appsoft.framework.core.SkipSessionInAction;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OpenSessionInActionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(OpenSessionInActionInterceptor.class);
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;
    private FlushMode flushMode = FlushMode.MANUAL;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    protected SessionFactory lookupSessionFactory() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInActionInterceptor"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        FlushMode flushMode = this.getFlushMode();
        if (flushMode != null) {
            session.setFlushMode(flushMode);
        }
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession((Session)session);
    }

    public void destroy() {
        super.destroy();
    }

    public void init() {
        super.init();
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        SkipSessionInAction skipSession = invocation.getAction().getClass().getAnnotation(SkipSessionInAction.class);
        if (skipSession != null) {
            String[] methods = skipSession.methods();
            if (methods == null || methods.length == 0) {
                return invocation.invoke();
            }
            int i = 0;
            while (i < methods.length) {
                if (methods[i].equals(invocation.getProxy().getMethod())) {
                    return invocation.invoke();
                }
                ++i;
            }
        }
        SessionFactory sessionFactory = this.lookupSessionFactory();
        boolean participate = false;
        if (this.isSingleSession()) {
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                participate = true;
            } else {
                logger.debug((Object)"Opening single Hibernate Session in OpenSessionInActionInterceptor");
                Session session = this.getSession(sessionFactory);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
            }
        } else if (SessionFactoryUtils.isDeferredCloseActive((SessionFactory)sessionFactory)) {
            participate = true;
        } else {
            SessionFactoryUtils.initDeferredClose((SessionFactory)sessionFactory);
        }
        try {
            String string = invocation.invoke();
            return string;
        }
        finally {
            if (!participate) {
                if (this.isSingleSession()) {
                    SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                    logger.debug((Object)"Closing single Hibernate Session in OpenSessionInActionInterceptor");
                    this.closeSession(sessionHolder.getSession(), sessionFactory);
                } else {
                    SessionFactoryUtils.processDeferredClose((SessionFactory)sessionFactory);
                }
            }
        }
    }
}

