/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.security;

import cn.gyee.appsoft.framework.core.security.UserType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Principal;

public class User
implements Principal,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 1114354794469567760L;
    private static final String USER_ADMIN = "admin";
    private String id;
    private String account;
    private String stafferId;
    private String name;
    private UserType type;
    private String deptId;
    private String deptName;
    private String parentDeptId;
    private String parentDeptName;
    private String stafferTypeId;
    private String stafferTypeName;
    private String extendIds;
    private boolean director;

    public User() {
    }

    public User(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getStafferId() {
        return this.stafferId;
    }

    public void setStafferId(String stafferId) {
        this.stafferId = stafferId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserType getType() {
        return this.type;
    }

    public void setType(UserType type) {
        this.type = type;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getParentDeptId() {
        return this.parentDeptId;
    }

    public void setParentDeptId(String parentDeptId) {
        this.parentDeptId = parentDeptId;
    }

    public String getParentDeptName() {
        return this.parentDeptName;
    }

    public void setParentDeptName(String parentDeptName) {
        this.parentDeptName = parentDeptName;
    }

    public boolean getDirector() {
        return this.director;
    }

    public void setDirector(boolean director) {
        this.director = director;
    }

    private String readString(ObjectInput in) throws IOException {
        byte[] data = new byte[in.read()];
        if (data.length > 0) {
            in.read(data);
            return new String(data, "UTF-8");
        }
        return null;
    }

    private void writeString(ObjectOutput out, String r) throws IOException {
        if (r == null) {
            out.write(0);
        } else {
            byte[] data = r.getBytes("UTF-8");
            if (data.length <= 127) {
                out.write(data.length);
                out.write(data);
            } else {
                throw new IOException("The length of written data is too large.");
            }
        }
    }

    public boolean superAdmin() {
        return USER_ADMIN.equalsIgnoreCase(this.id);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = this.readString(in);
        this.stafferId = this.readString(in);
        this.account = this.readString(in);
        this.name = this.readString(in);
        this.deptId = this.readString(in);
        this.deptName = this.readString(in);
        this.parentDeptId = this.readString(in);
        this.parentDeptName = this.readString(in);
        this.director = in.readBoolean();
        this.stafferTypeId = this.readString(in);
        this.stafferTypeName = this.readString(in);
        this.extendIds = this.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeString(out, this.id);
        this.writeString(out, this.stafferId);
        this.writeString(out, this.account);
        this.writeString(out, this.name);
        this.writeString(out, this.deptId);
        this.writeString(out, this.deptName);
        this.writeString(out, this.parentDeptId);
        this.writeString(out, this.parentDeptName);
        this.writeString(out, this.stafferTypeId);
        this.writeString(out, this.stafferTypeName);
        out.writeBoolean(this.director);
        this.writeString(out, this.extendIds);
    }

    public String getStafferTypeId() {
        return this.stafferTypeId;
    }

    public void setStafferTypeId(String stafferTypeId) {
        this.stafferTypeId = stafferTypeId;
    }

    public String getStafferTypeName() {
        return this.stafferTypeName;
    }

    public void setStafferTypeName(String stafferTypeName) {
        this.stafferTypeName = stafferTypeName;
    }

    public String getExtendIds() {
        return this.extendIds;
    }

    public void setExtendIds(String extendIds) {
        this.extendIds = extendIds;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("user_id = ").append(this.id);
        sb.append(";username=").append(this.name);
        sb.append(";staffer_id").append(this.stafferId);
        sb.append(";dept_id=").append(this.deptId);
        sb.append(";dept_name=").append(this.deptName);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return User.class.hashCode() + this.id.hashCode() + 101;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        return ((User)obj).id.equals(this.id);
    }

    public Object clone() {
        User user = new User();
        user.id = this.id;
        user.name = this.name;
        user.account = this.account;
        user.deptId = this.deptId;
        user.deptName = this.deptName;
        user.stafferId = this.stafferId;
        user.type = this.type;
        user.parentDeptId = this.parentDeptId;
        user.parentDeptName = this.parentDeptName;
        user.director = this.director;
        user.extendIds = this.extendIds;
        return user;
    }
}

