/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.orm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

public class QueryOrder
implements Serializable {
    private static final long serialVersionUID = 5291198501266064857L;
    private boolean ascending;
    private boolean ignoreCase;
    private String propertyName;

    public String toString() {
        return String.valueOf(this.propertyName) + " " + (this.ascending ? "asc" : "desc");
    }

    public QueryOrder(String propertyName, boolean ascending) {
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    public static QueryOrder asc(String propertyName) {
        return new QueryOrder(propertyName, true);
    }

    public static QueryOrder desc(String propertyName) {
        return new QueryOrder(propertyName, false);
    }

    public QueryOrder ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    private Order toHibernateOrder(String propertyName) {
        Order order = null;
        order = this.ascending ? Order.asc((String)propertyName) : Order.desc((String)propertyName);
        if (this.ignoreCase) {
            this.ignoreCase();
        }
        return order;
    }

    public void appendHibernateOrder(Map<String, Criteria> criCache) {
        Criteria criteria = criCache.get(null);
        int assPos = this.propertyName.indexOf(".");
        if (assPos == -1) {
            criteria.addOrder(this.toHibernateOrder(this.propertyName));
        } else {
            String pn = this.propertyName;
            while (assPos != -1) {
                String key = this.propertyName.substring(0, assPos);
                Criteria assCri = null;
                if (criCache.containsKey(key)) {
                    assCri = criCache.get(key);
                } else {
                    assCri = criteria.createCriteria(pn.substring(0, pn.indexOf(".")), 1);
                    criCache.put(key, assCri);
                }
                pn = this.propertyName.substring(assPos + 1);
                assPos = this.propertyName.indexOf(".", assPos + 1);
                criteria = assCri;
            }
            criteria.addOrder(this.toHibernateOrder(pn));
        }
    }

    public void appendHibernateOrder(Criteria c) {
        HashMap<String, Criteria> cache = new HashMap<String, Criteria>(2);
        cache.put(null, c);
        this.appendHibernateOrder(cache);
    }

    public void appendSqlOrder(StringBuilder sb) {
        if (sb != null) {
            sb = new StringBuilder();
        }
        sb.append(" ").append(this.toString());
    }

    public void appendSqlOrder(StringBuilder sb, Boolean separator) {
        if (sb != null) {
            sb = new StringBuilder();
        }
        sb.append(" ");
        if (separator.booleanValue()) {
            sb.append(",");
        }
        sb.append(this.toString());
    }
}

