/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.commons.util;

import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String SIMPLE_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String[] TRUE_STRINGS = new String[]{"true", "yes", "on", "1", "y"};
    public static final String REGEX_IMG_SRC = "src=\"(.*?)\"";

    public static String convertEncoding(String str) {
        if (str == null) {
            return str;
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static List<String> getImg(String memo) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pa = Pattern.compile(REGEX_IMG_SRC, 32);
        Matcher matcher = pa.matcher(memo);
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    private StringUtils() {
    }

    public static String concat(String ... strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            buff.append(strs[i]);
            ++i;
        }
        return buff.toString();
    }

    public static boolean empty(Object obj) {
        if (obj == null) {
            return true;
        }
        String str = obj instanceof String ? (String)obj : obj.toString();
        return str.length() == 0;
    }

    public static boolean notEmp(Object obj) {
        return !StringUtils.empty(obj);
    }

    public static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int toInt(String str) {
        return StringUtils.toInt(str, 0);
    }

    public static float toFloat(String str) {
        return StringUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return StringUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return StringUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isTrue(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < TRUE_STRINGS.length) {
            if (TRUE_STRINGS[i].equalsIgnoreCase(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFalse(String str) {
        return !StringUtils.isTrue(str);
    }

    public static String toDate(Timestamp ts) {
        if (ts == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_DATETIME_FORMAT);
        return df.format(ts);
    }

    public static Date formatTimestamp(Timestamp ts) {
        Date d1 = new Date(ts.getTime());
        String s1 = StringUtils.formatDate(d1, SIMPLE_DATETIME_FORMAT);
        return StringUtils.toDate(s1, SIMPLE_DATETIME_FORMAT);
    }

    public static Date toDate(String date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Failed to parse the String [%s] to Date.", date), e);
        }
    }

    public static Date toDate(String date) {
        return StringUtils.toDate(date, SIMPLE_DATETIME_FORMAT);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        return format.format(date);
    }

    public static String leftPad(int number) {
        return String.format("%010d", number);
    }

    public static String parseString(String[] arrs, String regex) {
        String result = "";
        if (arrs != null && arrs.length > 0) {
            int i = 0;
            while (i < arrs.length) {
                result = i == arrs.length - 1 ? String.valueOf(result) + arrs[i] : String.valueOf(result) + arrs[i] + regex;
                ++i;
            }
        }
        return result;
    }
}

