/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.commons.util;

import cn.gyee.appsoft.framework.commons.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private DateUtils() {
    }

    public static Date today() {
        return DateUtils.truncate(DateUtils.now());
    }

    public static Date now() {
        return new Date();
    }

    public static Date cons(int y, int m, int d) {
        Calendar cal = Calendar.getInstance();
        cal.set(y, m, d, 0, 0, 0);
        return cal.getTime();
    }

    public static Date cons(int y, int m, int d, int h, int mi, int s) {
        Calendar cal = Calendar.getInstance();
        cal.set(y, m, d, h, mi, s);
        return cal.getTime();
    }

    public static Calendar getCal(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date truncate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date truncDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date truncMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDays(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, month);
        return cal.getTime();
    }

    public Date addYears(Date date, int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, year);
        return cal.getTime();
    }

    public static Date addHours(Date date, int hour) {
        return new Date(date.getTime() + (long)(hour * 3600 * 1000));
    }

    public static Date addMinutes(Date date, int m) {
        return new Date(date.getTime() + (long)(m * 60 * 1000));
    }

    public static Date addSeconds(Date date, int s) {
        return new Date(date.getTime() + (long)(s * 1000));
    }

    public static long secondsConverHours(long seconds) {
        return (long)Math.floor(seconds / 60L / 60L);
    }

    public static int hoursDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 3600000L);
    }

    public static double hoursDiffForDouble(Date d1, Date d2) {
        return (double)Math.abs(d1.getTime() - d2.getTime()) / 3600000.0;
    }

    public static int minutesDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 60000L);
    }

    public static double minutesDiffForDouble(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / 60000L;
    }

    public static long secondsDiff(Date d1, Date d2) {
        return (long)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 1000L);
    }

    public static int daysDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 86400000L);
    }

    public static double daysDiffForDouble(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / 86400000L;
    }

    public static int monthsDiff(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(d1);
        cal2.setTime(d2);
        return Math.abs((cal1.get(1) - cal2.get(1)) * 12 + cal1.get(2) - cal2.get(2));
    }

    public int yearsDiff(Date d1, Date d2) {
        return DateUtils.getYear(d2) - DateUtils.getYear(d1) < 0 ? 0 : DateUtils.getYear(d2) - DateUtils.getYear(d1);
    }

    public static int getMonth(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(2);
    }

    public static int getYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(1);
    }

    public static int getDay(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(5);
    }

    public static Map<String, Integer> computeYMD(Date d1, Date d2) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Calendar srcCal = Calendar.getInstance();
        srcCal.setTime(d1);
        Calendar dstCal = Calendar.getInstance();
        dstCal.setTime(d2);
        int year = dstCal.get(1) - srcCal.get(1);
        int month = dstCal.get(2) - srcCal.get(2);
        int day = dstCal.get(5) - srcCal.get(5);
        year -= month > 0 ? 0 : (month < 0 ? 1 : (day >= 0 ? 0 : 1));
        month = month <= 0 ? (day > 0 ? 12 + month : 12 + month - 1) : (day >= 0 ? month : month - 1);
        dstCal.add(2, -1);
        day = day <= 0 ? DateUtils.daysForCalendar(dstCal) + day : day;
        map.put("day", day);
        map.put("month", month);
        map.put("year", year);
        return map;
    }

    public static int daysForCalendar(Calendar cal) {
        int maxDays = 0;
        int month = cal.get(2);
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                maxDays = 31;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                maxDays = 30;
                break;
            }
            case 1: {
                maxDays = DateUtils.isLeap(cal.get(1)) ? 29 : 28;
            }
        }
        return maxDays;
    }

    public static boolean isLeap(int year) {
        boolean leap = false;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            leap = true;
        }
        return leap;
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return StringUtils.formatDate(cal.getTime(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, cal.getMinimum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return StringUtils.formatDate(cal.getTime(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrtenYearFirstDay(int year) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        return format.format(c.getTime());
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtils.getFirstDayOfMonth(2014, 5));
        System.out.println(DateUtils.isLeap(2012));
        System.out.println(DateUtils.daysForCalendar(DateUtils.getCal(DateUtils.addMonths(DateUtils.now(), -9))));
    }
}

