/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.special;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.sportal.entry.SPUserInfo;
import com.secure.sportal.sdk.SPVPNClient;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.service.PortalSession;
import java.util.Properties;

public class YaWeiClient {
    public static void login(Context context, String vpnHost, int vpnPort, String appID, String accountName, String accountPwd, String extInfo, OnLoginListener listener) {
        Properties param = new Properties();
        param.put("vpn_host", vpnHost);
        param.put("vpn_port", (Object)vpnPort);
        param.put("auth_server", "\u4e9a\u5fae\u8ba4\u8bc1");
        param.put("auth_username", accountName);
        param.put("auth_password", accountPwd);
        param.put("extra_yawei_appid", appID);
        param.put("extra_yawei_accountname", accountName);
        param.put("extra_yawei_accountpwd", accountPwd);
        param.put("extra_yawei_extinfo", extInfo);
        SPVPNClient.login(context, param, new YWClientCallback(listener));
    }

    public static boolean encryptFile(String srcFile, String dstFile, String password) {
        return SPVPNTool.encryptFile(srcFile, dstFile, password);
    }

    public static boolean decryptFile(String srcFile, String dstFile, String password) {
        return SPVPNTool.decryptFile(srcFile, dstFile, password);
    }

    public static void logout() {
        SPVPNClient.logout();
    }

    private static class YWClientCallback
    implements SPVPNClient.OnVPNLoginCallback {
        private OnLoginListener listener;

        public YWClientCallback(OnLoginListener l) {
            this.listener = l;
        }

        @Override
        public void onVPNLoginMessage(int msgid, String errmsg) {
            String xmldata;
            SPUserInfo userinfo = PortalSession.instance(null).me();
            boolean succeeded = msgid == 0 && userinfo.uid > 0;
            String msgdata = "";
            if (null != userinfo.extra && !TextUtils.isEmpty((CharSequence)(xmldata = userinfo.extra.optString("xmldata")))) {
                msgdata = new String(Base64.decode((String)xmldata, (int)2));
            }
            if (!succeeded) {
                SPVPNClient.logout();
            }
            if (null != this.listener) {
                this.listener.onLoginResult(succeeded, msgdata);
            }
        }
    }

    public static interface OnLoginListener {
        public void onLoginResult(boolean var1, String var2);
    }
}

