/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.service;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.secure.comm.net.SPInetAddress;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.utils.SPTripleDes;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPOnlineInfo;
import com.secure.sportal.entry.SPPortalInfo;
import com.secure.sportal.entry.SPProxyServerOption;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.entry.SPUserInfo;
import com.secure.sportal.entry.SPortalConf;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.LoginReq;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.IPHostCacheDoer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class PortalSession {
    public static List<String> bypassPkgNames = new ArrayList<String>();
    public static List<SPInetAddress> bypassAddresses = new ArrayList<SPInetAddress>();
    public static AtomicBoolean hookDisabled = new AtomicBoolean(false);
    public static String hwaddr = "00-00-00-00-00-00";
    public static SPProxyServerOption proxyServerOption = new SPProxyServerOption();
    public static boolean disablePersist = false;
    private static String vpn_host = "";
    private static int vpn_port = 443;
    private static String vpn_sni = "";
    private static boolean vpn_ip_fixed = false;
    public String username = "";
    public String password = "";
    public SPPortalInfo portalInfo = new SPPortalInfo();
    public SPAuthServerInfo authsvr = new SPAuthServerInfo();
    public String app_identify = "";
    public GatewayReq loginBrokerReq = null;
    private SPUserInfo _me = new SPUserInfo();
    private SPUserDataInfo _userdata = new SPUserDataInfo();
    private IPHostCacheDoer _iphostCache;
    private SPLiteBundle _loginExtras;
    private Context _context;
    private static final String CACHE_LOGIN = "sp_cache_login";
    private static final String CACHE_AUTHSVR = "sp_cache_authsvr";
    private static final String CACHE_ME = "sp_cache_me";
    private static final String CACHE_USERDAT = "sp_cache_userdata";
    private static PortalSession _instance;

    public static synchronized PortalSession instance(Context context) {
        return null != _instance ? _instance : (_instance = new PortalSession(context));
    }

    public static PortalSession restore(Context context) {
        PortalSession session = PortalSession.instance(context);
        session.resetSessionData();
        return session;
    }

    private PortalSession(Context context) {
        PortalSession.setVpnAddress("", 443, null);
        this._iphostCache = new IPHostCacheDoer();
        this.loginBrokerReq = null;
        this.init(context);
    }

    private void init(Context context) {
        if (null != context && null == this._context) {
            this._context = context.getApplicationContext();
            SPNetUtil.isNetworkAvailable(this._context);
            hwaddr = SPNetUtil.getWifiMac(this._context);
            SPDeviceUtil.getDeviceInfo(this._context);
            long pkgtime = SPSystemUtil.getAppPackTime(this._context);
            SharedPreferences sp = this._context.getSharedPreferences("sportal", 0);
            if (sp.getLong("app_build_time", 0L) != pkgtime) {
                SPFileUtil.deletePrivateFile(this._context, CACHE_LOGIN);
                SPFileUtil.deletePrivateFile(this._context, CACHE_AUTHSVR);
                SPFileUtil.deletePrivateFile(this._context, CACHE_ME);
                SPFileUtil.deletePrivateFile(this._context, CACHE_USERDAT);
            } else if (pkgtime > 0L) {
                this.persist(false);
            }
            SPortalConf config = SPortalConf.load(this._context);
            this.app_identify = config.app_identify;
            if (!TextUtils.isEmpty((CharSequence)config.vpn_host)) {
                vpn_host = config.vpn_host;
                if (config.vpn_port != 443) {
                    vpn_port = config.vpn_port;
                }
                vpn_sni = config.vpn_sni;
                vpn_ip_fixed = config.vpn_ip_fixed;
                SPLibBridge.setVpnAddress(vpn_host, vpn_port, vpn_sni, vpn_ip_fixed);
            }
            this.resetSessionData();
        }
    }

    public static String vpnHost() {
        return vpn_host;
    }

    public static int vpnPort() {
        return vpn_port;
    }

    public static String vpnSNI() {
        return vpn_sni;
    }

    public boolean isLogin() {
        return this._me.uid > 0;
    }

    public static void setVpnAddress(String host, int port, String sni) {
        PortalSession.setVpnAddress(host, port, sni, false);
    }

    public static void setVpnAddress(String host, int port, String sni, boolean force) {
        PortalSession.setVpnAddress(host, port, sni, force, false);
    }

    public static void setVpnAddress(String host, int port, String sni, boolean force, boolean fixed) {
        if (!(port <= 0 || TextUtils.isEmpty((CharSequence)host) || SPStringUtil.equals(vpn_host, host) && vpn_port == port && SPStringUtil.equals(vpn_sni, sni))) {
            vpn_host = TextUtils.isEmpty((CharSequence)host) ? "" : host;
            vpn_port = port;
            vpn_sni = sni;
            SPLibBridge.setVpnAddress(vpn_host, vpn_port, vpn_sni, fixed);
        } else if (force) {
            SPLibBridge.setVpnAddress(vpn_host, vpn_port, vpn_sni, fixed);
        }
    }

    public void setLogin(SPUserInfo userinfo, SPLiteBundle extras) {
        this.loginBrokerReq = null;
        if (null != userinfo) {
            this._loginExtras = null != extras ? extras : new SPLiteBundle();
            this._me.copyFrom(userinfo);
        } else {
            this._me.copyFrom(new SPUserInfo());
            this._userdata.iphosts.clear();
            this._userdata.proxySvcList.clear();
            this._userdata.ncSvcList.clear();
            this.resetSessionData();
        }
        this.persist(true);
    }

    public SPUserInfo me() {
        return this._me;
    }

    public SPUserDataInfo userdata() {
        return this._userdata;
    }

    public void setUserdata(SPUserDataInfo data) {
        this._userdata = null != data ? data : new SPUserDataInfo();
        vpn_ip_fixed = this.portalInfo.vpnIPFixed;
        this.resetSessionData();
    }

    public boolean isTunnelEnable() {
        return SPLibBridge.isTunnelEnabled();
    }

    public boolean setTunnelEnable(boolean b) {
        boolean start = SPLibBridge.setTunnelEnabled(b);
        if (this._userdata.policy.pkgappNCEnable && this._userdata.ncSvcList.size() > 0) {
            SPNCServiceManagement.startOrStopNC(this._context, start, true, true);
        }
        return b;
    }

    public SPOnlineInfo onlineInfo() {
        if (this.isLogin()) {
            SPOnlineInfo info = new SPOnlineInfo();
            info.vpn_host = PortalSession.vpnHost();
            info.vpn_port = PortalSession.vpnPort();
            info.auth_server = this.authsvr.name;
            info.uid = this._userdata.uid;
            info.username = this.username;
            if (null != this._me.extra) {
                Iterator key = this._me.extra.keys();
                while (key.hasNext()) {
                    String k = (String)key.next();
                    Object v = this._me.extra.opt(k);
                    if (null == v) continue;
                    info.extra.put(k, v.toString());
                }
            }
            return info;
        }
        return null;
    }

    public void resetSessionData() {
        if (this._me.uid > 0) {
            Properties usrinfo = new Properties();
            usrinfo.put("eid", String.valueOf(this._me.eid));
            usrinfo.put("username", this._me.username);
            usrinfo.put("auth_type", String.valueOf(this._me.authsvr.sub_type));
            usrinfo.put("ticket", this._me.ticketstr);
            if (TextUtils.isEmpty((CharSequence)this._me.authJStr)) {
                usrinfo.put("login_json", this.makeLoginJSon());
            } else {
                usrinfo.put("login_json", this._me.authJStr);
            }
            usrinfo.put("tunnel_block_tlv", this._userdata.noBlockHeaderEnabled ? "0" : "1");
            usrinfo.put("sslsmx_cipher", this._userdata.smxAlgCipher);
            if (hookDisabled.get()) {
                usrinfo.put("net_hook_enable", "0");
                usrinfo.put("vspace_enable", "0");
            } else {
                usrinfo.put("net_hook_enable", this._userdata.proxySvcList.size() > 0 ? "1" : "0");
                usrinfo.put("vspace_enable", this._userdata.policy.vspaceEnable ? "1" : "0");
            }
            usrinfo.put("proto_version", this._userdata.proto_version);
            SPLibBridge.setBypass(bypassAddresses, bypassPkgNames);
            ArrayList<SPServiceInfo> svcList = new ArrayList<SPServiceInfo>();
            svcList.addAll(this._userdata.proxySvcList);
            svcList.addAll(this._userdata.ncSvcList);
            SPLibBridge.setUserData(this._me.uid, usrinfo, svcList, this._userdata.iphosts, this._userdata.policy, this._userdata.loads, proxyServerOption);
            this.flushIPHost();
        } else {
            new Thread(){

                @Override
                public void run() {
                    SPLibBridge.setUserData(0, null, null, null, null, null, null);
                }
            }.start();
        }
    }

    public String makeLoginJSon() {
        if (this._me.uid > 0) {
            return LoginReq.makeLoginJSon(this.authsvr.id, this.authsvr.sub_id, this.authsvr.sub_type, this.username, this.password, vpn_host, true, this._me.ticketstr, this._loginExtras);
        }
        return "";
    }

    public void flushIPHost() {
        this._iphostCache.flushCache(this._userdata.iphosts);
    }

    public void cleanup() {
        SPNCServiceManagement.stopNC(this._context);
        this.setLogin(null, null);
        this.deletePersistence();
    }

    private void deletePersistence() {
        try {
            this._context.deleteFile(CACHE_LOGIN);
            this._context.deleteFile(CACHE_AUTHSVR);
            this._context.deleteFile(CACHE_ME);
            this._context.deleteFile(CACHE_USERDAT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void persist(boolean store) {
        Properties login;
        if (null == this._context) {
            return;
        }
        if (disablePersist) {
            this.deletePersistence();
            return;
        }
        if (store) {
            login = new Properties();
            login.put("vpn_host", vpn_host);
            login.put("vpn_port", (Object)vpn_port);
            login.put("vpn_ip_fixed", vpn_ip_fixed ? "1" : "0");
            login.put("username", SPTripleDes.encrypt(this.username));
            login.put("password", SPTripleDes.encrypt(this.password));
            SPFileUtil.writeObject(this._context, CACHE_LOGIN, login);
            SPFileUtil.writeObject(this._context, CACHE_AUTHSVR, this.authsvr);
            JSONObject extra = this._me.extra;
            this._me.extra = null;
            SPFileUtil.writeObject(this._context, CACHE_ME, this._me);
            this._me.extra = extra;
            SPFileUtil.writeObject(this._context, CACHE_USERDAT, this._userdata);
        } else {
            login = (Properties)SPFileUtil.readObject(this._context, CACHE_LOGIN);
            if (null == login) {
                login = new Properties();
            }
            vpn_host = login.getProperty("vpn_host", "");
            vpn_port = SPStringUtil.propOptInt(login, "vpn_port", 443);
            vpn_sni = login.getProperty("vpn_sni", "");
            vpn_ip_fixed = login.getProperty("vpn_ip_fixed", "").equals("1");
            SPLibBridge.setVpnAddress(vpn_host, vpn_port, vpn_sni, vpn_ip_fixed);
            this.username = SPTripleDes.decrypt(login.getProperty("username", ""));
            this.password = SPTripleDes.decrypt(login.getProperty("password", ""));
            this.authsvr = (SPAuthServerInfo)SPFileUtil.readObject(this._context, CACHE_AUTHSVR);
            if (null == this.authsvr) {
                this.authsvr = new SPAuthServerInfo();
            }
            this._me = (SPUserInfo)SPFileUtil.readObject(this._context, CACHE_ME);
            if (null == this._me) {
                this._me = new SPUserInfo();
            }
            this._me.authsvr = this.authsvr;
            SPUserDataInfo userdata = (SPUserDataInfo)SPFileUtil.readObject(this._context, CACHE_USERDAT);
            this.setUserdata(null == userdata ? new SPUserDataInfo() : userdata);
        }
        SharedPreferences.Editor sp = this._context.getSharedPreferences("sportal", 0).edit();
        sp.putLong("app_build_time", SPSystemUtil.getAppPackTime(this._context)).apply();
    }
}

