/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid.uniq;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Point;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.utils.SPViewUtil;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.jni.SPLibBridge;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPUniqueIDUtil {
    public static JSONObject getDeviceFP(Context context) {
        JSONObject fp = new JSONObject();
        SPJSONUtil.put(fp, "os.name", "Android");
        SPJSONUtil.put(fp, "os.version", Build.VERSION.RELEASE);
        SPJSONUtil.put(fp, "os.rooted", SPDeviceUtil.isRooted() ? "1" : "0");
        byte[] data = SPFileUtil.readFile("/proc/version");
        if (null != data) {
            String kv = new String(data).trim();
            SPJSONUtil.put(fp, "os.kernel.version", kv);
        } else {
            SPJSONUtil.put(fp, "os.kernel.version", "");
        }
        SPJSONUtil.put(fp, "dev.name", SPDeviceUtil.getDeviceName(context));
        SPJSONUtil.put(fp, "dev.model", Build.MODEL);
        SPJSONUtil.put(fp, "dev.product", Build.PRODUCT);
        SPJSONUtil.put(fp, "dev.android_id", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        SPJSONUtil.put(fp, "dev.imei", "[md5]" + SPStringUtil.md5(SPDeviceUtil.getIMEI(context)));
        SPJSONUtil.put(fp, "dev.imsi", SPDeviceUtil.getIMSI(context));
        SPJSONUtil.put(fp, "dev.serial", Build.SERIAL);
        SPJSONUtil.put(fp, "dev.manufacturer", Build.MANUFACTURER);
        SPJSONUtil.put(fp, "dev.wifi.mac", SPNetUtil.getWifiMac(context));
        SPJSONUtil.put(fp, "dev.bluetooth.mac", SPDeviceUtil.getBluetoothAddress(context));
        Point ssize = SPViewUtil.screenSize(context);
        SPJSONUtil.put(fp, "dev.screen.width", String.valueOf(ssize.x));
        SPJSONUtil.put(fp, "dev.screen.height", String.valueOf(ssize.y));
        SPUniqueIDUtil.getBuildPropFP(fp);
        SPUniqueIDUtil.getStorageFP(context, fp);
        SPJSONUtil.put(fp, "net.hostname", SPSystemUtil.getProperty("net.hostname"));
        SPUniqueIDUtil.getNetInfFP(fp);
        String pkgname = context.getPackageName();
        SPJSONUtil.put(fp, "app.packagename", pkgname);
        try {
            PackageInfo pkginfo = context.getPackageManager().getPackageInfo(pkgname, 0);
            SPJSONUtil.put(fp, "app.version.name", pkginfo.versionName);
            SPJSONUtil.putStr(fp, "app.version.code", pkginfo.versionCode);
        }
        catch (Exception pkginfo) {
            // empty catch block
        }
        String sig = SPSystemUtil.getSignature(context, context.getPackageName());
        SPJSONUtil.put(fp, "app.signature", "[md5]" + SPStringUtil.md5(sig));
        SPJSONUtil.put(fp, "app.uid", "" + Process.myUid());
        SPUniqueIDUtil.getAppInfoFP(context, fp);
        SPUniqueIDUtil.getUserFP(context, fp);
        return fp;
    }

    private static void getBuildPropFP(JSONObject fp) {
    }

    private static void getNetInfFP(JSONObject fp) {
        JSONArray netinf = new JSONArray();
        try {
            ArrayList<NetworkInterface> nifList = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : nifList) {
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02X-", b & 0xFF));
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                JSONObject jnif = new JSONObject();
                SPJSONUtil.put(jnif, "name", nif.getName());
                SPJSONUtil.put(jnif, "mac", sb.toString().replace(':', '-').toUpperCase(Locale.ENGLISH));
                netinf.put((Object)jnif);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SPJSONUtil.put(fp, "net.inf", netinf);
    }

    private static void getStorageFP(Context context, JSONObject fp) {
        JSONArray storages = new JSONArray();
        try {
            StorageManager storageManager = (StorageManager)context.getSystemService("storage");
            Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = storageManager.getClass().getMethod("getVolumeList", new Class[0]);
            Method getUuid = storageVolumeClazz.getMethod("getUuid", new Class[0]);
            Object result = getVolumeList.invoke((Object)storageManager, new Object[0]);
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String uuid = (String)getUuid.invoke(storageVolumeElement, new Object[0]);
                if (TextUtils.isEmpty((CharSequence)uuid)) continue;
                storages.put((Object)uuid);
            }
        }
        catch (Throwable storageManager) {
            // empty catch block
        }
        SPJSONUtil.put(fp, "dev.storage.uuid", storages);
        if (Build.VERSION.SDK_INT >= 18) {
            SPJSONUtil.put(fp, "dev.storage.internal.total", "" + SPUniqueIDUtil.getTotalSpaceJBMR2(Environment.getDataDirectory()));
            SPJSONUtil.put(fp, "dev.storage.system.total", "" + SPUniqueIDUtil.getTotalSpaceJBMR2(Environment.getRootDirectory()));
            SPJSONUtil.put(fp, "dev.storage.sdcard.total", "" + SPUniqueIDUtil.getTotalSpaceJBMR2(Environment.getExternalStorageDirectory()));
            String extsdcard = SPFileUtil.getExtSdCardPath(context);
            if (!TextUtils.isEmpty((CharSequence)extsdcard)) {
                SPJSONUtil.put(fp, "dev.storage.extsdcard.total", "" + SPUniqueIDUtil.getTotalSpaceJBMR2(new File(extsdcard)));
            }
        }
    }

    @TargetApi(value=18)
    private static long getTotalSpaceJBMR2(File file) {
        try {
            StatFs stats = new StatFs(file.getAbsolutePath());
            return stats.getBlockSizeLong() * stats.getBlockCountLong() / 1024L;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private static void getSensorFP(Context context, JSONObject fp) {
        JSONArray sensors = new JSONArray();
        try {
            SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
            List sensorList = sensorManager.getSensorList(-1);
            for (Sensor sensor : sensorList) {
                JSONObject jsonsor = new JSONObject();
                SPJSONUtil.put(jsonsor, "name", sensor.getName());
                SPJSONUtil.put(jsonsor, "vendor", sensor.getVendor());
                if (Build.VERSION.SDK_INT >= 20) {
                    SPJSONUtil.put(jsonsor, "type", SPUniqueIDUtil.getSensorStringType(sensor));
                } else {
                    SPJSONUtil.put(jsonsor, "type", "" + sensor.getType());
                }
                sensors.put((Object)jsonsor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SPJSONUtil.put(fp, "dev.sensor", sensors);
    }

    @TargetApi(value=20)
    private static String getSensorStringType(Sensor sensor) {
        return sensor.getStringType();
    }

    private static void getAppInfoFP(Context context, JSONObject fp) {
        JSONArray japps = new JSONArray();
        PackageManager pm = context.getPackageManager();
        List appInfos = pm.getInstalledApplications(128);
        for (ApplicationInfo appInfo : appInfos) {
            JSONObject japp = new JSONObject();
            SPJSONUtil.put(japp, "pkgname", appInfo.packageName);
            SPJSONUtil.putStr(japp, "uid", appInfo.uid);
            String sig = SPSystemUtil.getSignature(context, appInfo.packageName);
            SPJSONUtil.put(japp, "signature", "[md5]" + SPStringUtil.md5(sig));
            try {
                PackageInfo pi = pm.getPackageInfo(appInfo.packageName, 4);
                for (ServiceInfo si : pi.services) {
                    if (!"android.permission.BIND_VPN_SERVICE".equals(si.permission)) continue;
                    SPJSONUtil.put(japp, "service.vpn", si.name);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            japps.put((Object)japp);
        }
        SPJSONUtil.put(fp, "app.install", japps);
    }

    private static void getUserFP(Context context, JSONObject fp) {
    }

    public static byte[] sm4ecbEncrypt(boolean enc, byte[] input, String key) {
        int len;
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "encrypt", enc ? "1" : "0");
        SPJSONUtil.put(json_req, "password", key);
        SPJSONUtil.put(json_req, "algorithm", "sm4_ecb_optimized");
        byte[] xdata = null;
        for (len = input.length; len > 0 && input[len - 1] == 0; --len) {
        }
        if (len < input.length) {
            xdata = new byte[len];
            System.arraycopy(input, 0, xdata, 0, len);
        } else {
            xdata = input;
        }
        SPJSONUtil.put(json_req, "base64", Base64.encodeToString((byte[])xdata, (int)2));
        SPMsgRspEmpty rsp = SPLibBridge.exeCmdEx("vspace_crypt_buffer", json_req);
        if (0 == rsp.errcode) {
            return Base64.decode((String)rsp.json.optString("base64"), (int)2);
        }
        return new byte[0];
    }
}

