/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid.uniq;

import android.content.Context;
import android.text.TextUtils;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.sportal.jni.SPLibBridge;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPUniqueIDTerm {
    public static final String PROTECTION_GESTURE = "gesture";
    public static final String PROTECTION_FACE = "face";
    public static final String PROTECTION_VOICEPRINT = "voidprint";
    public String svr_host = "";
    public int svr_port = 443;
    public String dev_guid = "";
    public List<String> protection = new ArrayList<String>();
    public long ctime = 0L;
    public long expires = 0L;
    public String access_token = "";
    public String key = "";
    public String hint_text = "";

    private static String cacheFilepath() {
        String filepath = SPFileUtil.getSdCardPath() + "/Android/data/com.secure.secid.unique/.cache";
        new File(filepath).getParentFile().mkdirs();
        return filepath;
    }

    private static String encryptCahce(String str, boolean enc) {
        return SPLibBridge.encryptString(enc, str, "SPUniqueID_" + SPNetUtil.getWifiMac(null), "sm4");
    }

    public SPUniqueIDTerm() {
        this.cleanup(true);
    }

    public boolean isValidated() {
        return this.ctime > 1500000000000L && this.expires > System.currentTimeMillis() && !TextUtils.isEmpty((CharSequence)this.access_token);
    }

    public void cleanup(boolean total) {
        if (total) {
            this.svr_host = "";
            this.svr_port = 443;
            this.dev_guid = "";
            this.protection = new ArrayList<String>();
        }
        this.ctime = 0L;
        this.expires = 0L;
        this.access_token = "";
        this.key = "";
    }

    public void loadCache(Context context) {
        String jstr = (String)SPFileUtil.readObject(context, "spuniqid.cache");
        jstr = SPUniqueIDTerm.encryptCahce(jstr, false);
        JSONObject json = SPJSONUtil.parseObject(jstr);
        this.svr_host = json.optString("svr_host");
        this.svr_port = json.optInt("svr_port", 443);
        this.dev_guid = json.optString("dev_guid");
        this.protection = new ArrayList<String>();
        JSONArray plist = json.optJSONArray("protection");
        for (int i = 0; null != plist && i < plist.length(); ++i) {
            String p = plist.optString(i);
            if (TextUtils.isEmpty((CharSequence)p)) continue;
            this.protection.add(p);
        }
    }

    public void storeCache(Context context) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "svr_host", this.svr_host);
        SPJSONUtil.put(json, "svr_port", this.svr_port);
        SPJSONUtil.put(json, "dev_guid", this.dev_guid);
        JSONArray plist = new JSONArray();
        for (String p : this.protection) {
            plist.put((Object)p);
        }
        SPJSONUtil.put(json, "protection", plist);
        String jstr = SPUniqueIDTerm.encryptCahce(json.toString(), true);
        SPFileUtil.writeObject(context, "spuniqid.cache", jstr);
    }

    public void fromBrokerJSON(JSONObject json) {
        this.dev_guid = json.optString("dev_guid");
        this.access_token = json.optString("access_token");
        this.key = json.optString("encrypt_key");
        this.ctime = System.currentTimeMillis();
        this.expires = json.optLong("expires") * 1000L;
        this.expires -= json.optLong("time_offset") * 1000L;
        this.hint_text = json.optString("hint_text");
    }
}

