/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid.uniq;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import com.secure.comm.utils.SPFileUtil;
import com.secure.sportal.sdk.app.SPSecIDUniqueActvity;
import com.secure.sportal.sdk.gesture.SPBiometrics;
import com.secure.sportal.sdk.gesture.SPGestureData;
import java.lang.reflect.Method;

public class SPUniqueIDProtection {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_GESTURE = 1;
    public static final int FLAG_FACE_ID = 2;
    public static final int FLAG_VOICE_FP = 4;
    public static final int FLAG_ALL = 255;
    public static final int RESULT_CREATE = 1;
    public static final int RESULT_SUCC = 2;
    public static final int RESULT_FAIL = 3;
    public static final int RESULT_CANCEL = 4;
    public static final int RESULT_SWITCH = 5;
    private static long mReqID = 0L;
    private static ProtectionCallback mCallback = null;

    private static void initialize(Context context) {
        try {
            Class<?> cls = Class.forName("com.secure.biometrics.SPBiometricsImpl");
            Method method = cls.getMethod("initialize", Context.class);
            method.invoke(null, context);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reset(Context context, int flags) {
        if ((flags & 1) > 0) {
            SPGestureData.setPassword(context, "");
        }
        if ((flags & 6) > 0) {
            SPFileUtil.writeObject(context, "spbm.conf", "{}");
            try {
                Class<?> cls = Class.forName("com.secure.biometrics.SPBiometricsImpl");
                Method method = cls.getMethod("reset", Context.class);
                method.invoke(null, context);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getConfigFlags(Context context) {
        SPUniqueIDProtection.initialize(context);
        int flags = 0;
        if (SPGestureData.hasPassword(context)) {
            flags |= 1;
        }
        if (SPBiometrics.hasFaceID) {
            flags |= 2;
        }
        return flags;
    }

    public static void start(Context context, int flags, ProtectionCallback callback) {
        SPUniqueIDProtection.initialize(context);
        try {
            mReqID = 0L;
            mCallback = null;
            Intent intent = new Intent(context, SPSecIDUniqueActvity.class);
            intent.putExtra("uniqueid.authreq.falgs", flags);
            long reqid = System.currentTimeMillis();
            intent.putExtra("uniqueid.authreq.id", reqid);
            context.startActivity(intent);
            mReqID = reqid;
            mCallback = callback;
        }
        catch (Exception ex) {
            if (ex instanceof ActivityNotFoundException) {
                // empty if block
            }
            callback.onProtectionCallback(255, 3);
        }
    }

    public static boolean onProtectResult(long reqid, int flag, int result) {
        if (reqid == mReqID && null != mCallback) {
            try {
                if (mCallback.onProtectionCallback(flag, result)) {
                    reqid = 0L;
                    mCallback = null;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static interface ProtectionCallback {
        public boolean onProtectionCallback(int var1, int var2);
    }
}

