/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid.uniq;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.secid.uniq.SPUniqueIDTerm;
import com.secure.sportal.secid.uniq.SPUniqueIDUtil;
import java.util.Properties;

public class SPUniqueID {
    private static SPUniqueIDTerm mUniqIDTerm = null;

    public static void requestPermissions(Activity activity, int requestCode) {
        SPIntentUtil.requestPermission(activity, new String[]{"android.permission.CAMERA", "android.permission.BLUETOOTH", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, requestCode);
    }

    public static boolean isValidated() {
        return null != mUniqIDTerm && mUniqIDTerm.isValidated();
    }

    public static void dumpSession() {
        if (null != mUniqIDTerm) {
            PLog.v("[UNIQ_ID] server=%s:%d,\nguid=%s,\naccess_token=%s,key=%s", SPUniqueID.mUniqIDTerm.svr_host, SPUniqueID.mUniqIDTerm.svr_port, SPUniqueID.mUniqIDTerm.dev_guid, SPUniqueID.mUniqIDTerm.access_token, SPUniqueID.mUniqIDTerm.key);
        }
    }

    public static void resetSession(Context context) {
        if (SPUniqueID.isValidated()) {
            mUniqIDTerm.cleanup(false);
            mUniqIDTerm.storeCache(context);
        }
    }

    public static void authDevice(Context context, String host, int port, Properties params, Callback callback) {
        SPLibBridge.initLibrary(context);
        SPApplication.setAppContext(context);
        if (null == mUniqIDTerm) {
            mUniqIDTerm = new SPUniqueIDTerm();
            mUniqIDTerm.loadCache(context);
        } else if (mUniqIDTerm.isValidated()) {
            SPUniqueID.fireResponse(callback, 0, SPUniqueID.mUniqIDTerm.access_token, "");
            return;
        }
        AuthRequest authReq = new AuthRequest();
        authReq.context = context;
        authReq.host = host;
        authReq.port = port;
        authReq.params = params;
        authReq.callback = callback;
        SPUniqueID.performAuthRequest(authReq);
    }

    public static byte[] bufferEncrypt(byte[] data) {
        return SPUniqueID.bufferEncryptOrDecrypt(true, data);
    }

    public static byte[] bufferDecrypt(byte[] data) {
        return SPUniqueID.bufferEncryptOrDecrypt(false, data);
    }

    private static void performAuthRequest(final AuthRequest authReq) {
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "secid_uniq_regist";
        msgreq.data.put("access_token", SPStringUtil.opt(SPUniqueID.mUniqIDTerm.access_token));
        msgreq.data.put("dev_guid", SPStringUtil.opt(SPUniqueID.mUniqIDTerm.dev_guid));
        msgreq.data.put("dev_feature", SPUniqueIDUtil.getDeviceFP(authReq.context));
        msgreq.data.putProperties(authReq.params);
        GatewayBroker.request(msgreq, authReq.host, authReq.port, authReq.host, new GatewayBroker.BrokerCallback(){

            @Override
            public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
                if (0 == msgrsp.errcode) {
                    mUniqIDTerm.fromBrokerJSON(msgrsp.json);
                    mUniqIDTerm.svr_host = authReq.host;
                    mUniqIDTerm.svr_port = authReq.port;
                    mUniqIDTerm.storeCache(authReq.context);
                    SPUniqueID.fireResponse(authReq.callback, 0, mUniqIDTerm.access_token, mUniqIDTerm.hint_text);
                } else {
                    SPUniqueID.fireResponse(authReq.callback, msgrsp.errcode, msgrsp.errmsg, "");
                }
            }
        });
    }

    private static byte[] bufferEncryptOrDecrypt(boolean enc, byte[] data) {
        if (null != mUniqIDTerm && !TextUtils.isEmpty((CharSequence)SPUniqueID.mUniqIDTerm.key)) {
            return SPUniqueIDUtil.sm4ecbEncrypt(enc, data, SPUniqueID.mUniqIDTerm.key);
        }
        return new byte[0];
    }

    private static void fireResponse(final Callback callback, final int errcode, final String errmsg, final String hintText) {
        if (null != callback) {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    callback.onSecIDUniqueAuthError(errcode, errmsg, hintText);
                }
            }, 10L);
        }
    }

    private static class AuthRequest {
        public Context context;
        public String host;
        public int port;
        public Properties params;
        public Callback callback;

        private AuthRequest() {
        }
    }

    public static interface Callback {
        public void onSecIDUniqueAuthError(int var1, String var2, String var3);
    }
}

