/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.text.TextUtils;
import org.json.JSONObject;

public class SPTOtpTokenInfo {
    public int errcode = 0;
    public String token = "";
    public int left = 30;
    public String otpuri = "";
    public String type = "";
    public String label = "";
    public String issuer = "";
    public String accountname = "";
    public String secret = "";
    public String algorithm = "";
    public int digits = 0;
    public int counter = 0;
    public int period = 0;

    public void setResponseJSON(JSONObject rsp) {
        this.token = rsp.optString("token_totp");
        this.left = rsp.optInt("left", 30);
        this.type = rsp.optString("type", "");
        this.label = rsp.optString("label", "");
        this.issuer = rsp.optString("issuer", "");
        this.accountname = rsp.optString("accountname", "");
        this.secret = rsp.optString("secret", "");
        this.algorithm = rsp.optString("algorithm", "");
        this.digits = rsp.optInt("digits", 6);
        this.counter = rsp.optInt("counter", 0);
        this.period = rsp.optInt("period", 30);
    }

    public String buildOtpURI() {
        StringBuilder uri = new StringBuilder("otpauth://");
        if ("hotp".equalsIgnoreCase(this.type)) {
            uri.append("hotp");
        } else {
            uri.append("totp");
        }
        uri.append("/");
        if (!TextUtils.isEmpty((CharSequence)this.issuer)) {
            uri.append(this.issuer).append(":");
        }
        if (!TextUtils.isEmpty((CharSequence)this.accountname)) {
            uri.append(this.accountname);
        }
        uri.append("?secret=").append(this.secret);
        if (!TextUtils.isEmpty((CharSequence)this.algorithm)) {
            uri.append("&algorithm=").append(this.algorithm);
        }
        if ("hotp".equalsIgnoreCase(this.type)) {
            uri.append("&counter=").append(this.counter);
        }
        return uri.toString();
    }

    public String toString() {
        return "token=" + this.token + ", left=" + this.left;
    }
}

