/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.text.TextUtils;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPPasswordPolicy;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.secid.SPSecIDExtAppInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPSecIDUserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String host;
    public int port;
    public String username;
    public String password;
    public String access_token;
    public String refresh_token;
    public int token_timeout = 7200;
    public String secid_uname;
    public boolean gesture;
    public int req_code = 0;
    public String otp_key = "";
    public String otp_mask = "";
    public long otp_expires = 0L;
    public long otp_offset = 0L;
    public long otp_step = 30L;
    public long otp_digits = 6L;
    public String otp_algo = "sha1";
    public String sid_pubkey = "";
    public int sid_backup = 0;
    public String vcode_phone = "";
    public String vcode_email = "";
    public int vcode_timeout = 0;
    public boolean otp_offline = false;
    public boolean pass_resetable;
    public SPPasswordPolicy pass_policy;
    public String notice_msg = "";
    public int net_type = 0;
    public boolean gather_dev_feature = false;
    public String its_id = "";
    public String push_list = "";
    public String bind_dev_list = null;
    public SPLiteBundle extras = new SPLiteBundle();
    public List<SPSecIDExtAppInfo> apps = new ArrayList<SPSecIDExtAppInfo>();

    public static SPSecIDUserInfo parse(JSONObject json, String devid) {
        SPSecIDUserInfo usrinfo = new SPSecIDUserInfo();
        usrinfo.fromJSON(json, devid);
        return usrinfo;
    }

    public void fromJSON(JSONObject json, String devid) {
        this.host = json.optString("svr_host");
        this.port = SPJSONUtil.optInt(json, "svr_port", 443, 1, 65535);
        this.username = json.optString("username");
        this.access_token = json.optString("access_token");
        this.refresh_token = json.optString("refresh_token");
        this.token_timeout = SPStringUtil.parseInt(json.optString("token_timeout"));
        this.secid_uname = json.optString("secid_uname");
        this.gesture = SPStringUtil.parseInt(json.optString("gesture")) > 0;
        this.req_code = SPStringUtil.parseInt(json.optString("req_code"));
        this.vcode_phone = json.optString("vcode_phone");
        this.vcode_email = json.optString("vcode_email");
        this.vcode_timeout = json.optInt("vcode_timeout", 0);
        this.otp_key = json.optString("otp_key");
        this.otp_mask = json.optString("otp_mask");
        this.otp_expires = SPStringUtil.parseInt(json.optString("otp_expires"));
        this.otp_offset = SPStringUtil.parseLong(json.optString("otp_offset"));
        this.otp_step = SPStringUtil.parseLong(json.optString("otp_step"));
        this.otp_digits = SPStringUtil.parseInt(json.optString("otp_digits"));
        this.otp_algo = json.optString("otp_algo");
        this.otp_offline = SPStringUtil.parseInt(json.optString("otp_offline")) != 0;
        this.sid_pubkey = json.optString("secid_pubkey");
        this.sid_backup = SPStringUtil.parseInt(json.optString("secid_backup"));
        this.net_type = SPStringUtil.parseInt(json.optString("net_type"));
        this.gather_dev_feature = 1 == json.optInt("gather_dev_feature");
        this.its_id = json.optString("its_id");
        JSONArray pushes = json.optJSONArray("push_list");
        this.push_list = null != pushes ? pushes.toString() : "[]";
        JSONArray devs = json.optJSONArray("bind_dev_list");
        this.bind_dev_list = null != devs ? devs.toString() : "[]";
        this.extras.clear();
        Iterator key = json.keys();
        while (key.hasNext()) {
            String name = (String)key.next();
            if (!name.startsWith("extra_")) continue;
            this.extras.put(name, json.optString(name));
        }
        this.apps.clear();
        try {
            JSONArray applist = json.getJSONArray("app_list");
            for (int i = 0; i < applist.length(); ++i) {
                SPSecIDExtAppInfo app = SPSecIDExtAppInfo.fromJSON(applist.getJSONObject(i));
                if (null == app) continue;
                this.apps.add(app);
            }
        }
        catch (Exception applist) {
            // empty catch block
        }
        this.pass_resetable = SPStringUtil.parseInt(json.optString("password_resetable")) > 0;
        this.pass_policy = SPPasswordPolicy.fromBrokerRsp(json.optJSONObject("password_policy"));
        this.notice_msg = json.optString("notice_msg");
        String offline = json.optString("__otp_offline__");
        if (!TextUtils.isEmpty((CharSequence)offline) && offline.length() > 32) {
            JSONObject otp;
            String pass = SPStringUtil.md5(devid);
            if (null != pass && pass.length() > 16) {
                pass = pass.substring(0, 16);
            }
            this.gesture = SPStringUtil.parseInt((otp = SPJSONUtil.parseObject(offline = SPLibBridge.encryptString(false, offline, pass, "sm4"))).optString("gesture")) > 0;
            this.otp_key = otp.optString("otp_key");
            this.otp_mask = otp.optString("otp_mask");
            this.otp_expires = SPStringUtil.parseInt(otp.optString("otp_expires"));
            this.otp_offset = SPStringUtil.parseLong(otp.optString("otp_offset"));
            this.otp_step = SPStringUtil.parseLong(otp.optString("otp_step"));
            this.otp_digits = SPStringUtil.parseInt(otp.optString("otp_digits"));
            this.otp_algo = otp.optString("otp_algo");
            this.otp_offline = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSON(String devid) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "svr_host", this.host);
        SPJSONUtil.put(json, "svr_port", String.valueOf(this.port));
        SPJSONUtil.put(json, "username", this.username);
        SPJSONUtil.put(json, "access_token", this.access_token);
        SPJSONUtil.put(json, "refresh_token", this.refresh_token);
        SPJSONUtil.put(json, "secid_uname", null != this.secid_uname ? this.secid_uname : "");
        SPJSONUtil.put(json, "gather_dev_feature", this.gather_dev_feature ? "1" : "0");
        SPJSONUtil.put(json, "its_id", this.its_id);
        try {
            for (String string2 : this.extras.keySet()) {
                SPJSONUtil.put(json, string2, this.extras.getStr(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONArray applist = new JSONArray();
            for (SPSecIDExtAppInfo app : this.apps) {
                applist.put((Object)app.toJSON());
            }
            json.put("app_list", (Object)applist);
        }
        catch (Exception applist) {
            // empty catch block
        }
        if (this.otp_offline) {
            void var4_11;
            JSONObject otp = new JSONObject();
            SPJSONUtil.put(otp, "gesture", this.gesture ? "1" : "0");
            SPJSONUtil.put(otp, "otp_key", this.otp_key);
            SPJSONUtil.put(otp, "otp_mask", this.otp_mask);
            SPJSONUtil.put(otp, "otp_expires", String.valueOf(this.otp_expires));
            SPJSONUtil.put(otp, "otp_offset", String.valueOf(this.otp_offset));
            SPJSONUtil.put(otp, "otp_step", String.valueOf(this.otp_step));
            SPJSONUtil.put(otp, "otp_digits", String.valueOf(this.otp_digits));
            SPJSONUtil.put(otp, "otp_algo", this.otp_algo);
            SPJSONUtil.put(otp, "otp_offline", "1");
            String string3 = SPStringUtil.md5(devid);
            if (null != string3 && string3.length() > 16) {
                String string4 = string3.substring(0, 16);
            }
            SPJSONUtil.put(json, "__otp_offline__", SPLibBridge.encryptString(true, otp.toString(), (String)var4_11, "sm4"));
        }
        return json;
    }
}

