/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.text.TextUtils;
import com.secure.comm.utils.SPJSONUtil;
import java.io.Serializable;
import org.json.JSONObject;

public class SPSecIDUID
implements Comparable<SPSecIDUID>,
Serializable {
    private static final long serialVersionUID = -3921280537275948407L;
    public String svr_host = "";
    public int svr_port = 443;
    public String username = "";
    public String upass = "";
    public boolean otp_offline = false;
    public boolean gesture_enable = false;
    public long offset_time = 0L;

    public SPSecIDUID() {
        this("", "", 443);
    }

    public SPSecIDUID(String uname, String host, int port) {
        this.username = uname;
        this.svr_host = host;
        this.svr_port = port;
    }

    public String key() {
        if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.svr_host) || this.svr_port < 1) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        key.append(this.username).append("@");
        key.append(this.svr_host).append(":").append(this.svr_port);
        return key.toString();
    }

    public SPSecIDUID clone() {
        return new SPSecIDUID(this.username, this.svr_host, this.svr_port);
    }

    @Override
    public int compareTo(SPSecIDUID o) {
        if (null == this.svr_host || null == this.username || null == o.svr_host || null == o.username) {
            return -1;
        }
        int ret = 0;
        ret = this.svr_host.compareTo(o.svr_host);
        if (0 == ret && 0 == (ret = this.username.compareTo(o.username))) {
            ret = this.svr_port < o.svr_port ? -1 : (this.svr_port == o.svr_port ? 0 : 1);
        }
        return ret;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "svr_host", this.svr_host);
        SPJSONUtil.putStr(json, "svr_port", this.svr_port);
        SPJSONUtil.put(json, "username", this.username);
        return json;
    }

    public static SPSecIDUID fromJSON(JSONObject json) {
        if (null != json) {
            SPSecIDUID uid = new SPSecIDUID();
            uid.svr_host = json.optString("svr_host");
            uid.svr_port = SPJSONUtil.optInt(json, "svr_port", 443, 1, 65535);
            uid.username = json.optString("username");
            return uid;
        }
        return null;
    }
}

