/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.content.Context;
import android.text.TextUtils;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.secid.SPSecIDSession;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPSecIDUserInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPSecIDSessionBox {
    public static String mSingleUsername = null;
    private Map<String, SPSecIDSession> sessions = new HashMap<String, SPSecIDSession>();
    private SPSecIDUID activedUID = null;
    private static SPSecIDSessionBox _instance;

    private SPSecIDSessionBox() {
    }

    public static synchronized SPSecIDSessionBox instance() {
        return null != _instance ? _instance : (_instance = new SPSecIDSessionBox());
    }

    public void setActive(SPSecIDUID uid) {
        this.activedUID = uid;
    }

    public SPSecIDUID getActive() {
        return this.activedUID;
    }

    public SPSecIDSession get(SPSecIDUID uid, boolean onlineOnly) {
        String key = uid.key();
        SPSecIDSession session = this.sessions.get(key);
        if (onlineOnly) {
            return null != session && session.isOnline() ? session : null;
        }
        if (null == session && !TextUtils.isEmpty((CharSequence)key)) {
            session = new SPSecIDSession(uid);
            this.sessions.put(key.toString(), session);
        }
        return session;
    }

    public SPSecIDSession getOneEx() {
        SPSecIDSession session = null;
        if (null != this.activedUID) {
            session = this.sessions.get(this.activedUID.key());
        }
        if (null == session) {
            Iterator<SPSecIDSession> it = this.sessions.values().iterator();
            session = it.hasNext() ? it.next() : null;
        }
        return session;
    }

    public void remove(Context context, String devid, SPSecIDUID uid) {
        if (null != this.sessions.remove(uid.key())) {
            this.store(context, devid);
        }
    }

    public void load(Context context, String devid) {
        if (this.sessions.isEmpty()) {
            String jstr = (String)SPFileUtil.readObject(context, "secid_uinfo.bin");
            JSONObject content = SPJSONUtil.parseObject(jstr);
            this.sessions.clear();
            String data = SPLibBridge.encryptString(false, content.optString("userinfo"), "SecuerPortal-SECID", "");
            try {
                SPSecIDSession session;
                SPSecIDUserInfo user = SPSecIDUserInfo.parse(SPJSONUtil.parseObject(data), devid);
                if (TextUtils.isEmpty((CharSequence)user.username)) {
                    user.username = mSingleUsername;
                }
                if ((session = new SPSecIDSession(user)).isOnline()) {
                    this.sessions.put(session.key(), session);
                }
            }
            catch (Exception user) {
                // empty catch block
            }
            this.activedUID = SPSecIDUID.fromJSON(content.optJSONObject("actived_uid"));
            data = SPLibBridge.encryptString(false, content.optString("userinfos"), "SecuerPortal-SECID", "sm4");
            JSONArray json = SPJSONUtil.parseArray(data);
            for (int i = 0; i < json.length(); ++i) {
                SPSecIDUserInfo user = SPSecIDUserInfo.parse(json.optJSONObject(i), devid);
                SPSecIDSession session = new SPSecIDSession(user);
                this.sessions.put(session.key(), session);
            }
        }
    }

    public void store(Context context, String devid) {
        JSONArray json = new JSONArray();
        for (SPSecIDSession session : this.sessions.values()) {
            if (!session.isOnline() || TextUtils.isEmpty((CharSequence)session.userinfo.username)) continue;
            json.put((Object)session.userinfo.toJSON(devid));
        }
        String data = SPJSONUtil.toString(json);
        data = SPLibBridge.encryptString(true, data, "SecuerPortal-SECID", "sm4");
        JSONObject content = new JSONObject();
        SPJSONUtil.put(content, "userinfos", data);
        if (null != this.activedUID) {
            SPJSONUtil.put(content, "actived_uid", this.activedUID.toJSON());
        }
        SPFileUtil.writeObject(context, "secid_uinfo.bin", SPJSONUtil.toString(content));
    }
}

