/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import com.secure.sportal.secid.SPSecID;
import com.secure.sportal.secid.SPSecIDController;

public class SPSecIDService
extends Service {
    public static final int MSG_WHAT_SECID_REQUEST = 36030;
    public static final int MSG_WHAT_SECID_REPONSE = 36031;
    private SecIDServiceHandler mServiceHandler = null;
    private Looper mServiceLooper = null;
    private Messenger mMessenger = null;

    public void onDestroy() {
        this.mServiceLooper.quit();
        this.mServiceLooper = null;
        super.onDestroy();
    }

    public void onCreate() {
        if (null == this.mServiceLooper) {
            HandlerThread thread = new HandlerThread("SPSecIDService", 10);
            thread.start();
            this.mServiceLooper = thread.getLooper();
            this.mServiceHandler = new SecIDServiceHandler(this.mServiceLooper);
            this.mMessenger = new Messenger((Handler)this.mServiceHandler);
        }
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        SPSecID.mLog.v("SPSecIDService recv start " + intent + ", startId=" + startId, new Object[0]);
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    private class SecIDRequestTask
    implements Runnable {
        private Message rspMsg;
        private Bundle reqData;
        private Messenger replyTo;

        public SecIDRequestTask(Message reqMsg) {
            this.reqData = (Bundle)reqMsg.obj;
            this.replyTo = reqMsg.replyTo;
            this.rspMsg = Message.obtain((Message)reqMsg);
            this.rspMsg.what = 36031;
            this.rspMsg.arg1 = reqMsg.arg1;
            this.rspMsg.arg2 = reqMsg.arg2;
            this.rspMsg.obj = null;
        }

        @Override
        public void run() {
            if (null == this.rspMsg.obj) {
                this.rspMsg.obj = SPSecIDController.request((Context)SPSecIDService.this, this.reqData);
                SPSecIDService.this.mServiceHandler.post(this);
            } else {
                try {
                    this.replyTo.send(this.rspMsg);
                }
                catch (Exception ex) {
                    SPSecID.mLog.i(ex);
                }
            }
        }
    }

    private final class SecIDServiceHandler
    extends Handler {
        public SecIDServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 36030: {
                    new Thread(new SecIDRequestTask(msg)).start();
                    break;
                }
                case 36031: {
                    break;
                }
            }
            super.handleMessage(msg);
        }
    }
}

