/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.SPLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.secid.SPSecID;
import com.secure.sportal.secid.SPSecIDExtAppInfo;
import com.secure.sportal.secid.SPSecIDSession;
import com.secure.sportal.secid.SPSecIDSessionBox;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPTOtpTokenInfo;
import java.util.Map;

public class SPSecIDProvider
extends ContentProvider {
    private static SPLog mLog = SPLog.getLogp("[secid]");

    public boolean onCreate() {
        SPLibBridge.initLibrary(this.getContext());
        SPApplication.setAppContext(this.getContext());
        Map<String, String> devInfo = SPDeviceUtil.getDeviceInfo(this.getContext());
        SPSecIDSessionBox.instance().load(this.getContext(), devInfo.get("devid"));
        SPSecIDUID uid = SPSecIDSessionBox.instance().getActive();
        mLog.v("SPSecIDProvider.onCreate() active_uid=%s", null != uid ? uid.key() : "(null)");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle call(String method, String arg, Bundle extras) {
        mLog.v("SPSecIDProvider.call() method=%s", method);
        if ("generate_token".equals(method) || "get_authcode".equals(method)) {
            final CallRequest req = new CallRequest();
            req.method = method;
            req.arg = arg;
            req.extras = extras;
            req.lock = new Object();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SPSecIDProvider.this.executeCallReq(req);
                    }
                    catch (Exception exx) {
                        PLog.v(exx);
                    }
                    try {
                        Object object = req.lock;
                        synchronized (object) {
                            req.lock.notifyAll();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
            try {
                Object object = req.lock;
                synchronized (object) {
                    req.lock.wait(60000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return req.result;
        }
        return super.call(method, arg, extras);
    }

    private void executeCallReq(CallRequest req) {
        SPSecIDSession session = SPSecIDSessionBox.instance().getOneEx();
        Bundle rspdata = new Bundle();
        if (null != session) {
            SPSecIDUID uid = new SPSecIDUID(session.userinfo.username, session.userinfo.host, session.userinfo.port);
            rspdata.putString("secid_svr_host", SPStringUtil.opt(uid.svr_host));
            rspdata.putInt("secid_svr_port", uid.svr_port);
            rspdata.putString("secid_username", SPStringUtil.opt(uid.username));
            if ("generate_token".equals(req.method)) {
                SPTOtpTokenInfo token = SPSecID.totpGenerateToken(uid);
                if (!TextUtils.isEmpty((CharSequence)token.token)) {
                    rspdata.putString("totp_token", token.token);
                    rspdata.putInt("secid_errcode", 0);
                } else {
                    rspdata.putInt("secid_errcode", 251658755);
                    rspdata.putString("secid_errmsg", "\u83b7\u53d6\u52a8\u6001\u53e3\u4ee4\u5931\u8d25");
                }
                req.result = rspdata;
            } else if ("get_authcode".equals(req.method)) {
                String pkgname = req.extras.getString("secid_app_pkgname");
                String appid = null;
                for (SPSecIDExtAppInfo app : session.userinfo.apps) {
                    if (!app.pkgname.equals(pkgname)) continue;
                    appid = app.appid;
                    break;
                }
                if (!TextUtils.isEmpty(appid)) {
                    SPMsgRsp<String> mr = SPSecID.secidRequestAuthCode(this.getContext(), uid, appid, null);
                    rspdata.putInt("secid_errcode", mr.errcode);
                    rspdata.putString("secid_errmsg", mr.errmsg);
                    if (0 == mr.errcode) {
                        rspdata.putString("secid_authcode", mr.data());
                        rspdata.putInt("secid_authcode_ttl", 600);
                    }
                } else {
                    rspdata.putInt("secid_errcode", -4);
                    rspdata.putString("secid_errmsg", "\u627e\u4e0d\u5230\u5e94\u7528[" + pkgname + "]");
                }
                req.result = rspdata;
            }
        } else {
            rspdata.putInt("secid_errcode", -5);
            rspdata.putString("secid_errmsg", "\u5f53\u524d\u6ca1\u6709\u5728\u7ebf\u5e10\u53f7");
            req.result = rspdata;
        }
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private class CallRequest {
        String method;
        String arg;
        Bundle extras;
        Object lock;
        Bundle result;

        private CallRequest() {
        }
    }
}

