/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.secid.SPSecID;
import com.secure.sportal.secid.SPSecIDAppInfo;
import com.secure.sportal.secid.SPSecIDAuthResult;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPSecIDUserInfo;
import com.secure.sportal.secid.SPTOtpTokenInfo;
import java.util.Properties;

public class SPSecIDController {
    private static String mUsername = "";
    private static String mPassword = "";
    private static int mReqCode = 1;

    public static Bundle request(final Context context, final Bundle reqdata) {
        SPSecIDRsp rsp = new SPSecIDRsp();
        SPSecIDReq req = new SPSecIDReq(reqdata);
        if (req.cmd.equalsIgnoreCase("login")) {
            Properties authdata = new Properties();
            authdata.put("username", req.getStr("secid_username"));
            authdata.put("password", req.getStr("secid_password"));
            if (!TextUtils.isEmpty((CharSequence)req.getStr("secid_verify_code")) && mReqCode > 1) {
                authdata.put("req_code", String.valueOf(mReqCode));
                authdata.put("check_code_sms", req.getStr("secid_verify_code"));
                authdata.put("check_code_mail", req.getStr("secid_verify_code"));
            } else {
                authdata.put("req_code", req.getStr("req_code", "1"));
            }
            SPMsgRsp<SPSecIDUserInfo> rspmsg = SPSecID.loginServer(context, req.getStr("secid_svr_host"), req.getInt("secid_svr_port"), authdata);
            if (0 == rspmsg.errcode) {
                rsp.errcode = rspmsg.data().req_code;
                mReqCode = rspmsg.data().req_code;
                switch (rspmsg.data().req_code) {
                    case 0: {
                        mUsername = req.getStr("secid_username");
                        mPassword = req.getStr("secid_password");
                        break;
                    }
                    case 2: {
                        rsp.errmsg = "\u9700\u8981\u6740\u6bd2";
                        break;
                    }
                    case 3: {
                        rsp.errcode = 252772355;
                        break;
                    }
                    case 4: {
                        rsp.errcode = 252772356;
                        break;
                    }
                    case 5: {
                        rsp.errcode = 252772357;
                        break;
                    }
                    default: {
                        rsp.errmsg = "\u672a\u77e5\u9519\u8bef";
                        break;
                    }
                }
            } else {
                rsp.errcode = rspmsg.errcode;
                rsp.errmsg = rspmsg.errmsg;
            }
        } else if (req.cmd.equalsIgnoreCase("logout")) {
            SPSecID.logout(context, new SPSecIDUID());
            rsp.errcode = 0;
        } else if (req.cmd.equalsIgnoreCase("authorize_app")) {
            SPMsgRsp<SPSecIDAppInfo> rspmsg = SPSecID.secidAuthenQRCode(context, new SPSecIDUID(), req.getStr("secid_app_qrcode"));
            rsp.errcode = rspmsg.errcode;
            rsp.errmsg = rspmsg.errmsg;
            if (0 == rspmsg.errcode) {
                SPSecIDAppInfo app = rspmsg.data();
                Properties binds = new Properties();
                if (1 == app.bind_uname) {
                    binds.put("username", mUsername);
                } else if (2 == app.bind_uname) {
                    binds.put("username", req.getStr("secid_app_uname"));
                }
                if (1 == app.bind_passw) {
                    binds.put("username", SPSecID.secidEncryptBindData(new SPSecIDUID(), mPassword));
                } else if (2 == app.bind_passw) {
                    binds.put("username", SPSecID.secidEncryptBindData(new SPSecIDUID(), req.getStr("secid_app_passw")));
                }
                SPMsgRsp<SPSecIDAuthResult> rspmsg2 = SPSecID.secidAuthenApp(context, new SPSecIDUID(), app, true, binds);
                rsp.errcode = rspmsg2.errcode;
                rsp.errmsg = rspmsg2.errmsg;
            }
        } else if (req.cmd.equalsIgnoreCase("generate_token")) {
            SPTOtpTokenInfo otp = SPSecID.totpGenerateToken(new SPSecIDUID());
            rsp.errcode = otp.errcode;
            if (0 == rsp.errcode) {
                rsp.put("totp_token", otp.token);
                rsp.put("totp_expires", otp.left);
            }
        } else if (!req.cmd.equalsIgnoreCase("get_authcode")) {
            if (req.cmd.equalsIgnoreCase("test")) {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Intent intent = new Intent(context, Class.forName("com.secure.secid.activity.HomeActivity"));
                            intent.setFlags(0x30200000);
                            intent.putExtras(reqdata);
                            intent.putExtra("secid_invoke_source", "service");
                            context.startActivity(intent);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }, 0L);
            } else {
                rsp.errcode = -1;
                rsp.errmsg = "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c";
            }
        }
        if (0 != rsp.errcode && !TextUtils.isEmpty((CharSequence)rsp.errmsg)) {
            rsp.errmsg = GatewayErrorText.getErrMsg(rsp.errcode);
        }
        return rsp.export();
    }

    private static class SPSecIDRsp
    extends SPLiteBundle {
        private static final long serialVersionUID = 1998027558992198708L;
        public int errcode = 0;
        public String errmsg = "";

        private SPSecIDRsp() {
        }

        public Bundle export() {
            Bundle data = new Bundle();
            for (String key : this.mData.keySet()) {
                Object v = this.mData.get(key);
                if (v instanceof Integer) {
                    data.putInt(key, ((Integer)v).intValue());
                    continue;
                }
                if (v instanceof Number) {
                    data.putInt(key, ((Number)v).intValue());
                    continue;
                }
                data.putString(key, v.toString());
            }
            data.putInt("secid_errcode", this.errcode);
            if (0 != this.errcode) {
                data.putString("secid_errmsg", this.errmsg);
            }
            return data;
        }
    }

    private static class SPSecIDReq
    extends SPLiteBundle {
        private static final long serialVersionUID = 7795953014802871423L;
        public String cmd = this.getStr("secid_requset_cmd");

        public SPSecIDReq(Bundle data) {
            super(data);
        }
    }
}

