/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.sdk.LibSecIDSDKLite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SPSecIDClient
implements Handler.Callback {
    private static final int MSG_WHAT_SECID_REQUEST = 36030;
    private static final int MSG_WHAT_SECID_REPONSE = 36031;
    private AtomicInteger mReqidSeed;
    private Context mContext;
    private Handler mHandler;
    private AtomicBoolean mBinding = new AtomicBoolean(false);
    private ServiceConnection mConnection;
    private Messenger mMsgReceiver;
    private Messenger mMsgSender;
    private List<SecIDTask> mPendingTasks;
    private static SPSecIDClient _instance;

    public static void request(Context context, String cmd, Bundle data, LibSecIDSDKLite.OnLibSecIDSDKCallback callback) {
        SPSecIDClient.instance().perform(context, cmd, data, callback);
    }

    private static synchronized SPSecIDClient instance() {
        if (null == _instance) {
            _instance = new SPSecIDClient();
        }
        return _instance;
    }

    private SPSecIDClient() {
        this.mReqidSeed = new AtomicInteger(1);
        this.mPendingTasks = Collections.synchronizedList(new ArrayList());
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.mMsgReceiver = new Messenger(this.mHandler);
        this.mConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                SPSecIDClient.this.mMsgSender = null;
                SPSecIDClient.this.unbindSecIDService();
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                SPSecIDClient.this.mBinding.set(false);
                SPSecIDClient.this.mMsgSender = new Messenger(service);
                SPSecIDClient.this.performPendingTasks();
            }
        };
    }

    private boolean bindSecIDService() {
        this.mBinding.set(true);
        Intent intent = new Intent("com.secure.secid.messenger");
        intent.setComponent(new ComponentName("com.esg360.id", "com.secure.sportal.secid.SPSecIDService"));
        return this.mContext.bindService(intent, this.mConnection, 1);
    }

    private void unbindSecIDService() {
        this.mBinding.set(false);
        if (null != this.mContext && null != this.mConnection) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
            this.mHandler = null;
            this.mMsgReceiver = null;
        }
    }

    private void perform(Context context, String cmd, Bundle data, LibSecIDSDKLite.OnLibSecIDSDKCallback callback) {
        SecIDTask task = new SecIDTask();
        task.reqid = this.mReqidSeed.incrementAndGet();
        task.callback = callback;
        task.performing = false;
        task.reqdata = null != data ? data : new Bundle();
        task.reqdata.putString("secid_requset_cmd", cmd);
        task.reqdata.putLong("secid_request_time", System.currentTimeMillis());
        task.reqdata.putString("secid_requset_pkgname", context.getPackageName());
        this.mPendingTasks.add(task);
        this.mHandler.postDelayed((Runnable)task, 120000L);
        if (null != this.mMsgSender) {
            this.performTask(task);
        } else if (!this.mBinding.get()) {
            this.mContext = context.getApplicationContext();
            new Thread(){

                @Override
                public void run() {
                    try {
                        _instance.bindSecIDService();
                        for (int i = 0; i < 10 && null == SPSecIDClient.this.mMsgSender; ++i) {
                            SPSystemUtil.sleepEx(100L);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    SPSecIDClient.this.mBinding.set(false);
                }
            }.start();
        }
    }

    private void performTask(SecIDTask task) {
        Message msg = Message.obtain(null, (int)36030, (int)task.reqid, (int)0);
        msg.replyTo = this.mMsgReceiver;
        msg.obj = task.reqdata;
        task.performing = true;
        try {
            if (null != this.mMsgSender) {
                this.mMsgSender.send(msg);
            } else {
                this.mHandler.post((Runnable)task);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            task.onResult(1, "\u8fde\u63a5SecID\u5931\u8d25", null);
            return;
        }
    }

    private void performPendingTasks() {
        ArrayList<SecIDTask> tasks = new ArrayList<SecIDTask>(this.mPendingTasks);
        for (SecIDTask task : tasks) {
            if (task.performing) continue;
            this.performTask(task);
        }
    }

    private SecIDTask removeTaskByReqID(int reqid) {
        for (int i = 0; i < this.mPendingTasks.size(); ++i) {
            SecIDTask task = this.mPendingTasks.get(i);
            if (task.reqid != reqid) continue;
            this.mPendingTasks.remove(i);
            return task;
        }
        return null;
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 36031) {
            SecIDTask task = this.removeTaskByReqID(msg.arg1);
            if (null != task) {
                Bundle rspdata = (Bundle)msg.obj;
                int errcode = rspdata.getInt("secid_errcode");
                String errmsg = rspdata.getString("secid_errmsg");
                task.onResult(errcode, errmsg, rspdata);
            }
            return true;
        }
        return false;
    }

    private class SecIDTask
    implements Runnable {
        public int reqid;
        public Bundle reqdata;
        public LibSecIDSDKLite.OnLibSecIDSDKCallback callback;
        public boolean performing;

        private SecIDTask() {
        }

        public void onResult(int errcode, String errmsg, Bundle rspdata) {
            SPSecIDClient.this.mPendingTasks.remove(this);
            if (null != this.callback) {
                this.callback.onLibSecIDSDKResponse(errcode, errmsg, rspdata);
            }
        }

        @Override
        public void run() {
            this.onResult(-1, "\u8fde\u63a5SecID\u8d85\u65f6", null);
        }
    }
}

