/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.graphics.Bitmap;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPPasswordPolicy;
import java.io.Serializable;
import org.json.JSONObject;

public class SPSecIDAppInfo
implements Serializable {
    private static final long serialVersionUID = 45671234L;
    public static final int SECID_APP_TYPE_AUTH = 0;
    public static final int SECID_APP_TYPE_BIND = 1;
    public static final int SECID_APP_BIND_NONE = 0;
    public static final int SECID_APP_BIND_MASTER = 1;
    public static final int SECID_APP_BIND_CUSTOM = 2;
    public String appid;
    public String name;
    public String sid;
    public int type;
    public String icon;
    public String auth_hint;
    public String bind_hint;
    public int bind_uname;
    public int bind_passw;
    public SPPasswordPolicy bind_passw_policy = new SPPasswordPolicy();
    public Bitmap app_bitmap = null;
    public String db_json;
    public String save_time;
    public String account_name = "";
    public String account_pass = "";
    public boolean icon_need_update = true;

    public static SPSecIDAppInfo parse(JSONObject json) {
        SPSecIDAppInfo app = new SPSecIDAppInfo();
        app.appid = json.optString("app_id");
        app.name = json.optString("name");
        app.sid = json.optString("sid");
        app.icon = json.optString("icon");
        app.type = SPStringUtil.parseInt(json.optString("type"));
        app.auth_hint = json.optString("auth_hint");
        app.bind_hint = json.optString("bind_hint");
        app.bind_uname = json.optInt("bind_uname");
        app.bind_passw = json.optInt("bind_passw");
        app.bind_passw_policy = SPPasswordPolicy.fromBrokerRsp(json.optJSONObject("bind_passw_policy"));
        return app;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "app_id", this.appid);
        SPJSONUtil.put(json, "name", this.name);
        SPJSONUtil.put(json, "sid", this.sid);
        SPJSONUtil.put(json, "icon", this.icon);
        SPJSONUtil.put(json, "type", String.valueOf(this.type));
        SPJSONUtil.put(json, "auth_hint", this.auth_hint);
        SPJSONUtil.put(json, "bind_hint", this.bind_hint);
        SPJSONUtil.put(json, "bind_uname", String.valueOf(this.bind_uname));
        SPJSONUtil.put(json, "bind_passw", String.valueOf(this.bind_passw));
        SPJSONUtil.put(json, "bind_passw_policy", this.bind_passw_policy.toJSON());
        return json;
    }
}

