/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.secid;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.secure.comm.SPLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.secid.SPSecIDAppInfo;
import com.secure.sportal.secid.SPSecIDAuthResult;
import com.secure.sportal.secid.SPSecIDBindInfo;
import com.secure.sportal.secid.SPSecIDQRCode;
import com.secure.sportal.secid.SPSecIDSession;
import com.secure.sportal.secid.SPSecIDSessionBox;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPSecIDUserInfo;
import com.secure.sportal.secid.SPTOtpTokenInfo;
import com.secure.sportal.secid.uniq.SPUniqueIDUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;

public class SPSecID {
    public static final int SECID_INVALID_USER = 0x2000404;
    public static final int SECID_INVALID_QRCODE = 0x11000400;
    public static final int SECID_UNRECOGOIZE_QRCODE = 285213718;
    public static final int SECID_AUTH_FAILED = 252772360;
    public static final int SECID_LOGIN_CODE_SMS = 252772355;
    public static final int SECID_LOGIN_CODE_MAIL = 252772356;
    public static final int SECID_LOGIN_PASS_RESET = 252772357;
    public static final String SECID_KEY_AUTH_CODE = "secid_auth_code";
    private static String mDevID = null;
    public static SPLog mLog = SPLog.getLogp("[ID]");

    public static String devid(Context context) {
        if (TextUtils.isEmpty((CharSequence)mDevID)) {
            Map<String, String> devInfo = SPDeviceUtil.getDeviceInfo(context);
            mDevID = devInfo.get("devid");
        }
        return mDevID;
    }

    public static SecIDRequest refreshToken(final Context context, final SPSecIDUID uid, final SecIDUserinfoCallback callback) {
        if (null != uid && !TextUtils.isEmpty((CharSequence)uid.username) && TextUtils.isEmpty((CharSequence)SPSecIDSessionBox.mSingleUsername)) {
            SPSecIDSessionBox.mSingleUsername = uid.username;
        }
        SPSecIDSessionBox.instance().load(context, SPSecID.devid(context));
        final SPMsgRsp<SPSecIDUserInfo> rsp = new SPMsgRsp<SPSecIDUserInfo>();
        final SecIDRequest request = new SecIDRequest();
        final SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null != session && session.isOnline()) {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_refresh_token";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            request.broker = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port, session.userinfo.host, new GatewayBroker.BrokerCallback(){

                @Override
                public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
                    rsp.errcode = msgrsp.errcode;
                    if (0 == msgrsp.errcode) {
                        final String refresh_token = msgrsp.json.optString("refresh_token");
                        final String access_token = msgrsp.json.optString("access_token");
                        GatewayReq msgreq = new GatewayReq(0);
                        msgreq.msgid = "secid_get_userdata";
                        msgreq.data.put("access_token", access_token);
                        msgreq.data.put("dev_id", SPSecID.devid(context));
                        if (session.userinfo.gather_dev_feature) {
                            msgreq.data.put("dev_feature", SPUniqueIDUtil.getDeviceFP(context));
                        }
                        request.broker = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port, session.userinfo.host, new GatewayBroker.BrokerCallback(){

                            @Override
                            public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
                                rsp.errcode = msgrsp.errcode;
                                if (0 == msgrsp.errcode) {
                                    SPSecIDUserInfo userinfo = SPSecIDUserInfo.parse(msgrsp.json, SPSecID.devid(context));
                                    userinfo.host = session.userinfo.host;
                                    userinfo.port = session.userinfo.port;
                                    userinfo.username = session.userinfo.username;
                                    userinfo.refresh_token = refresh_token;
                                    userinfo.access_token = access_token;
                                    session.userinfo = userinfo;
                                    SPSecIDSessionBox.instance().setActive(uid);
                                    SPSecIDSessionBox.instance().store(context, SPSecID.devid(context));
                                    rsp.setData(userinfo);
                                }
                                if (null != callback) {
                                    rsp.setData(session.userinfo);
                                    callback.onMsgRspSecIDUserinfo(rsp);
                                }
                            }
                        });
                    } else if (null != callback) {
                        rsp.setData(session.userinfo);
                        callback.onMsgRspSecIDUserinfo(rsp);
                    }
                }
            });
        } else if (null != callback) {
            SPSecIDUserInfo secIDUserInfo = new SPSecIDUserInfo();
            secIDUserInfo.host = uid.svr_host;
            secIDUserInfo.port = uid.svr_port;
            secIDUserInfo.username = uid.username;
            rsp.errcode = 0x2000404;
            rsp.setData(secIDUserInfo);
            callback.onMsgRspSecIDUserinfo(rsp);
        }
        return request;
    }

    public static SPMsgRsp<SPSecIDUserInfo> refreshToken(Context context, SPSecIDUID uid) {
        if (null != uid && !TextUtils.isEmpty((CharSequence)uid.username) && TextUtils.isEmpty((CharSequence)SPSecIDSessionBox.mSingleUsername)) {
            SPSecIDSessionBox.mSingleUsername = uid.username;
        }
        SPSecIDSessionBox.instance().load(context, SPSecID.devid(context));
        SPMsgRsp<SPSecIDUserInfo> rsp = new SPMsgRsp<SPSecIDUserInfo>();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null != session && session.isOnline()) {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_refresh_token";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            rsp.errcode = msgrsp.errcode;
            if (0 == msgrsp.errcode) {
                String access_token = msgrsp.json.optString("access_token");
                String refresh_token = msgrsp.json.optString("refresh_token");
                SPMsgRsp<SPSecIDUserInfo> user = SPSecID.getUserdata(context, session.userinfo.host, session.userinfo.port, access_token, session.userinfo.gather_dev_feature);
                rsp.errcode = user.errcode;
                if (user.errcode == 0) {
                    user.data().host = session.userinfo.host;
                    user.data().port = session.userinfo.port;
                    user.data().username = session.userinfo.username;
                    user.data().access_token = access_token;
                    user.data().refresh_token = refresh_token;
                    session.userinfo = user.data();
                    SPSecIDSessionBox.instance().setActive(uid);
                    SPSecIDSessionBox.instance().store(context, SPSecID.devid(context));
                }
            }
            rsp.setData(session.userinfo);
        } else {
            rsp.errcode = 0x2000404;
            rsp.setData(new SPSecIDUserInfo());
        }
        return rsp;
    }

    private static SPMsgRsp<SPSecIDUserInfo> getUserdata(Context context, String host, int port, String access_token, boolean gather_dev_feature) {
        SPMsgRsp<SPSecIDUserInfo> rsp = new SPMsgRsp<SPSecIDUserInfo>();
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "secid_get_userdata";
        msgreq.data.put("access_token", access_token);
        msgreq.data.put("dev_id", SPSecID.devid(null));
        if (gather_dev_feature) {
            msgreq.data.put("dev_feature", SPUniqueIDUtil.getDeviceFP(context));
        }
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, host, port);
        rsp.errcode = msgrsp.errcode;
        if (0 == msgrsp.errcode) {
            SPSecIDUserInfo userinfo = SPSecIDUserInfo.parse(msgrsp.json, mDevID);
            userinfo.host = host;
            userinfo.port = port;
            rsp.setData(userinfo);
        }
        return rsp;
    }

    public static SPMsgRsp<SPSecIDUserInfo> loginServer(Context context, String host, int port, Properties authdata) {
        if (SPSystemUtil.isRunInMainThread()) {
            throw new RuntimeException("Cann't be invoked in main thread");
        }
        SPMsgRsp<SPSecIDUserInfo> rsp = new SPMsgRsp<SPSecIDUserInfo>();
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "secid_login";
        SPSecIDUID uid = new SPSecIDUID(authdata.getProperty("username", ""), host, port);
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, false);
        msgreq.data.put("username", authdata.getProperty("username", ""));
        msgreq.data.put("password", authdata.getProperty("password", ""));
        msgreq.data.put("req_code", authdata.getProperty("req_code", "1"));
        msgreq.data.put("dev_id", SPSecID.devid(context));
        String access_token = authdata.getProperty("access_token", "");
        if (TextUtils.isEmpty((CharSequence)access_token)) {
            access_token = TextUtils.isEmpty((CharSequence)session.cachedAccessToken) ? "" : session.cachedAccessToken;
        }
        msgreq.data.put("access_token", access_token);
        msgreq.data.put("check_code_sms", authdata.getProperty("check_code_sms", ""));
        msgreq.data.put("check_code_mail", authdata.getProperty("check_code_mail", ""));
        msgreq.data.put("auth_cert_type", authdata.getProperty("auth_cert_type", ""));
        msgreq.data.put("auth_cert_base64", authdata.getProperty("auth_cert_base64", ""));
        msgreq.data.put("auth_cert_pass", authdata.getProperty("auth_cert_pass", ""));
        msgreq.data.put("auth_cert_sign", authdata.getProperty("auth_cert_sign", ""));
        Map<String, String> devInfo = SPDeviceUtil.getDeviceInfo(context);
        msgreq.data.put("dev_id", devInfo.get("devid"));
        msgreq.data.put("dev_os", devInfo.get("os"));
        msgreq.data.put("dev_os_version", devInfo.get("os_version"));
        msgreq.data.put("dev_model", devInfo.get("model"));
        msgreq.data.put("virus", authdata.getProperty("virus", "0"));
        msgreq.data.put("rooted", SPDeviceUtil.isRooted() ? "1" : "0");
        msgreq.data.put("dev_feature", SPUniqueIDUtil.getDeviceFP(context));
        for (Object key : authdata.keySet()) {
            String name = key.toString();
            if (!name.startsWith("extra_")) continue;
            msgreq.data.put(name, authdata.getProperty(name));
        }
        if (!TextUtils.isEmpty((CharSequence)SPApplication.getSdkDevIDSuffix())) {
            msgreq.data.put("extra_dev_type", "1");
        }
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, host, port);
        rsp.errcode = msgrsp.errcode;
        if (msgrsp.errcode == 0 && null != msgrsp.json) {
            SPSecIDUserInfo userinfo = SPSecIDUserInfo.parse(msgrsp.json, SPSecID.devid(context));
            userinfo.host = host;
            userinfo.port = port;
            if (TextUtils.isEmpty((CharSequence)userinfo.access_token)) {
                userinfo.access_token = access_token;
            } else {
                session.cachedAccessToken = userinfo.access_token;
            }
            rsp.setData(userinfo);
            session.cahcedUserInfo = userinfo;
            session.cahcedUserInfo.username = authdata.getProperty("username", "");
            session.cahcedUserInfo.password = authdata.getProperty("password", "");
            if (rsp.data().req_code == 0) {
                session.setUserinfo(session.cahcedUserInfo);
                SPSecIDSessionBox.instance().setActive(uid);
                SPSecIDSessionBox.instance().store(context, SPSecID.devid(context));
            }
        }
        return rsp;
    }

    public static GatewayRsp logout(Context context, SPSecIDUID uid) {
        GatewayRsp rsp = null;
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null != session) {
            SPSecIDSessionBox.instance().remove(context, SPSecID.devid(context), uid);
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_logout";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            rsp = GatewayBroker.request(msgreq, uid.svr_host, uid.svr_port);
        }
        return rsp;
    }

    public static SPTOtpTokenInfo totpGenerateToken(SPSecIDUID uid) {
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        SPTOtpTokenInfo token = new SPTOtpTokenInfo();
        token.errcode = -1;
        if (null == session) {
            Log.d((String)"totpGenerateToken", (String)("totpGenerateToken can not find session for " + uid.username + "@" + uid.svr_host + ":" + uid.svr_port));
            token.errcode = 0x2000404;
        } else {
            JSONObject reqjson = new JSONObject();
            SPJSONUtil.put(reqjson, "key", session.userinfo.otp_key);
            SPJSONUtil.put(reqjson, "mask", session.userinfo.otp_mask);
            SPJSONUtil.put(reqjson, "offset", String.valueOf(session.userinfo.otp_offset));
            SPJSONUtil.put(reqjson, "step", String.valueOf(session.userinfo.otp_step));
            SPJSONUtil.put(reqjson, "digits", String.valueOf(session.userinfo.otp_digits));
            SPJSONUtil.put(reqjson, "algo", session.userinfo.otp_algo);
            byte[] rsp = new byte[1024];
            token.errcode = SPLibBridge.exeCmd("token_generate_totp", reqjson.toString(), rsp);
            if (0 == token.errcode) {
                JSONObject rspjson = SPJSONUtil.parseObject(new String(rsp));
                token.token = rspjson.optString("token_totp");
                token.left = rspjson.optInt("left", (int)session.userinfo.otp_step);
            }
        }
        return token;
    }

    public static SPTOtpTokenInfo totpGenerateTokenOffline(String key, long offset, long step, String algo) {
        SPTOtpTokenInfo token = new SPTOtpTokenInfo();
        token.errcode = -1;
        JSONObject reqjson = new JSONObject();
        SPJSONUtil.put(reqjson, "key", key);
        SPJSONUtil.put(reqjson, "mask", "");
        SPJSONUtil.put(reqjson, "offset", 0);
        SPJSONUtil.put(reqjson, "step", step);
        SPJSONUtil.put(reqjson, "digits", 6);
        SPJSONUtil.put(reqjson, "algo", algo);
        byte[] rsp = new byte[1024];
        token.errcode = SPLibBridge.exeCmd("token_generate_totp", reqjson.toString(), rsp);
        if (0 == token.errcode) {
            JSONObject rspjson = SPJSONUtil.parseObject(new String(rsp));
            token.token = rspjson.optString("token_totp");
            token.left = rspjson.optInt("left", (int)step);
        }
        return token;
    }

    public static SPTOtpTokenInfo otpAuth(String otpuri) {
        SPTOtpTokenInfo token = new SPTOtpTokenInfo();
        token.errcode = -1;
        JSONObject reqjson = new JSONObject();
        SPJSONUtil.put(reqjson, "otp_uri", otpuri);
        byte[] rsp = new byte[1024];
        token.errcode = SPLibBridge.exeCmd("token_generate_totp", reqjson.toString(), rsp);
        if (0 == token.errcode) {
            JSONObject rspjson = SPJSONUtil.parseObject(new String(rsp));
            token.otpuri = otpuri;
            token.setResponseJSON(rspjson);
            token.token = rspjson.optString("token_totp");
            token.left = rspjson.optInt("left", 30);
        }
        return token;
    }

    private static SPMsgRsp<SPSecIDAppInfo> secidGetAppInfo(Context context, SPSecIDSession session, String appcode) {
        SPMsgRsp<SPSecIDAppInfo> rsp = new SPMsgRsp<SPSecIDAppInfo>();
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "secid_get_appinfo";
        msgreq.data.put("access_token", session.userinfo.access_token);
        msgreq.data.put("refresh_token", session.userinfo.refresh_token);
        msgreq.data.put("app_code", appcode);
        msgreq.data.put("dev_id", SPSecID.devid(context));
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
        SPSecIDUID uid = new SPSecIDUID(session.userinfo.username, session.userinfo.host, session.userinfo.port);
        if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
        }
        rsp.errcode = msgrsp.errcode;
        if (rsp.errcode == 0) {
            rsp.setData(SPSecIDAppInfo.parse(msgrsp.json));
        }
        return rsp;
    }

    public static SPMsgRsp<SPSecIDAppInfo> secidAuthenQRCode(Context context, SPSecIDUID uid, String codeURL) {
        SPMsgRsp<SPSecIDAppInfo> rsp = new SPMsgRsp<SPSecIDAppInfo>();
        SPSecIDQRCode qrcode = null;
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            Log.e((String)"SPSecID", (String)"session is null");
            rsp.errcode = 0x2000404;
        } else {
            qrcode = SPSecIDQRCode.recognize(codeURL, session.userinfo.host, session.userinfo.port);
            if (null == qrcode) {
                Log.e((String)"SPSecID", (String)"recognize qrcode error");
                rsp.errcode = 285213718;
            } else {
                SPMsgRsp<SPSecIDAppInfo> app = SPSecID.secidGetAppInfo(context, session, qrcode.code);
                rsp.errcode = app.errcode;
                if (0 == app.errcode) {
                    rsp.setData(app.data());
                }
            }
        }
        return rsp;
    }

    public static SPMsgRsp<SPSecIDAuthResult> secidAuthenApp(Context context, SPSecIDUID uid, SPSecIDAppInfo app, boolean refuse, Properties binds) {
        SPMsgRsp<SPSecIDAuthResult> rsp = new SPMsgRsp<SPSecIDAuthResult>();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            rsp.errcode = 0x2000404;
        } else {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_auth_app";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("sid", app.sid);
            msgreq.data.put("app_id", app.appid);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            msgreq.data.put("refuse", refuse ? "1" : "0");
            if (null != binds) {
                msgreq.data.put("username", binds.getProperty("username", ""));
                msgreq.data.put("password", binds.getProperty("password", ""));
            }
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
            if (rsp.errcode == 0) {
                SPSecIDAuthResult result = new SPSecIDAuthResult();
                result.parse(msgrsp.json);
                rsp.setData(result);
            }
        }
        return rsp;
    }

    public static String secidEncryptBindData(SPSecIDUID uid, String data) {
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null != session) {
            byte[] bytes = new byte[65536];
            JSONObject reqjson = new JSONObject();
            SPJSONUtil.put(reqjson, "pubkey", session.userinfo.sid_pubkey);
            SPJSONUtil.put(reqjson, "bind_data", data);
            if (0 == SPLibBridge.exeCmd("secid_encrypt_authinfo", reqjson.toString(), bytes)) {
                JSONObject rspjson = SPJSONUtil.parseObject(new String(bytes));
                return rspjson.optString("bind_data");
            }
        }
        return "";
    }

    private static SPMsgRsp<List<SPSecIDBindInfo>> secidDecryptBackup(String password, String backupdata) {
        SPMsgRsp<List<SPSecIDBindInfo>> rsp = new SPMsgRsp<List<SPSecIDBindInfo>>();
        JSONObject reqjson = new JSONObject();
        SPJSONUtil.put(reqjson, "password", password);
        SPJSONUtil.put(reqjson, "backup_data", backupdata);
        byte[] rspbytes = new byte[65536];
        SPLibBridge.exeCmd("secid_decrypt_backup", reqjson.toString(), rspbytes);
        JSONObject json = SPJSONUtil.parseObject(new String(rspbytes));
        rsp.errcode = json.optInt("_errcode", Integer.MAX_VALUE);
        if (0 == rsp.errcode) {
            backupdata = json.optString("backup_data");
            rsp.setData(SPSecIDBindInfo.parseBackup(backupdata));
        } else {
            rsp.errmsg = "\u89e3\u5bc6\u6570\u636e\u5931\u8d25";
        }
        return rsp;
    }

    public static SPMsgRspEmpty secidPutBackup(Context context, SPSecIDUID uid, String password, List<SPSecIDBindInfo> binds) {
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            rsp.errcode = 0x2000404;
            return rsp;
        }
        JSONObject reqjson = new JSONObject();
        SPJSONUtil.put(reqjson, "password", password);
        SPJSONUtil.put(reqjson, "backup_data", SPSecIDBindInfo.buildBackup(binds));
        byte[] rspbytes = new byte[65536];
        SPLibBridge.exeCmd("secid_encrypt_backup", reqjson.toString(), rspbytes);
        JSONObject json = SPJSONUtil.parseObject(new String(rspbytes));
        int errcode = json.optInt("_errcode", Integer.MAX_VALUE);
        if (0 == errcode) {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_backup_upload";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("backup_data", json.optString("backup_data"));
            msgreq.data.put("dev_id", SPSecID.devid(context));
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
        }
        return rsp;
    }

    public static SPMsgRsp<List<SPSecIDBindInfo>> secidGetBackup(Context context, SPSecIDUID uid, String password) {
        SPMsgRsp<List<SPSecIDBindInfo>> rsp = new SPMsgRsp<List<SPSecIDBindInfo>>();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            rsp.errcode = 0x2000404;
            return rsp;
        }
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "secid_backup_download";
        msgreq.data.put("access_token", session.userinfo.access_token);
        msgreq.data.put("refresh_token", session.userinfo.refresh_token);
        msgreq.data.put("dev_id", SPSecID.devid(context));
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
        if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
        }
        rsp.errcode = msgrsp.errcode;
        if (0 == msgrsp.errcode) {
            return SPSecID.secidDecryptBackup(password, msgrsp.json.optString("backup_data"));
        }
        rsp.errmsg = "\u83b7\u53d6\u5907\u4efd\u6570\u636e\u5931\u8d25";
        return rsp;
    }

    public static SPMsgRspEmpty secidResetPassword(Context context, SPSecIDUID uid, String newPass, String oldPass, String verifyCode) {
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, false);
        if (null == session.cahcedUserInfo && null == session.userinfo) {
            rsp.errcode = 0x2000404;
        } else {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_reset_password";
            SPSecIDUserInfo userinfo = null != session.cahcedUserInfo ? session.cahcedUserInfo : session.userinfo;
            msgreq.data.put("access_token", userinfo.access_token);
            msgreq.data.put("refresh_token", userinfo.refresh_token);
            msgreq.data.put("req_code", String.valueOf(userinfo.req_code));
            msgreq.data.put("password_new", null != newPass ? newPass : "");
            msgreq.data.put("password_old", null != oldPass ? oldPass : "");
            msgreq.data.put("verify_code", TextUtils.isEmpty((CharSequence)verifyCode) ? "" : verifyCode);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, userinfo.host, userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && userinfo.req_code == 0 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
        }
        return rsp;
    }

    public static SPMsgRsp<String> secidRequestAuthCode(Context context, SPSecIDUID uid, String appid, Properties params) {
        SPMsgRsp<String> rsp = new SPMsgRsp<String>();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            rsp.errcode = 0x2000404;
        } else {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_request_auth_code";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("app_id", appid);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            if (params != null) {
                for (Object key : params.keySet()) {
                    String name = key.toString();
                    if (!name.startsWith("extra_")) continue;
                    msgreq.data.put(name, params.getProperty(name));
                }
            }
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
            if (rsp.errcode == 0) {
                rsp.setData(msgrsp.json.optString("auth_code"));
            }
        }
        return rsp;
    }

    public static SPMsgRspEmpty secidPushAllows(Context context, SPSecIDUID uid, String pushID, boolean allows) {
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        if (null == session) {
            rsp.errcode = 0x2000404;
        } else {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_push_respond";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            msgreq.data.put("push_id", pushID);
            msgreq.data.put("allows", allows ? "1" : "0");
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
        }
        return rsp;
    }

    public static SPMsgRspEmpty secidUnbindDevID(Context context, SPSecIDUID uid, String devid) {
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        SPSecIDSession session = SPSecIDSessionBox.instance().get(uid, true);
        devid = SPStringUtil.opt(devid);
        if (null == session || devid.length() < 1) {
            rsp.errcode = 0x2000404;
        } else {
            GatewayReq msgreq = new GatewayReq(0);
            msgreq.msgid = "secid_unbind_device";
            msgreq.data.put("access_token", session.userinfo.access_token);
            msgreq.data.put("refresh_token", session.userinfo.refresh_token);
            msgreq.data.put("dev_id", SPSecID.devid(context));
            msgreq.data.put("dev_id_target", devid);
            GatewayRsp msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            if ((msgrsp.errcode & 0xFFFF) == 1028 && SPSecID.refreshToken((Context)context, (SPSecIDUID)uid).errcode == 0) {
                msgreq.data.put("access_token", session.userinfo.access_token);
                msgreq.data.put("refresh_token", session.userinfo.refresh_token);
                msgrsp = GatewayBroker.request(msgreq, session.userinfo.host, session.userinfo.port);
            }
            rsp.errcode = msgrsp.errcode;
        }
        return rsp;
    }

    public static void startApp(Context context, String pkgname, String authCode) {
        Bundle extras = new Bundle();
        extras.putString(SECID_KEY_AUTH_CODE, authCode);
        SPIntentUtil.loadApp(context, pkgname, null, extras);
    }

    public static class SecIDRequest {
        private GatewayBroker broker = null;

        private SecIDRequest() {
        }

        public void abort() {
            if (null != this.broker) {
                this.broker.abort();
            }
        }
    }

    public static interface SecIDUserinfoCallback {
        public void onMsgRspSecIDUserinfo(SPMsgRsp<SPSecIDUserInfo> var1);
    }
}

