/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.vpn;

import android.content.Context;
import android.content.Intent;
import com.secure.comm.SPLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.net.SPInetAddress;
import com.secure.sportal.sdk.vpn.SPNCDataInfo;
import com.secure.sportal.sdk.vpn.SPNCService;
import com.secure.sportal.service.PortalSession;
import java.io.Serializable;
import java.util.List;

public class SPNCServiceManagement {
    public static final int ERR_NC_CONNECT = 251789313;
    public static final int ERR_NC_HANDSHAKE = 0xF020002;
    public static final int ERR_NC_TUN = 251789315;
    public static final int REQUEST_CODE = 36010;
    public static final int STATE_STOPED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_ERROR = 3;
    public static final String ACTION_NC_STATE = "com.secure.sportal.sdk.vpn.MSG_ACTION";
    public static final String MSG_EXTRA_STATE = "com.secure.sportal.sdk.vpn.MSG_EXTRA_STATE";
    public static final String MSG_EXTRA_ERRCODE = "com.secure.sportal.sdk.vpn.MSG_EXTRA_ERRCODE";
    public static final String MSG_EXTRA_TUN_IP = "com.secure.sportal.sdk.vpn.MSG_EXTRA_TUN_IP";
    private static SPLog mLog = SPLog.getLogp("[NC]");
    public static SPNCDataInfo mNCData = null;
    private static Context mContext = null;

    public static int getNCState() {
        return SPNCService.getTunState();
    }

    public static void startOrStopNC(Context context, boolean start, boolean toastMsg, boolean autoLogin) {
        SPNCServiceManagement.startOrStopNC(context, start, toastMsg, autoLogin, 0, null);
    }

    public static void startOrStopNC(Context context, boolean start, boolean toastMsg, boolean autoLogin, int errorTimes) {
        SPNCServiceManagement.startOrStopNC(context, start, toastMsg, autoLogin, errorTimes, null);
    }

    public static void startOrStopNC(Context context, boolean start, boolean toastMsg, boolean autoLogin, int errorTimes, List<String> allowedPkgNames) {
        if (start) {
            PortalSession session = PortalSession.instance(context);
            SPNCDataInfo ncdata = new SPNCDataInfo();
            ncdata.toastMsg = toastMsg;
            ncdata.autoLogin = autoLogin;
            ncdata.errorTimes = errorTimes;
            ncdata.ticket = session.me().ticket;
            ncdata.username = session.me().username;
            ncdata.vpn_host = PortalSession.vpnHost();
            ncdata.vpn_port = PortalSession.vpnPort();
            ncdata.smxEncryptAlgorithm = session.userdata().smxAlgCipher;
            ncdata.svcList.addAll(session.userdata().ncSvcList);
            ncdata.inetBlockingEnable = session.userdata().policy.inetBlockingEnable;
            ncdata.inetBlockingBlackList.addAll(session.userdata().policy.inetBlockingBlackList);
            ncdata.bypassPkgNames.addAll(PortalSession.bypassPkgNames);
            ncdata.allowedPkgNames.clear();
            if (null != allowedPkgNames && allowedPkgNames.size() > 0) {
                ncdata.allowedPkgNames.addAll(allowedPkgNames);
            }
            if (null != PortalSession.bypassAddresses) {
                for (SPInetAddress addr : PortalSession.bypassAddresses) {
                    ncdata.bypassIPs.add(addr.ip);
                }
            }
            SPNCServiceManagement.startNC(context, ncdata);
        } else {
            SPNCServiceManagement.stopNC(context);
        }
    }

    public static void startNC(Context context, SPNCDataInfo ncdata) {
        if (null != ncdata && ncdata.svcList.size() > 0 && null != context) {
            mContext = context.getApplicationContext();
            if (mNCData != ncdata && null != ncdata) {
                mNCData = ncdata;
            }
            if (mContext.getPackageName().startsWith("com.esg360") || mContext.getPackageName().startsWith("com.legendsec.") || SPOEM.isOEM_MPolicyZJ()) {
                SPNCServiceManagement.mNCData.errorTimes = 0;
                SPNCServiceManagement.mNCData.toastMsg = true;
            }
            mLog.v("NCServiceManagement.startNC: %s", ncdata.toString());
            SPNCService.DNS_GATEWAY = false;
            if (ncdata.dnsGateway || ncdata.vpn_host.endsWith(".bankcomm.com") || SPOEM.isOEM_Bankcomm() || mContext.getPackageName().startsWith("com.bankcomm.")) {
                SPNCService.DNS_GATEWAY = true;
            }
            Intent intent = new Intent(mContext, SPNCService.class);
            intent.putExtra("ncdata", (Serializable)mNCData);
            intent.setAction("startnc");
            context.startService(intent);
        }
    }

    public static void stopNC(Context context) {
        Context context2 = context = null == context ? mContext : context;
        if (null == context) {
            context = SPApplication.appContext();
        }
        if (null != context) {
            SPNCService.setRunning(false);
            context.stopService(new Intent(context, SPNCService.class));
        }
    }
}

