/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.vpn;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.system.OsConstants;
import android.text.TextUtils;
import android.widget.Toast;
import com.secure.comm.SPLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPNCIFConfigInfo;
import com.secure.sportal.entry.SPNetItemInfo;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPTunStatus;
import com.secure.sportal.gateway.GatewayBrokerSAC;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.SPVPNClient;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.sdk.app.SPNCConfigActivity;
import com.secure.sportal.sdk.vpn.SPNCDataInfo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class SPNCService
extends VpnService
implements Runnable {
    public static final String START_SERVICE = "startnc";
    public static final String NC_DATA = "ncdata";
    private static final int STATE_SSL = 1;
    private static final int STATE_TUN = 2;
    private static final int STATE_RUN = 3;
    public static SPTunStatus tunnelStatus = new SPTunStatus();
    public static boolean DNS_GATEWAY = false;
    private static SPLog mLog = SPLog.getLogp("[NC]");
    private static AtomicInteger mTunState = new AtomicInteger(0);
    private static AtomicInteger mErrorCode = new AtomicInteger(0);
    private static AtomicReference<Thread> mThread = new AtomicReference<Object>(null);
    private static AtomicReference<String> mToastText = new AtomicReference<String>("");
    private int mState;
    private String mVpnHost;
    private String mVpnIP;
    private int mVpnPort;
    private byte[] mTicket;
    private String mUsername;
    private SPNCIFConfigInfo mIFConfig;
    private List<SPServiceInfo> mSvcList = new ArrayList<SPServiceInfo>();
    private boolean mLoginRenew = false;
    private boolean mToastMsg = true;
    private int mMaxErrorTimes = 0;
    private boolean mInetBlocking = false;
    private List<String> mAllowedPkgNames = new ArrayList<String>();
    private List<String> mBypassPkgNames = new ArrayList<String>();
    private List<String> mBypassIPs = new ArrayList<String>();
    private SocketChannel mSSLConn;
    private byte[] mSSLData;
    private int mSSLLen;
    private int mMTU = 1400;
    private boolean mTunFixMSS = true;
    private ParcelFileDescriptor mTunFD;
    private FileInputStream mTunIns;
    private FileOutputStream mTunOuts;
    private byte[] mTunData;
    private PendingIntent mPendingIntent;
    private static AtomicBoolean mRunning = new AtomicBoolean(false);
    private Toast mToast;

    public static void setRunning(boolean b) {
        mRunning.set(b);
    }

    public static int getTunState() {
        return mTunState.get();
    }

    public static int getErrorCode() {
        return mErrorCode.get();
    }

    public void onCreate() {
        mLog.d("SPNCService.onCreate", new Object[0]);
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        mLog.d("SPNCService.onStartCommand flags=%d, startId=%d", flags, startId);
        if (null != intent && !mRunning.get()) {
            final SPNCDataInfo ncdata = (SPNCDataInfo)intent.getSerializableExtra(NC_DATA);
            if (START_SERVICE.equals(intent.getAction()) && ncdata != null) {
                new Thread(){

                    @Override
                    public void run() {
                        SPNCService.this.startNC(ncdata);
                    }
                }.start();
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onTaskRemoved(Intent rootIntent) {
        mLog.d("SPNCService.onTaskRemoved() has been invoked !!!!!", new Exception());
        this.stopNC();
        super.onTaskRemoved(rootIntent);
    }

    public void onRevoke() {
        mLog.d("SPNCService.onRevoke() has been invoked !!!!!", new Exception());
        this.stopNC();
        super.onRevoke();
    }

    private void startKeepAlive() {
    }

    private void stopKeepAlive() {
    }

    private synchronized void publishState(int state) {
        if (mTunState.get() != state) {
            mTunState.set(state);
            mLog.d("SPNCService.publishState %d (0:STOPED, 1:CONNECTING, 2:CONNECTED, 3:ERROR)", mTunState.get());
            SPNCService.tunnelStatus.status = state;
            Bundle extras = new Bundle();
            extras.putInt("com.secure.sportal.sdk.vpn.MSG_EXTRA_STATE", mTunState.get());
            extras.putInt("com.secure.sportal.sdk.vpn.MSG_EXTRA_ERRCODE", mErrorCode.get());
            if (mTunState.get() == 2) {
                extras.putString("com.secure.sportal.sdk.vpn.MSG_EXTRA_TUN_IP", this.mIFConfig.ipAddress());
            }
            SPIntentUtil.sendLocalBroadcast((Context)this, "com.secure.sportal.sdk.vpn.MSG_ACTION", extras);
        }
    }

    private void parseUserData(SPNCDataInfo ncdata) {
        this.mLoginRenew = ncdata.autoLogin;
        this.mToastMsg = ncdata.toastMsg;
        this.mTicket = ncdata.ticket;
        this.mUsername = ncdata.username;
        this.mVpnHost = ncdata.vpn_host;
        this.mVpnIP = SPIPUtil.nameToIP(ncdata.vpn_host);
        this.mVpnPort = ncdata.vpn_port;
        this.mSvcList.clear();
        this.mSvcList.addAll(ncdata.svcList);
        this.mAllowedPkgNames.clear();
        this.mAllowedPkgNames.addAll(ncdata.allowedPkgNames);
        this.mBypassPkgNames.clear();
        this.mBypassPkgNames.addAll(ncdata.bypassPkgNames);
        this.mBypassIPs.clear();
        this.mBypassIPs.addAll(ncdata.bypassIPs);
        this.mMaxErrorTimes = ncdata.errorTimes * 2 + 1;
    }

    private synchronized void startNC(SPNCDataInfo ncdata) {
        mLog.v("SPNCService.startNC", new Object[0]);
        this.stopNC();
        mRunning.set(true);
        this.parseUserData(ncdata);
        if (null == mThread.get()) {
            mThread.set(new Thread(this));
            mThread.get().start();
        }
    }

    private void stopNC() {
        this.stopKeepAlive();
        if (mRunning.get()) {
            mRunning.set(false);
            this.mState = 0;
            this.closeRemote();
            this.closeTun();
        }
        if (null != mThread.get()) {
            ((Thread)mThread.getAndSet(null)).interrupt();
        }
        this.stopSelf();
        this.publishState(0);
        tunnelStatus.clear();
    }

    private void toastMsg(final String text) {
        if (this.mToastMsg && !TextUtils.isEmpty((CharSequence)text)) {
            if (text.equals(mToastText.get())) {
                return;
            }
            mToastText.set(text);
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPNCService.this.showToast(text);
                }
            }, 0L);
        }
    }

    @Override
    public void run() {
        int errorTimes = 0;
        long lastTime = 0L;
        this.mState = 0;
        mErrorCode.set(0);
        this.mSSLData = new byte[65536];
        this.mTunData = new byte[16384];
        mToastText.set("");
        boolean isEnglish = SPApplication.isLocale_En();
        this.publishState(0);
        while (mRunning.get()) {
            if ((this.mState & 3) == 3) {
                if (0 != this.readRemoteGateway() || 0 != this.readLocalTun()) continue;
                SPSystemUtil.sleepEx(1L, 0);
                continue;
            }
            if (!mRunning.get()) continue;
            this.publishState(1);
            int mask = 255;
            if (System.currentTimeMillis() - lastTime < 3000L) {
                SPSystemUtil.sleepEx(3000L);
            }
            if (!mRunning.get()) continue;
            mLog.v("SecVpnService.state = 0x%04X", this.mState);
            if ((this.mState & 1) == 0) {
                if (!isEnglish) {
                    this.toastMsg("\u6b63\u5728\u8fde\u63a5VPN\u670d\u52a1\u5668");
                } else {
                    this.toastMsg("connecting vpn server...");
                }
                this.handshakeNG();
                mask = 1;
            } else if ((this.mState & 2) == 0) {
                this.openTun();
                mask = 2;
            }
            if ((this.mState & 3) == 3) {
                mErrorCode.set(0);
                this.publishState(2);
                this.startKeepAlive();
                if (!isEnglish) {
                    this.toastMsg("\u8fde\u63a5VPN\u670d\u52a1\u5668\u6210\u529f");
                } else {
                    this.toastMsg("vpn connect success");
                }
            }
            lastTime = (this.mState & mask) == 0 ? System.currentTimeMillis() : 0L;
            errorTimes = (this.mState & 3) == 3 ? 0 : errorTimes + 1;
            mLog.d("errorTimes=%d, mMaxErrorTimes=%d", errorTimes, this.mMaxErrorTimes);
            SPVPNTool.setLogFlush();
            if (this.mMaxErrorTimes <= 2 || errorTimes <= this.mMaxErrorTimes) continue;
            if (!isEnglish) {
                this.toastMsg("\u8fde\u63a5VPN\u5931\u8d25\uff1a\u9519\u8bef\u8d85\u8fc7\u91cd\u8bd5\u6b21\u6570");
            } else {
                this.toastMsg("vpn connect failed: more than max retry");
            }
            this.publishState(3);
            mRunning.set(false);
            SPSystemUtil.sleepEx(500L);
        }
        this.closeRemote();
        this.closeTun();
        this.stopNC();
        if (!isEnglish) {
            this.toastMsg("VPN\u8fde\u63a5\u9000\u51fa");
        } else {
            this.toastMsg("vpn connect exit");
        }
    }

    private void handshakeNG() {
        mLog.d("SecVpnService.handshakeNG", new Object[0]);
        if (!SPNetUtil.isNetworkAvailable((Context)this)) {
            mLog.d("SecVpnService.handshakeNG failed: network is invalidate", new Object[0]);
            return;
        }
        try {
            int len;
            JSONObject json = new JSONObject();
            SPJSONUtil.put(json, "vpn_host", this.mVpnHost);
            SPJSONUtil.putStr(json, "vpn_port", this.mVpnPort);
            SPJSONUtil.put(json, "utun_ip", null != this.mIFConfig ? this.mIFConfig.ipAddress() : "");
            SPJSONUtil.put(json, "system_dns", SPStringUtil.join(";", SPIPUtil.getSystemDnsList()));
            int relay_port = SPLibBridge.getProxyPort();
            this.mSSLConn = SocketChannel.open(new InetSocketAddress("127.0.0.1", relay_port));
            this.mSSLConn.configureBlocking(true);
            ByteBuffer buf = ByteBuffer.allocate(16384);
            buf.put("PTUN".getBytes());
            byte[] bytes = json.toString().getBytes();
            buf.putInt(bytes.length);
            buf.put(bytes);
            this.mSSLConn.socket().getOutputStream().write(buf.array(), 0, buf.position());
            this.mSSLConn.socket().getOutputStream().flush();
            buf.clear();
            if (4 != this.mSSLConn.socket().getInputStream().read(buf.array(), 0, 4)) {
                throw new Exception("handshakeNG() SSL-End read rsp-len error");
            }
            int mlen = buf.getInt();
            buf.clear();
            for (int recv = 0; recv < mlen; recv += len) {
                len = this.mSSLConn.socket().getInputStream().read(buf.array(), recv, mlen - recv);
                if (len > 0) {
                    continue;
                }
                throw new Exception("handshakeNG() SSL-End read response error");
            }
            GatewayRsp rsp = GatewayBrokerSAC.parseNCBrokerRsp(buf.array(), 0, mlen);
            if (0 == rsp.errcode) {
                this.ifConfig((SPNCIFConfigInfo)rsp.getData());
                return;
            }
            if (1028 == (rsp.errcode & 0xFFFF)) {
                if (this.mLoginRenew) {
                    GatewayRsp srsp = SPVPNClient.sessionRenew();
                    mErrorCode.set(srsp.errcode);
                    if (0 != srsp.errcode) {
                        mLog.i("renew failed [0x%08X]%s", srsp.errcode, srsp.errmsg);
                        if (srsp.errcode != 0xFFFFFFF && srsp.errcode != 33555487 && srsp.errcode != 0x2000402) {
                            this.publishState(3);
                            this.stopNC();
                        }
                    } else if (null != srsp.json) {
                        String ticket = srsp.json.optString("ticket", "");
                        mLog.i("renew succeeded ticket=%s", ticket.substring(0, Math.min(ticket.length(), 8)));
                        if (ticket.length() == 64) {
                            this.mTicket = SPStringUtil.ticketToBytes(ticket);
                        }
                    }
                } else {
                    mErrorCode.set(rsp.errcode);
                    if (!SPApplication.isLocale_En()) {
                        this.toastMsg("\u8fde\u63a5VPN\u5931\u8d25\uff1a\u7528\u6237\u5df2\u4e0b\u7ebf");
                    } else {
                        this.toastMsg("connect vpn failed: user is logout");
                    }
                    this.stopNC();
                }
            }
        }
        catch (Exception ex) {
            mLog.i(ex);
            this.stopNC();
        }
        this.closeRemote();
    }

    private void ifConfig(SPNCIFConfigInfo ifconfig) throws Exception {
        this.mState |= 1;
        this.mSSLLen = 0;
        this.mSSLConn.configureBlocking(false);
        if (null == this.mIFConfig || !this.mIFConfig.ipAddress().equals(ifconfig.ipAddress())) {
            this.mState &= 0xFFFFFFFD;
        }
        this.mIFConfig = ifconfig;
        SPNCService.tunnelStatus.ipv4 = SPStringUtil.opt(this.mIFConfig.ipv4);
        SPNCService.tunnelStatus.ipv6 = SPStringUtil.opt(this.mIFConfig.ipv6);
        mLog.v("SecVpnService.ifConfig ip=%s", this.mIFConfig.ipAddress());
    }

    private void openTun() {
        mLog.d("SecVpnService.openTun", new Object[0]);
        try {
            List<SPNetItemInfo> connList = SPNetItemInfo.loadNetConnList((Context)this, false);
            this.closeTun();
            ArrayList<String> routeTable = new ArrayList<String>();
            this.mTunFixMSS = !SPOEM.isOEM_MPolicyZJ();
            mLog.d("ipAddress: " + this.mIFConfig.ipAddress(), new Object[0]);
            mLog.d("MTU: " + this.mMTU, new Object[0]);
            VpnService.Builder builder = new VpnService.Builder((VpnService)this);
            if (Build.VERSION.SDK_INT >= 21) {
                if (TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv6) && !TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv4)) {
                    this.setAllowFamily(builder, OsConstants.AF_INET6);
                } else if (TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv4) && !TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv6)) {
                    this.setAllowFamily(builder, OsConstants.AF_INET);
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                builder.setUnderlyingNetworks(null);
            }
            String release = Build.VERSION.RELEASE;
            if (!(Build.VERSION.SDK_INT != 19 || release.startsWith("4.4.3") || release.startsWith("4.4.4") || release.startsWith("4.4.5") || release.startsWith("4.4.6") || this.mMTU >= 1280)) {
                mLog.d("SecVpnService.openTun, Forcing MTU to 1280 instead of %d to workaround Android Bug #70916", this.mMTU);
                this.mMTU = 1280;
            }
            builder.setMtu(this.mMTU);
            ArrayList<String> routeList = new ArrayList<String>();
            ArrayList<String> dnsList = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv4)) {
                builder.addAddress(this.mIFConfig.ipv4, 32);
                routeList.addAll(this.mIFConfig.routeInclude4);
                dnsList.addAll(this.mIFConfig.dns4);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mIFConfig.ipv6)) {
                builder.addAddress(this.mIFConfig.ipv6, 128);
                routeList.addAll(this.mIFConfig.routeInclude6);
                dnsList.addAll(this.mIFConfig.dns6);
            }
            Set<String> sysDnsList = SPIPUtil.getSystemDnsList();
            for (String route : routeList) {
                this.addRoute(builder, route);
            }
            for (String dns : dnsList) {
                this.addDnsServer(builder, dns);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (!this.setAllowedPackageNames(builder)) {
                    this.setBypassPackageNames(builder);
                }
                this.setNonBlocking(builder);
            }
            builder.setSession("QianxinVPN");
            if (null == this.mPendingIntent) {
                Intent intent = new Intent(this.getBaseContext(), SPNCConfigActivity.class);
                intent.addFlags(0x10000000);
                this.mPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0);
            }
            builder.setConfigureIntent(this.mPendingIntent);
            this.mTunFD = builder.establish();
            if (null != this.mTunFD) {
                mLog.i("Build VpnService succeeded", new Object[0]);
                this.mTunIns = new FileInputStream(this.mTunFD.getFileDescriptor());
                this.mTunOuts = new FileOutputStream(this.mTunFD.getFileDescriptor());
                this.mState |= 2;
                if (SPOEM.isOEM_jygx()) {
                    DNS_GATEWAY = true;
                }
                SPLibBridge.setNCConfig(this.mVpnHost, this.mVpnPort, this.mIFConfig.ipv4, this.mIFConfig.ipv6, DNS_GATEWAY, this.mSvcList, dnsList, routeTable);
                mErrorCode.set(0);
                tunnelStatus.clear();
                SPNCService.tunnelStatus.vpn_host = this.mVpnHost;
                SPNCService.tunnelStatus.vpn_port = this.mVpnPort;
                SPNCService.tunnelStatus.ipv4 = SPStringUtil.opt(this.mIFConfig.ipv4);
                SPNCService.tunnelStatus.ipv6 = SPStringUtil.opt(this.mIFConfig.ipv6);
                SPNCService.tunnelStatus.mtu = this.mMTU;
                SPNCService.tunnelStatus.ctime = System.currentTimeMillis();
                SPNCService.tunnelStatus.dns.addAll(dnsList);
                SPNCService.tunnelStatus.routes.addAll(routeList);
                SPNCService.tunnelStatus.routeAuto = this.mIFConfig.routeAuto;
            } else {
                mErrorCode.set(251789315);
                this.toastMsg("\u542f\u52a8NC\u5931\u8d25");
                mLog.i("Build VpnService failed", new Object[0]);
            }
            if (this.mInetBlocking) {
                int myPid = Process.myPid();
                String myPkgName = this.getPackageName();
                for (SPNetItemInfo item : connList) {
                    if (item.pid == myPid || myPkgName.equals(item.pkgname)) continue;
                    SPSystemUtil.killProcess((Context)this, item.pid, item.pkgname);
                }
            }
        }
        catch (Exception ex) {
            mErrorCode.set(251789315);
            this.toastMsg("\u542f\u52a8NC\u5931\u8d25");
            mLog.d(ex);
            this.closeTun();
        }
    }

    private void addRoute(VpnService.Builder builder, String route) {
        mLog.v("Adding route " + route, new Object[0]);
        try {
            String[] splits = route.split("/", 2);
            builder.addRoute(splits[0], Integer.parseInt(splits[1]));
        }
        catch (Exception ex) {
            mLog.i("Add route " + route + " failed ", ex);
        }
    }

    private void addDnsServer(VpnService.Builder builder, String address) {
        mLog.v("Adding DNS server: " + address, new Object[0]);
        try {
            builder.addDnsServer(address);
        }
        catch (Exception ex) {
            mLog.i("Add DNS server: " + address + " failed", ex);
        }
    }

    @TargetApi(value=21)
    private void setAllowFamily(VpnService.Builder builder, int family) {
        try {
            mLog.v("setAllowFamily " + family, new Object[0]);
            builder.allowFamily(family);
        }
        catch (Exception ex) {
            mLog.i("setAllowFamily " + family + " failed", ex);
        }
    }

    @TargetApi(value=21)
    private void setNonBlocking(VpnService.Builder builder) {
        builder.setBlocking(false);
    }

    @TargetApi(value=21)
    private boolean setBypassPackageNames(VpnService.Builder builder) {
        boolean succeeded = false;
        if (null != this.mBypassPkgNames && this.mBypassPkgNames.size() > 0) {
            for (String pkgName : this.mBypassPkgNames) {
                try {
                    builder.addDisallowedApplication(pkgName);
                    succeeded = true;
                }
                catch (Exception exception) {}
            }
        }
        return succeeded;
    }

    @TargetApi(value=21)
    private boolean setAllowedPackageNames(VpnService.Builder builder) {
        boolean succeeded = false;
        if (null != this.mAllowedPkgNames && this.mAllowedPkgNames.size() > 0) {
            for (String pkgName : this.mAllowedPkgNames) {
                try {
                    builder.addAllowedApplication(pkgName);
                    succeeded = true;
                }
                catch (Exception exception) {}
            }
        }
        return succeeded;
    }

    private void closeTun() {
        if (null != this.mTunFD) {
            try {
                mLog.i("closeTun", new Object[0]);
                this.mTunFD.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mTunFD = null;
        }
        this.mTunIns = null;
        this.mTunOuts = null;
        tunnelStatus.clear();
    }

    private void closeRemote() {
        mLog.i("closeRemote", new Object[0]);
        if (null != this.mSSLConn) {
            try {
                this.mSSLConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSSLConn = null;
        }
    }

    private int readLocalTun() {
        try {
            int count;
            int total = 0;
            while ((count = this.mTunIns.read(this.mTunData, 8, 16376)) >= 1) {
                total += count;
                ByteBuffer buffer = ByteBuffer.wrap(this.mTunData);
                if (this.mTunFixMSS) {
                    SPIPUtil.fixIPPacketMSS(this.mTunData, 8, count);
                }
                buffer.position(0);
                buffer.putInt(count + 4);
                buffer.putInt(0);
                buffer.position(0).limit(count + 8);
                try {
                    this.mSSLConn.write(buffer);
                    SPNCService.tunnelStatus.bytesUp.addAndGet(count + 8);
                }
                catch (Exception exx) {
                    mLog.v(exx);
                    mLog.d("SSL write exception", new Object[0]);
                    this.mState &= 0xFFFFFFFE;
                    mErrorCode.set(251789313);
                    return -1;
                }
            }
            if (total >= 0) {
                return total;
            }
        }
        catch (Exception ex) {
            mLog.v(ex);
        }
        this.mState &= 0xFFFFFFFD;
        mErrorCode.set(251789315);
        return -1;
    }

    private int readRemoteGateway() {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(this.mSSLData, this.mSSLLen, this.mSSLData.length - this.mSSLLen);
            int count = this.mSSLConn.read(buffer);
            if (count > 0) {
                this.mSSLLen += count;
                while (mRunning.get() && this.mSSLLen >= 8) {
                    buffer.position(0);
                    int len = buffer.getInt() - 4;
                    if (len < 0) {
                        mLog.d("runReadRemote, mRLen=%d, len=%d", this.mSSLLen, len);
                        mLog.d("SSL read error", new Object[0]);
                        this.mState &= 0xFFFFFFFE;
                        return -1;
                    }
                    if (len > this.mSSLLen - 8) break;
                    try {
                        this.mTunOuts.write(this.mSSLData, 8, len);
                        SPNCService.tunnelStatus.bytesDown.addAndGet(len + 8);
                    }
                    catch (Exception exx) {
                        mLog.v(exx);
                        this.mState &= 0xFFFFFFFD;
                        mErrorCode.set(251789315);
                        return -1;
                    }
                    buffer.position(8 + len);
                    buffer.limit(this.mSSLLen);
                    buffer.compact();
                    this.mSSLLen = this.mSSLLen - 8 - len;
                }
                return count;
            }
            if (count == 0) {
                return 0;
            }
            mLog.d("SSL read error count=%d", count);
            this.mState &= 0xFFFFFFFE;
            mErrorCode.set(251789313);
            return -1;
        }
        catch (Exception ex) {
            mLog.v(ex);
            this.mState &= 0xFFFFFFFE;
            mErrorCode.set(251789313);
            return -1;
        }
    }

    public void showToast(String text) {
        if (this.mToast == null) {
            this.mToast = Toast.makeText((Context)this, (CharSequence)text, (int)0);
        } else {
            this.mToast.setText((CharSequence)text);
            this.mToast.setDuration(0);
        }
        this.mToast.show();
    }
}

