/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.robot;

import android.app.Activity;
import android.view.View;
import android.widget.Spinner;
import android.widget.TextView;
import com.secure.comm.app.SPAppLifecycleHandler;
import com.secure.comm.app.SPResourseKit;
import com.secure.sportal.sdk.robot.SPSSOItem;
import java.util.ArrayList;
import java.util.List;

public class SPSSORobot
implements SPAppLifecycleHandler.OnActivityResumeListener {
    private List<SPSSOItem> ssoList = new ArrayList<SPSSOItem>();
    private static SPSSORobot _instance = null;

    public static synchronized SPSSORobot instance() {
        return null != _instance ? _instance : (_instance = new SPSSORobot());
    }

    public void start(List<SPSSOItem> items) {
        SPAppLifecycleHandler.removeResumeListener(this);
        this.ssoList.clear();
        if (null != items && items.size() > 0) {
            this.ssoList.addAll(items);
            SPAppLifecycleHandler.addResumeListener(this);
        }
    }

    @Override
    public void onActivityResume(Activity activity) {
        for (SPSSOItem sso : this.ssoList) {
            if (!activity.getClass().getName().equals(sso.activityClsName)) continue;
            this.performSSOClick(activity, sso);
            break;
        }
    }

    private boolean performSSOClick(Activity activity, SPSSOItem sso) {
        View rootView = activity.findViewById(0x1020002);
        for (String name : sso.inputs.keySet()) {
            View view = SPResourseKit.findViewByName(rootView, name);
            if (null != view) {
                if (view instanceof TextView) {
                    ((TextView)view).setText((CharSequence)sso.inputs.get(name));
                    continue;
                }
                if (!(view instanceof Spinner)) continue;
                continue;
            }
            return false;
        }
        View btn = SPResourseKit.findViewByName(rootView, sso.button);
        return null != btn && btn.performClick();
    }
}

