/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.gesture;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.secure.PLog;
import com.secure.comm.utils.SPViewUtil;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ClickableViewAccessibility"})
public class SPGestureWidget {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_CHECK = 1;
    public static final int STATE_WRONG = 2;
    public static final int STATE_CORRECT = 3;
    private static int COLOR_EMPTY = -2134061876;
    private static int COLOR_PRESS = -15362076;
    private static int COLOR_WRONG = -636599;
    private static int COLOR_RIGHT = -11681212;
    private static int COLOR_LINE = -2138387471;
    private Context mContext;
    private GPView mView;
    private float nodeWidth;
    private float nodeCenterWidth;
    private RectF rect;
    private Bitmap surface;
    private Canvas canvas;
    private Paint paintLine;
    private Bitmap[] nodeImages;
    private GPNode[] matrix;
    private SparseArray<GPNode> acrossNodes;
    private List<GPNode> checkedNodes;
    private PointF touchPoint;
    private boolean touchEnabled;
    private GPCallback callback;

    public SPGestureWidget(Context context, GPCallback callback) {
        this.mContext = context;
        this.callback = callback;
        this.mView = new GPView(context);
        this.touchEnabled = true;
        this.touchPoint = new PointF();
        this.paintLine = new Paint(4);
        this.paintLine.setStyle(Paint.Style.STROKE);
        this.paintLine.setStrokeWidth(20.0f);
        this.paintLine.setAntiAlias(true);
        this.paintLine.setStrokeJoin(Paint.Join.ROUND);
        this.paintLine.setStrokeCap(Paint.Cap.ROUND);
        this.paintLine.setPathEffect((PathEffect)new CornerPathEffect(10.0f));
        this.setLineColor(COLOR_LINE);
        this.rect = new RectF();
        this.nodeImages = new Bitmap[4];
        this.matrix = new GPNode[9];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = new GPNode();
            this.matrix[i].code = i + 1;
        }
        this.acrossNodes = new SparseArray();
        this.acrossNodes.put(13, (Object)this.matrix[1]);
        this.acrossNodes.put(17, (Object)this.matrix[3]);
        this.acrossNodes.put(39, (Object)this.matrix[5]);
        this.acrossNodes.put(79, (Object)this.matrix[7]);
        this.acrossNodes.put(19, (Object)this.matrix[4]);
        this.acrossNodes.put(37, (Object)this.matrix[4]);
        this.acrossNodes.put(28, (Object)this.matrix[4]);
        this.acrossNodes.put(46, (Object)this.matrix[4]);
        this.checkedNodes = new ArrayList<GPNode>();
    }

    public void setParentViewGroup(ViewGroup viewgroup) {
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1, 17);
        viewgroup.addView((View)this.mView, -1, (ViewGroup.LayoutParams)lp);
        this.mView.setFocusable(true);
        this.mView.setFocusableInTouchMode(true);
    }

    public void clearWithState(int state, long delayMillis, final Runnable action) {
        if (state == 0 || delayMillis < 1L) {
            this.clear();
            if (null != action) {
                this.mView.post(action);
            }
        } else {
            if (state == 2 || state == 3) {
                this.touchEnabled = false;
                for (GPNode node : this.checkedNodes) {
                    node.state = state;
                }
                this.setLineColor(state == 2 ? COLOR_WRONG : COLOR_RIGHT);
            }
            this.mView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SPGestureWidget.this.clearWithState(0, 0L, action);
                }
            }, delayMillis);
        }
        this.draw();
        this.mView.postInvalidate();
    }

    private String checkedCodes() {
        StringBuilder sb = new StringBuilder();
        for (GPNode node : this.checkedNodes) {
            sb.append(node.code);
        }
        return sb.toString();
    }

    private void sizeChanged(float width, float height) {
        if (null == this.surface || width != (float)this.surface.getWidth() || height != (float)this.surface.getHeight()) {
            int i;
            if (null != this.surface) {
                this.surface.recycle();
            }
            this.surface = Bitmap.createBitmap((int)((int)width), (int)((int)height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas = new Canvas();
            this.canvas.setBitmap(this.surface);
            float margin = 0.0f;
            if (SPViewUtil.isLandscape(this.mContext)) {
                margin = SPViewUtil.dp2px(this.mContext, 12.0f);
            } else {
                DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                float wdp = (float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) / displayMetrics.density;
                margin = SPViewUtil.dp2px(this.mContext, wdp > 360.0f ? 36.0f : 24.0f);
            }
            float maxw = (int)SPViewUtil.dp2px(this.mContext, 480.0f);
            float w = Math.min(width - margin - margin, height - margin - margin);
            w = Math.min(w, maxw);
            this.nodeWidth = w / 4.0f;
            this.nodeCenterWidth = this.nodeWidth / 5.0f;
            this.paintLine.setStrokeWidth(this.nodeCenterWidth - 2.0f);
            this.paintLine.setPathEffect((PathEffect)new CornerPathEffect(this.nodeCenterWidth / 2.0f - 1.0f));
            this.rect.set((width - w) / 2.0f, (height - w) / 2.0f, (width - w) / 2.0f + w, (height - w) / 2.0f + w);
            float[] xy = new float[]{0.0f, (w - this.nodeWidth) / 2.0f, w - this.nodeWidth};
            for (i = 0; i < this.matrix.length; ++i) {
                this.matrix[i].setFrame(this.rect.left + xy[i % 3], this.rect.top + xy[i / 3], this.nodeWidth);
            }
            for (i = 0; i < this.nodeImages.length; ++i) {
                if (null == this.nodeImages[i]) continue;
                this.nodeImages[i].recycle();
            }
            float cx = 0.5f * this.nodeWidth;
            float cr = 0.5f * this.nodeCenterWidth + 4.0f;
            this.nodeImages[0] = this.makeNodeImage(COLOR_EMPTY, cx, cr);
            this.nodeImages[1] = this.makeNodeImage(COLOR_PRESS, cx, cr);
            this.nodeImages[2] = this.makeNodeImage(COLOR_WRONG, cx, cr);
            this.nodeImages[3] = this.makeNodeImage(COLOR_RIGHT, cx, cr);
            this.draw();
        }
    }

    private boolean processTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.clear();
                if (!this.rect.contains(x, y)) break;
                this.touchingAt(x, y);
                break;
            }
            case 2: {
                this.touchingAt(x, y);
                break;
            }
            case 1: {
                this.touchPoint.set(0.0f, 0.0f);
                this.draw();
                this.mView.postInvalidate();
                if (null == this.callback) break;
                this.callback.OnGestureCode(this.checkedCodes(), this);
                break;
            }
        }
        return true;
    }

    private void touchingAt(float x, float y) {
        for (int i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[i].rect.contains(x, y)) continue;
            this.checkNode(this.matrix[i]);
            break;
        }
        this.touchPoint.set(x - this.rect.left, y - this.rect.top);
        this.draw();
        this.mView.postInvalidate();
    }

    private void checkNode(GPNode node) {
        if (!this.checkedNodes.contains(node)) {
            if (!this.checkedNodes.isEmpty()) {
                GPNode lastNode = this.checkedNodes.get(this.checkedNodes.size() - 1);
                GPNode xnode = (GPNode)this.acrossNodes.get(Math.min(node.code, lastNode.code) * 10 + Math.max(node.code, lastNode.code));
                if (null != xnode && !this.checkedNodes.contains(xnode)) {
                    xnode.state = 1;
                    this.checkedNodes.add(xnode);
                }
            }
            node.state = 1;
            this.checkedNodes.add(node);
        }
    }

    private void setLineColor(int color2) {
        this.paintLine.setColor(Integer.MIN_VALUE | color2 & 0xFFFFFF);
    }

    private void draw() {
        this.canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (GPNode node : this.matrix) {
            this.canvas.drawBitmap(this.nodeImages[node.state], node.x, node.y, null);
        }
        if (!this.checkedNodes.isEmpty()) {
            Path path = new Path();
            for (GPNode node : this.checkedNodes) {
                path.addCircle(node.cx, node.cy, 0.5f * this.nodeCenterWidth, Path.Direction.CW);
            }
            path.addCircle(this.checkedNodes.get((int)0).cx, this.checkedNodes.get((int)0).cy, 0.8f * this.nodeCenterWidth, Path.Direction.CW);
            path.moveTo(this.checkedNodes.get((int)0).cx, this.checkedNodes.get((int)0).cy);
            for (int i = 1; i < this.checkedNodes.size(); ++i) {
                path.lineTo(this.checkedNodes.get((int)i).cx, this.checkedNodes.get((int)i).cy);
            }
            if (null != this.touchPoint && this.touchPoint.x > 0.0f) {
                path.lineTo(this.rect.left + this.touchPoint.x, this.rect.top + this.touchPoint.y);
            }
            this.canvas.drawPath(path, this.paintLine);
        }
    }

    private Bitmap makeNodeImage(int color2, float cx, float cr) {
        Bitmap bmp = Bitmap.createBitmap((int)((int)this.nodeWidth), (int)((int)this.nodeWidth), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas();
        c.setBitmap(bmp);
        Paint p = new Paint(4);
        p.setAntiAlias(true);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth(6.0f);
        p.setColor(color2);
        c.drawCircle(cx, cx, cx - 3.0f, p);
        p.setStyle(Paint.Style.FILL);
        c.drawCircle(cx, cx, cr, p);
        return bmp;
    }

    private boolean paint(Canvas viewCanvas) {
        if (null != this.surface) {
            viewCanvas.drawBitmap(this.surface, 0.0f, 0.0f, null);
            return true;
        }
        return false;
    }

    private void clear() {
        this.touchEnabled = true;
        this.setLineColor(COLOR_LINE);
        this.checkedNodes.clear();
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].state = 0;
        }
    }

    private class GPNode {
        public int code = 0;
        public int state = 0;
        public float x = 0.0f;
        public float y = 0.0f;
        public float cx = 0.0f;
        public float cy = 0.0f;
        public RectF rect = new RectF();

        private GPNode() {
        }

        public void setFrame(float x, float y, float nodeWidth) {
            this.x = x;
            this.y = y;
            this.cx = x + nodeWidth / 2.0f;
            this.cy = y + nodeWidth / 2.0f;
            this.rect.set(x, y, x + nodeWidth, y + nodeWidth);
        }
    }

    private class GPView
    extends View {
        public GPView(Context context) {
            super(context);
        }

        public boolean onTouchEvent(MotionEvent event) {
            return SPGestureWidget.this.touchEnabled ? SPGestureWidget.this.processTouchEvent(event) : super.onTouchEvent(event);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            SPGestureWidget.this.paint(canvas);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            PLog.v("onSizeChanged %d,%d <- %d,%d", w, h, oldw, oldh);
            SPGestureWidget.this.sizeChanged(w, h);
            super.onSizeChanged(w, h, oldw, oldh);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int w = Math.min(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
            this.setMeasuredDimension(w, w);
        }
    }

    public static interface GPCallback {
        public void OnGestureCode(String var1, SPGestureWidget var2);
    }
}

