/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.gesture;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import com.secure.PLog;
import com.secure.comm.app.SPAppLifecycleHandler;
import com.secure.comm.app.SPOEM;
import com.secure.comm.app.SPResourseKit;
import com.secure.comm.utils.SPFingerprintCallback;
import com.secure.comm.utils.SPFingerprintUtil;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopup;
import com.secure.sportal.sdk.gesture.SPGestureData;
import com.secure.sportal.sdk.gesture.SPGestureWidget;
import com.secure.sportal.secid.uniq.SPUniqueIDProtection;

public class SPGestureHolder
implements SPGestureWidget.GPCallback,
SPFingerprintCallback,
View.OnClickListener {
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_SUCC = 1;
    public static final int RESULT_FAIL = 2;
    public static final int RESULT_SWITCH = 3;
    private static final int STEP_INPUT_VERIFY = 0;
    private static final int STEP_INPUT_OLD = 1;
    private static final int STEP_INPUT_NEW_FIRST = 2;
    private static final int STEP_INPUT_NEW_SECOND = 3;
    private View mRootView;
    private View mGPLayer;
    private ImageView mBackView;
    private TextView mBackExView;
    private TextView mHintText;
    private View mFPIcon;
    private View mFPConfigBtn;
    private View mFaceSwitchBtn;
    private Toast mToast;
    private SPGestureWidget mGPWidget;
    private String mFirstPassw;
    private int mStep;
    private boolean mIsVerify;
    private boolean mCancelable;
    private long mReqID;
    private OnSPGestureCallback mListener;
    private Activity mActivity;
    private int mOrientation = -2;
    private PopupWindow mPopup = null;
    private AlertDialog mDialog = null;
    private int mFailTimes;
    private static SPGestureHolder _popupInstance = null;

    public static SPGestureHolder getInstance() {
        if (_popupInstance == null) {
            _popupInstance = new SPGestureHolder();
        }
        return _popupInstance;
    }

    public static SPGestureHolder build(Context context, boolean verify, OnSPGestureCallback listener) {
        SPGestureHolder holder = SPGestureHolder.getInstance();
        holder.init(context, verify, false, 0L, listener);
        return holder;
    }

    public static SPGestureHolder build(Context context, boolean verify, boolean cancelable, long reqID, OnSPGestureCallback listener) {
        SPGestureHolder holder = SPGestureHolder.getInstance();
        holder.init(context, verify, cancelable, reqID, listener);
        return holder;
    }

    public static void clearPopup() {
        if (null != _popupInstance) {
            _popupInstance.dismissPopup();
        }
    }

    public static boolean isPopuping() {
        if (null != _popupInstance && null != SPGestureHolder._popupInstance.mDialog) {
            return SPGestureHolder._popupInstance.mDialog.isShowing();
        }
        return false;
    }

    public static void replacePopup(Activity activity, boolean force, OnSPGestureCallback listener) {
        if (null != _popupInstance || force) {
            SPGestureHolder.build((Context)activity, true, listener).popup(activity);
        }
    }

    private static boolean fpIsAvailable(Context context) {
        try {
            return SPFingerprintUtil.isAvailable(context);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean fpIsHardwareDetected(Context context) {
        try {
            return SPFingerprintUtil.isHardwareDetected(context);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void fpAuthenticate(Context context, SPFingerprintCallback callback) {
        try {
            SPFingerprintUtil.authenticate(context, callback);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fpRequestPermission(Activity activity) {
        try {
            SPFingerprintUtil.requestPermission(activity);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fpCancel() {
        try {
            SPFingerprintUtil.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init(Context context1, boolean verify, boolean cancelable, long reqID, OnSPGestureCallback listener) {
        Activity context = SPAppLifecycleHandler.topActivity;
        if (context == null) {
            context = context1;
        }
        this.mListener = listener;
        this.mIsVerify = verify;
        this.mStep = SPGestureData.hasPassword((Context)context) ? (this.mIsVerify ? 0 : 1) : 2;
        this.mFirstPassw = "";
        this.mFailTimes = 65535;
        this.mReqID = reqID;
        this.mCancelable = cancelable;
        this.mRootView = SPResourseKit.inflateByName((Context)context, "sportal_gesture");
        this.mGPLayer = SPResourseKit.findViewByName(this.mRootView, "sportal_guesture_gplayer");
        this.mFPIcon = SPResourseKit.findViewByName(this.mGPLayer, "sportal_fp_icon");
        this.mFPConfigBtn = SPResourseKit.findViewByName(this.mGPLayer, "sportal_fp_config");
        this.mFaceSwitchBtn = SPResourseKit.findViewByName(this.mGPLayer, "face_auth");
        View titlebar = SPResourseKit.findViewByName(this.mGPLayer, "sportal_guesture_title_bar");
        TextView titleText = (TextView)SPResourseKit.findViewByNameEx(titlebar, "sportal_guesture_title_text");
        this.mBackView = (ImageView)SPResourseKit.findViewByNameEx(titlebar, "sportal_guesture_btn_back");
        this.mBackExView = (TextView)SPResourseKit.findViewByNameEx(this.mRootView, "sportal_guesture_btn_backex");
        this.mBackView.setOnClickListener((View.OnClickListener)this);
        this.mBackExView.setOnClickListener((View.OnClickListener)this);
        this.mFaceSwitchBtn.setVisibility(8);
        this.mFaceSwitchBtn.setOnClickListener((View.OnClickListener)this);
        if (!this.mIsVerify) {
            titlebar.setVisibility(0);
            titleText.setText((CharSequence)"\u8bbe\u7f6e\u624b\u52bf");
            this.mBackView.setEnabled(true);
            this.mFPIcon.setVisibility(8);
            this.mFPConfigBtn.setVisibility(8);
            View box = SPResourseKit.findViewByName(this.mGPLayer, "sportal_guesture_box");
            if (SPViewUtil.isLandscape((Context)context)) {
                box.setPadding(4, 4, 4, 4);
            } else {
                Point ssize = SPViewUtil.screenSize((Context)context);
                int padding = (ssize.y - ssize.x - SPViewUtil.getStatusBarHeight((Context)context) - (int)SPViewUtil.dp2px((Context)context, 96.0f)) / 2;
                box.setPadding(0, padding, 0, padding);
            }
        } else {
            if (cancelable) {
                titlebar.setVisibility(0);
                titleText.setText((CharSequence)"");
                titlebar.setBackgroundDrawable(null);
                this.mBackView.setEnabled(true);
                this.mBackView.setImageDrawable(SPResourseKit.getDrawable((Context)context, "sportal_ic_gesture_close"));
                this.mBackExView.setVisibility(0);
                this.mBackExView.setEnabled(true);
            } else {
                this.mBackView.setEnabled(false);
                titlebar.setVisibility(8);
                this.mBackExView.setVisibility(8);
                this.mBackExView.setEnabled(false);
            }
            if (!SPGestureData.hasFaceAuth((Context)context)) {
                this.mFaceSwitchBtn.setVisibility(8);
            } else {
                this.mFaceSwitchBtn.setVisibility(0);
            }
            if (!SPGestureData.hasPassword((Context)context)) {
                this.mFPIcon.setVisibility(8);
                this.mFPConfigBtn.setVisibility(8);
            } else if (SPGestureHolder.fpIsAvailable((Context)context)) {
                this.mFPIcon.setVisibility(0);
                this.mFPConfigBtn.setVisibility(8);
            } else {
                this.mFPIcon.setVisibility(8);
                if (SPGestureHolder.fpIsHardwareDetected((Context)context)) {
                    this.mFPConfigBtn.setVisibility(0);
                    this.mFPConfigBtn.setOnClickListener((View.OnClickListener)this);
                } else {
                    this.mFPConfigBtn.setVisibility(8);
                }
            }
            if (SPOEM.isOEM_ProcGuangxi()) {
                if (this.mStep == 0) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mBackExView.getLayoutParams();
                    lp.gravity = 81;
                    lp.setMargins(0, 0, 0, (int)SPViewUtil.dp2px((Context)context, 48.0f));
                    lp.width = -1;
                    lp.height = -2;
                    this.mBackExView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    this.mBackExView.setOnClickListener(null);
                    this.mBackExView.setVisibility(0);
                    this.mBackExView.setTextColor(-16777216);
                    this.mBackExView.setText((CharSequence)"\u5fd8\u8bb0\u5bc6\u7801\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u7f6e\uff08\u5185\u7ebf6014\uff09");
                } else {
                    this.mBackExView.setVisibility(8);
                }
            }
        }
        this.mToast = null;
        this.mGPWidget = new SPGestureWidget((Context)context, this);
        ViewGroup container = (ViewGroup)SPResourseKit.findViewByName(this.mGPLayer, "sportal_guesture_container");
        this.mGPWidget.setParentViewGroup(container);
        this.mHintText = (TextView)SPResourseKit.findViewByName(this.mGPLayer, "sportal_guesture_hint");
        this.updateHintText();
    }

    public View rootView() {
        return this.mRootView;
    }

    @SuppressLint(value={"InlinedApi"})
    public void popup(Activity activity) {
        if (this.mIsVerify) {
            SPGestureHolder.clearPopup();
            Log.e((String)"TAG", (String)SPAppLifecycleHandler.topActivity.getLocalClassName());
            this.mActivity = SPAppLifecycleHandler.topActivity;
            if (this.mActivity == null) {
                this.mActivity = activity;
            }
            PLog.v("topActivity is %s", SPAppLifecycleHandler.topActivity.getLocalClassName());
            this.mOrientation = this.mActivity.getRequestedOrientation();
            if (Build.VERSION.SDK_INT < 18) {
                int o = SPViewUtil.isLandscape((Context)this.mActivity) ? 0 : 1;
                this.mActivity.setRequestedOrientation(o);
            } else {
                this.mActivity.setRequestedOrientation(14);
            }
            Window window = this.mActivity.getWindow();
            int padding = 0;
            final Point ssize = SPViewUtil.screenSize((Context)this.mActivity);
            final Rect statusRect = new Rect(0, 0, 0, 0);
            if ((window.getAttributes().flags & 0x400) == 0) {
                window.getDecorView().getWindowVisibleDisplayFrame(statusRect);
            }
            ssize.y -= statusRect.top;
            if (ssize.y > ssize.x) {
                padding = 48;
                if (this.mFPConfigBtn.getVisibility() != 8) {
                    padding += 40;
                }
                padding = (ssize.y - ssize.x - (int)SPViewUtil.dp2px((Context)this.mActivity, padding)) / 2;
                padding = Math.max(padding, (int)SPViewUtil.dp2px((Context)this.mActivity, 24.0f));
            } else {
                padding = (int)SPViewUtil.dp2px((Context)this.mActivity, 12.0f);
            }
            View titlebar = SPResourseKit.findViewByName(this.mGPLayer, "sportal_guesture_title_bar");
            if (this.mIsVerify && null != titlebar && titlebar.getVisibility() == 0) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)titlebar.getLayoutParams();
                lp.bottomMargin = Math.max(0, padding - lp.height);
                titlebar.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.mGPLayer.setPadding(0, 0, 0, padding);
            } else {
                this.mGPLayer.setPadding(0, padding, 0, padding);
            }
            try {
                SPGestureHolder.fpRequestPermission(this.mActivity);
                if (SPGestureData.hasPassword((Context)this.mActivity) && SPGestureHolder.fpIsAvailable((Context)this.mActivity)) {
                    SPGestureHolder.fpAuthenticate((Context)this.mActivity, this);
                }
                if (Build.VERSION.SDK_INT < 23) {
                    final View token = window.getDecorView();
                    token.post(new Runnable(){

                        @Override
                        public void run() {
                            SPGestureHolder.this.mPopup = new PopupWindow(SPGestureHolder.this.mRootView, ssize.x, ssize.y, true);
                            try {
                                SPGestureHolder.this.mPopup.showAtLocation(token, 0x800033, 0, statusRect.top);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mGPLayer.getContext(), SPPopup.themeFS());
                    builder.setView(this.mRootView);
                    builder.setCancelable(false);
                    this.mDialog = builder.create();
                    this.mDialog.requestWindowFeature(1);
                    this.mDialog.setCanceledOnTouchOutside(false);
                    WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                    lp.copyFrom(this.mDialog.getWindow().getAttributes());
                    lp.gravity = 17;
                    lp.width = ssize.x;
                    lp.height = ssize.y;
                    this.mDialog.show();
                    this.mDialog.getWindow().setAttributes(lp);
                    this.mDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onClick(View v) {
        if (v == this.mBackView || v == this.mBackExView) {
            this.dismissPopup();
            try {
                this.mListener.OnGestureClose(v == this.mBackView ? 0 : 3);
            }
            catch (Exception exception) {}
        } else if (v == this.mFaceSwitchBtn) {
            Intent intent = new Intent("action.start.face.auth");
            intent.putExtra("is_register", false);
            intent.putExtra("face_id", SPGestureData.getFaceId(v.getContext(), false));
            Context context = v.getContext();
            context.startActivity(intent);
            v.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SPGestureHolder.this.dismissPopup();
                    SPGestureHolder.this.mListener.OnGestureClose(0);
                }
            }, 500L);
        } else if (v == this.mFPConfigBtn) {
            try {
                v.getContext().startActivity(new Intent("android.settings.fingerprint_settings"));
            }
            catch (Exception ex) {
                try {
                    v.getContext().startActivity(new Intent("android.settings.SETTINGS"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void updateHintText() {
        if (this.mStep == 3) {
            this.mHintText.setText((CharSequence)"\u518d\u6b21\u8bbe\u7f6e\u65b0\u624b\u52bf");
        } else if (this.mStep == 2) {
            this.mHintText.setText((CharSequence)"\u8bbe\u7f6e\u65b0\u624b\u52bf");
        } else if (this.mIsVerify) {
            if (SPGestureHolder.fpIsAvailable(this.mHintText.getContext()) && this.mFPIcon.getVisibility() == 0) {
                this.mHintText.setText((CharSequence)"\u624b\u52bf\u6216\u6307\u7eb9\u89e3\u9501");
            } else {
                this.mHintText.setText((CharSequence)"\u624b\u52bf\u89e3\u9501");
            }
        } else {
            this.mHintText.setText((CharSequence)"\u8f93\u5165\u65e7\u624b\u52bf");
        }
    }

    @Override
    public void OnGestureCode(String codes, SPGestureWidget widget) {
        if (this.mStep == 3) {
            if (codes.equals(this.mFirstPassw)) {
                widget.clearWithState(3, 200L, new Runnable(){

                    @Override
                    public void run() {
                        SPGestureData.setPassword(SPGestureHolder.this.mRootView.getContext(), SPGestureHolder.this.mFirstPassw);
                        SPGestureHolder.this.toastMsg("\u8bbe\u7f6e\u624b\u52bf\u6210\u529f");
                        if (!SPGestureHolder.this.onVerified(true)) {
                            if (null != SPGestureHolder.this.mListener) {
                                try {
                                    SPGestureHolder.this.mListener.OnGestureClose(1);
                                }
                                catch (Exception exception) {}
                            } else if (SPGestureHolder.this.mRootView.getContext() instanceof Activity) {
                                ((Activity)SPGestureHolder.this.mRootView.getContext()).onBackPressed();
                            }
                        }
                    }
                });
            } else {
                this.mStep = 2;
                this.toastMsg("\u4e24\u6b21\u624b\u52bf\u4e0d\u5339\u914d");
                widget.clearWithState(2, 500L, null);
            }
        } else if (this.mStep == 2) {
            if (codes.length() > 3) {
                this.mFirstPassw = codes;
                this.mStep = 3;
                widget.clearWithState(3, 200L, null);
            } else {
                this.toastMsg("\u624b\u52bf\u81f3\u5c11\u9700\u89814\u4e2a\u70b9");
                widget.clearWithState(2, 500L, null);
            }
        } else if (SPGestureData.validatePassword(this.mRootView.getContext(), codes)) {
            if (!this.mIsVerify) {
                this.mStep = 2;
            }
            widget.clearWithState(3, 200L, new Runnable(){

                @Override
                public void run() {
                    SPGestureHolder.this.onVerified(true);
                }
            });
        } else {
            if (this.mIsVerify && this.mCancelable && SPUniqueIDProtection.onProtectResult(this.mReqID, 1, 3)) {
                this.onClick((View)this.mBackView);
                return;
            }
            this.toastMsg("\u624b\u52bf\u9a8c\u8bc1\u5931\u8d25");
            widget.clearWithState(2, 500L, new Runnable(){

                @Override
                public void run() {
                    SPGestureHolder.this.onVerified(false);
                }
            });
        }
        this.updateHintText();
    }

    @Override
    public void onFPAuthFailed(CharSequence errmsg) {
        if (this.mIsVerify) {
            if (TextUtils.isEmpty((CharSequence)errmsg)) {
                this.toastMsg("\u6307\u7eb9\u9a8c\u8bc1\u5931\u8d25");
            } else {
                this.toastMsg(errmsg.toString());
            }
        }
    }

    @Override
    public void onFPAuthSucceeded() {
        if (this.mIsVerify && SPGestureData.hasPassword(this.mRootView.getContext())) {
            try {
                SPGestureHolder.fpCancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.onVerified(true);
        }
    }

    @Override
    public void onFPAuthBlocked(int errId, CharSequence errMsg) {
        if (this.mIsVerify) {
            this.toastMsg("\u6307\u7eb9\u5df2\u88ab\u7cfb\u7edf\u9501\u5b9a,\u8bf7\u4f7f\u7528\u624b\u52bf\u89e3\u9501.");
            this.mFPIcon.setVisibility(8);
            this.mHintText.setText((CharSequence)"\u624b\u52bf\u89e3\u9501");
            SPGestureHolder.fpCancel();
        }
    }

    private boolean onVerified(boolean success) {
        if (this.mIsVerify) {
            if (success) {
                SPGestureData.setLastTime(0L);
                this.dismissPopup();
                if (null != this.mListener) {
                    this.toastMsg("");
                    try {
                        this.mListener.OnGestureClose(1);
                    }
                    catch (Exception exception) {}
                }
            } else if (--this.mFailTimes < 1) {
                this.dismissPopup();
                try {
                    this.mListener.OnGestureClose(2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.mIsVerify;
    }

    private void dismissPopup() {
        SPGestureHolder.fpCancel();
        if (null != this.mPopup) {
            try {
                this.mPopup.dismiss();
            }
            catch (Exception ex) {
                PLog.v(ex);
            }
        } else if (null != this.mDialog) {
            try {
                this.mDialog.dismiss();
            }
            catch (Exception ex) {
                PLog.v(ex);
            }
        }
        if (null != this.mActivity && this.mOrientation != -2) {
            this.mActivity.setRequestedOrientation(this.mOrientation);
        }
        this.mActivity = null;
        this.mOrientation = -2;
    }

    private void toastMsg(String msg) {
        if (null == this.mToast) {
            this.mToast = Toast.makeText((Context)this.mRootView.getContext(), (CharSequence)"", (int)0);
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            this.mToast.cancel();
        } else {
            this.mToast.setText((CharSequence)msg);
            this.mToast.setDuration(0);
            this.mToast.show();
        }
    }

    public static void openFingerPrint(Activity mActivity) {
        if (_popupInstance != null && SPGestureData.hasPassword((Context)mActivity) && SPGestureHolder.fpIsAvailable((Context)mActivity)) {
            SPGestureHolder.fpAuthenticate((Context)mActivity, _popupInstance);
        }
    }

    public static interface OnSPGestureCallback {
        public void OnGestureClose(int var1);
    }
}

