/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.gesture;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.secure.comm.utils.SPStringUtil;

public class SPGestureData {
    private static final String DATA_NAME = "sportal_gesture";
    private static final String KEY_PASSW = "password";
    private static final String KEY_FACE_AUTH = "face_auth_on";
    public static final String KEY_FACE_ID = "face_id";
    public static final String ARG_PAGE = "arg_page";
    public static final String ARG_METHOD = "method";
    public static final String ARG_FACE_ID = "face_id";
    public static final String ARG_IS_REGISTER = "is_register";
    public static final int DATA_GUIDE = 0;
    public static final int DATA_COMPARE = 1;
    public static final int DATA_REGISTER = 2;
    public static volatile String face_id = "";
    private static long lasttime = 0L;

    public static void cleanSp(Context context) {
        context.getSharedPreferences(DATA_NAME, 0).edit().clear().apply();
    }

    public static boolean hasPassword(Context context) {
        SharedPreferences sp = context.getSharedPreferences(DATA_NAME, 0);
        return SPStringUtil.opt(sp.getString(KEY_PASSW, "")).length() > 0;
    }

    public static boolean hasFaceAuth(Context context) {
        SharedPreferences sp = context.getSharedPreferences(DATA_NAME, 0);
        return sp.getBoolean(KEY_FACE_AUTH, false);
    }

    public static void setFaceAuth(Context context, boolean isFaceAuth) {
        SharedPreferences sp = context.getSharedPreferences(DATA_NAME, 0);
        sp.edit().putBoolean(KEY_FACE_AUTH, isFaceAuth).apply();
    }

    public static String getFaceId(Context context, boolean clear) {
        String face_id = "";
        if (!clear) {
            face_id = SPGestureData.face_id;
            if (TextUtils.isEmpty((CharSequence)face_id) && TextUtils.isEmpty((CharSequence)(face_id = context.getSharedPreferences(DATA_NAME, 0).getString("face_id", "")))) {
                face_id = "face_id@" + System.currentTimeMillis();
                context.getSharedPreferences(DATA_NAME, 0).edit().putString("face_id", face_id).apply();
            }
        } else {
            face_id = "face_id@" + System.currentTimeMillis();
            context.getSharedPreferences(DATA_NAME, 0).edit().putString("face_id", face_id).apply();
        }
        SPGestureData.face_id = face_id;
        return face_id;
    }

    public static boolean validatePassword(Context context, String passw) {
        String passDatabase = "";
        String pass2Md5 = "";
        String passSha256Md5 = "";
        if (!TextUtils.isEmpty((CharSequence)passw)) {
            SharedPreferences sp = context.getSharedPreferences(DATA_NAME, 0);
            passDatabase = sp.getString(KEY_PASSW, "");
            if (passDatabase.equals(passSha256Md5 = SPStringUtil.gestureEncrypt(passw))) {
                return true;
            }
            pass2Md5 = SPStringUtil.md5(SPStringUtil.md5(passw));
            if (passDatabase.equals(pass2Md5)) {
                return true;
            }
        }
        return false;
    }

    public static void setPassword(Context context, String passw) {
        SharedPreferences.Editor sp = context.getSharedPreferences(DATA_NAME, 0).edit();
        if (!TextUtils.isEmpty((CharSequence)(passw = SPStringUtil.opt(passw)))) {
            sp.putString(KEY_PASSW, SPStringUtil.gestureEncrypt(passw));
        } else {
            sp.remove(KEY_PASSW);
        }
        sp.apply();
    }

    public static void setLastTime(long time) {
        lasttime = time;
    }

    public static long getLastTime() {
        return lasttime;
    }
}

