/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.gesture;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.secure.comm.app.SPAppLifecycleHandler;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.sportal.sdk.app.SPGestureActivity;
import com.secure.sportal.sdk.gesture.SPGestureData;
import com.secure.sportal.sdk.gesture.SPGestureHolder;

public class SPGestureControl {
    public static final int POINT_STATE_NORMAL = 0;
    public static final int POINT_STATE_SELECTED = 1;
    public static final int POINT_STATE_WRONG = 2;
    private static int uid = 0;
    private static long expireMills = 0L;
    private static SPGestureHolder.OnSPGestureCallback callback = null;

    public static void configGesture(Context context) {
        block2: {
            try {
                Intent intent = new Intent(context, SPGestureActivity.class);
                context.startActivity(intent);
            }
            catch (Exception ex) {
                if (!(ex instanceof ActivityNotFoundException)) break block2;
                SPPopupMsgBox.popup(context, "\u9519\u8bef", "\u65e0\u6cd5\u663e\u793a\u624b\u52bf\u8bbe\u7f6e\u754c\u9762:\n\u8bf7\u5728 AndroidManifest.xml \u4e2d\u6ce8\u518c\n com.secure.sportal.sdk.app.SPGestureActivity");
            }
        }
    }

    public static void startVerify(Activity activity, int uid, int expires, boolean force, SPGestureHolder.OnSPGestureCallback l) {
        SPGestureControl.uid = uid;
        expireMills = Math.max(0L, 1000L * (long)expires);
        callback = l;
        if (expireMills > 0L) {
            SPAppLifecycleHandler.addActivateListener(GestureTrigger.instance());
            if (uid > 0 && force) {
                SPGestureData.setLastTime(System.currentTimeMillis() - expireMills);
                SPGestureHolder.build((Context)activity, true, l).popup(activity);
            } else if (null != l) {
                try {
                    l.OnGestureClose(1);
                }
                catch (Exception exception) {}
            }
        } else {
            SPGestureData.setLastTime(0L);
            SPAppLifecycleHandler.removeActivateListener(GestureTrigger.instance());
            SPGestureData.setPassword((Context)activity, null);
        }
    }

    public static void replaceVerify(Activity activity, final boolean force, final SPGestureHolder.OnSPGestureCallback l) {
        SPIntentUtil.runOnMainThread(new SPRunnable<Activity>(activity){

            @Override
            public void run() {
                boolean _force = force || uid > 0 && expireMills > 0L && SPGestureData.getLastTime() > 0L && System.currentTimeMillis() - SPGestureData.getLastTime() > expireMills;
                SPGestureHolder.replacePopup((Activity)this.mUserObject, _force, l);
            }
        }, 100L);
    }

    public static void closePopup() {
        SPIntentUtil.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                SPGestureHolder.clearPopup();
            }
        }, 0L);
    }

    public static boolean isPopuping() {
        return SPGestureHolder.isPopuping();
    }

    public static void stopVerify() {
        uid = 0;
        expireMills = 0L;
    }

    public static boolean isEnabled() {
        return uid > 0 && expireMills > 0L;
    }

    public static long getExpireMills() {
        return expireMills;
    }

    public static void clearData(Context context) {
        SPGestureData.setLastTime(0L);
        SPGestureData.setPassword(context, null);
    }

    private static void onAppActive(Activity activity, final SPGestureHolder.OnSPGestureCallback l) {
        Intent intent = activity.getIntent();
        if (null != intent && intent.getBooleanExtra("sp_gesture_disable", false)) {
            intent.putExtra("sp_gesture_disable", false);
            return;
        }
        if (uid > 0) {
            if (Build.MANUFACTURER.equalsIgnoreCase("vivo")) {
                SPGestureHolder.clearPopup();
            }
            if (SPGestureControl.isPopuping()) {
                SPIntentUtil.runOnMainThread(new SPRunnable<Activity>(activity){

                    @Override
                    public void run() {
                        SPGestureHolder.openFingerPrint((Activity)this.mUserObject);
                    }
                }, 200L);
            } else if (expireMills > 0L && SPGestureData.getLastTime() > 0L && System.currentTimeMillis() - SPGestureData.getLastTime() > expireMills) {
                SPIntentUtil.runOnMainThread(new SPRunnable<Activity>(activity){

                    @Override
                    public void run() {
                        SPGestureHolder.build((Context)this.mUserObject, true, l).popup((Activity)this.mUserObject);
                    }
                }, 1L);
            }
        }
    }

    private static void onAppDeactive(Context context) {
        if (SPGestureData.getLastTime() == 0L) {
            SPGestureData.setLastTime(uid > 0 && expireMills > 0L ? System.currentTimeMillis() : 0L);
        }
    }

    public static class GestureTrigger
    implements SPAppLifecycleHandler.OnAppActivateListener {
        private static GestureTrigger _instance;

        private static synchronized GestureTrigger instance() {
            return null == _instance ? (_instance = new GestureTrigger()) : _instance;
        }

        private GestureTrigger() {
        }

        @Override
        public void onAppEnterForeround(Activity activity) {
            SPGestureControl.onAppActive(activity, callback);
        }

        @Override
        public void onAppEnterBackground(Context context) {
            SPGestureHolder.fpCancel();
            SPGestureControl.onAppDeactive(context);
        }
    }
}

