/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.deprecated;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import android.webkit.WebView;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.net.SPInetAddress;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.utils.SPUriUtil;
import com.secure.comm.utils.SPWebViewUtil;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPortalConf;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.app.SPTunnelService;
import com.secure.sportal.sdk.deprecated.SPLoginTaskV1;
import com.secure.sportal.sdk.deprecated.SPLogoutTaskV1;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.PortalSession;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

public class SPSDKClientV1 {
    public static final int MSGID_LOGIN_SUCC = 0;
    public static final int MSGID_LOGIN_SECOND_SMS = 33;
    public static final int MSGID_LOGIN_SECOND_EMAIL = 34;
    public static final int MSGID_LOGIN_SECOND_TOKEN = 35;
    public static final int MSGID_LOGIN_FAIL = 256;
    protected static final int MSGID_RUNTIME_ERROR = 272;
    protected static final long HEARTBEAT_TIMEOUT = 10000L;
    public static final String ACTION_RUNTIME_ERROR = "com.secure.sdk.runtime_error";
    public static final String ACTION_SESSION_NOTIFY = "com.secure.sdk.session.notification";
    public static final String KEY_ERR_MSG = "KEY_error.message";
    public static final String KEY_ERR_CODE = "KEY_error.code";
    private static AtomicBoolean mLoginLock = new AtomicBoolean(false);
    private static AtomicLong mLoginSessionID = new AtomicLong(0L);
    private static OnSPortalListener sdkListener = null;
    private static Handler mainHandler = null;
    private static AtomicBoolean _ISSDK = new AtomicBoolean(false);

    public static void login2(Context context, Properties param, OnLoginCallback callback) {
    }

    public static void login(Context context, Properties param, OnSPortalListener listener) {
        SPSDKClientV1.login(context, SPortalConf.parse(param), listener, false);
    }

    public static void login(Context context, SPortalConf conf, OnSPortalListener l, boolean sync) {
        SPortalConf pconfig;
        if (mLoginLock.get()) {
            if (null != l) {
                l.onSPortalMessage(256, "[0F000009]\u53e6\u4e00\u4e2a\u767b\u5f55\u6d41\u7a0b\u6b63\u5728\u8fdb\u884c\u4e2d");
            }
            return;
        }
        mLoginLock.set(true);
        URL url = SPUriUtil.parseURL(conf.vpn_host);
        if (null != url) {
            if (!TextUtils.isEmpty((CharSequence)url.getHost())) {
                conf.vpn_host = url.getHost();
            }
            if (conf.vpn_port < 1 && url.getPort() > 0) {
                conf.vpn_port = url.getPort();
            }
        }
        mLoginSessionID.set(System.currentTimeMillis());
        _ISSDK.set(true);
        PLog.i("LOGIN", new Object[0]);
        try {
            PLog.v("pid:%d, name:%s", Process.myPid(), SPApplication.getPkgName(context));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SPApplication.setAppContext(context.getApplicationContext());
        SPLibBridge.initLibrary(context);
        PortalSession.instance(context);
        SPTunnelService.spStart(context);
        if (null == mainHandler) {
            mainHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    if (msg.what == 272) {
                        mainHandler.removeMessages(msg.what);
                        SPSDKClientV1.heartBeat();
                        mainHandler.sendEmptyMessageDelayed(272, 10000L);
                    }
                    return false;
                }
            });
        }
        mainHandler.removeCallbacksAndMessages(null);
        sdkListener = l;
        SPortalConf sPortalConf = pconfig = null != conf ? conf : SPortalConf.load(context);
        if (null == conf.extras) {
            pconfig.extras = new SPLiteBundle();
        }
        pconfig.extras.put("secm", "0");
        SPLoginTaskV1 task = new SPLoginTaskV1(context, null, pconfig.auth_emark, pconfig.auth_server, pconfig.auth_username, pconfig.auth_password, pconfig.sdcard_pin, pconfig.extras, null);
        LoginThread thread = new LoginThread(pconfig, sync, task);
        if (sync && !SPSystemUtil.isRunInMainThread()) {
            thread.run();
        } else {
            thread.start();
        }
    }

    public static void loginSecond(long sid, int type, String token) {
        if (sid != mLoginSessionID.get()) {
            // empty if block
        }
    }

    public static boolean isSDK() {
        return _ISSDK.get();
    }

    public static void logout() {
        if (null != mainHandler) {
            mainHandler.removeCallbacksAndMessages(null);
        }
        SPNCServiceManagement.stopNC(null);
        SPLogoutTaskV1.logout(null);
    }

    public static boolean isNetHooking() {
        return SPLibBridge.isNetHooking();
    }

    public static Proxy getHttpProxy() {
        InetSocketAddress sa = new InetSocketAddress("127.0.0.1", SPLibBridge.getProxyPort());
        return new Proxy(Proxy.Type.HTTP, sa);
    }

    public static int getProxyPort() {
        return SPLibBridge.getProxyPort();
    }

    public static void setSSLTimeout(int conn_timeout, int so_timeout) {
        String param = String.format(Locale.ENGLISH, "{\"vpn_timeout_connect\":\"%d\", \"vpn_timeout_io\":\"%d\"}", conn_timeout, so_timeout);
        SPLibBridge.exeCmd("sys_set_timeout", param, null);
    }

    public static void addBypassPackageName(String pkgName) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            PortalSession.bypassPkgNames.clear();
        } else {
            PortalSession.bypassPkgNames.add(pkgName);
        }
    }

    public static void addBypassAddress(String host, int fromPort, int toPort) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            PortalSession.bypassAddresses.clear();
        } else {
            try {
                SPInetAddress addr = new SPInetAddress();
                addr.ip = InetAddress.getByName(host).getHostAddress();
                addr.port1 = fromPort;
                addr.port2 = toPort < fromPort ? fromPort : toPort;
                PortalSession.bypassAddresses.add(addr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setWebViewProxy(WebView webview) {
        SPWebViewUtil.setProxy(webview, "127.0.0.1", SPSDKClientV1.getProxyPort());
    }

    public static List<SPServiceInfo> getServiceList() {
        ArrayList<SPServiceInfo> svcList = new ArrayList<SPServiceInfo>();
        svcList.addAll(PortalSession.instance((Context)SPApplication.appContext()).userdata().proxySvcList);
        svcList.addAll(PortalSession.instance((Context)SPApplication.appContext()).userdata().ncSvcList);
        return svcList;
    }

    public static Socket getServiceSocket(int svcid) throws IOException {
        for (SPServiceInfo svc : SPSDKClientV1.getServiceList()) {
            if (svc.id != svcid) continue;
            return SPSDKClientV1.sconnect(svc.hostname, svc.port);
        }
        throw new IOException("Service not fund");
    }

    public static Socket sconnect(String host, int port, int timeout, int sotimeout) throws IOException {
        String response;
        Socket conn = new Socket();
        conn.connect(SPSDKClientV1.getHttpProxy().address(), timeout);
        if (sotimeout > 0) {
            conn.setSoTimeout(sotimeout);
        }
        String request = "CONNECT " + host + ":" + port + " HTTP/1.1\r\n\r\n";
        conn.getOutputStream().write(request.getBytes());
        byte[] bytes = new byte[128];
        InputStream input = conn.getInputStream();
        int len = 0;
        while (len < 128) {
            bytes[len++] = (byte)input.read();
            if (len <= 4 || bytes[len - 4] != 13 || bytes[len - 3] != 10 || bytes[len - 2] != 13 || bytes[len - 1] != 10) continue;
        }
        if ((response = new String(bytes, 0, Math.min(len, bytes.length), "UTF-8")).startsWith("HTTP/1.1 200 ")) {
            return conn;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IOException("Connect failed");
    }

    public static Socket sconnect(String host, int port, int timeout) throws IOException {
        return SPSDKClientV1.sconnect(host, port, timeout, 0);
    }

    public static Socket sconnect(String host, int port) throws IOException {
        return SPSDKClientV1.sconnect(host, port, 6000);
    }

    public static int getServiceLoopbackPort(String host, int port) {
        return SPLibBridge.openProxyMapping(0, host, port);
    }

    public static boolean encryptFile(String srcFile, String dstFile, String password) {
        return SPLibBridge.encryptFile(true, srcFile, dstFile, password);
    }

    public static boolean decryptFile(String srcFile, String dstFile, String password) {
        return SPLibBridge.encryptFile(false, srcFile, dstFile, password);
    }

    public static boolean putSSLFingerprint(String host, int port, String fingerprint) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        return 0 == SPLibBridge.putSSLFingerprint(host, port, fingerprint);
    }

    public static void clearSSLFingerprint() {
        SPLibBridge.putSSLFingerprint(null, 0, "");
    }

    public static boolean checkSSLFingerprint(String host, int port, String servername, String fingerprint) {
        return SPLibBridge.checkSSLFingerprint(host, port, servername, fingerprint);
    }

    public static void updateAuthExtras(Properties extras) {
        if (null != extras) {
            JSONObject json = new JSONObject();
            Enumeration<?> e = extras.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                SPJSONUtil.put(json, name, extras.getProperty(name));
            }
            SPLibBridge.exeCmd("session_set_auth_extra", json.toString(), null);
        }
    }

    private static void heartBeat() {
        int errno = SPLibBridge.exeCmd("sys_get_error", "{}", null);
        int msgid = errno & 0xFFFF;
        if (1040 == msgid && null != SPApplication.appContext()) {
            Bundle extras = new Bundle();
            extras.putInt(KEY_ERR_CODE, msgid);
            extras.putString(KEY_ERR_MSG, GatewayErrorText.getErrMsg(errno & Integer.MAX_VALUE));
            SPIntentUtil.sendLocalBroadcast(SPApplication.appContext(), ACTION_RUNTIME_ERROR, extras);
        }
    }

    private static class MsgTask
    implements Runnable {
        private int msgid;
        private String msgtext;

        public MsgTask(int msgid, String msgtext) {
            this.msgid = msgid;
            this.msgtext = msgtext;
        }

        @Override
        public void run() {
            if (null != sdkListener) {
                sdkListener.onSPortalMessage(this.msgid, this.msgtext);
            }
        }
    }

    private static class LoginThread
    extends Thread {
        private SPortalConf conf;
        private boolean sync;
        private SPLoginTaskV1 task;

        public LoginThread(SPortalConf conf, boolean sync, SPLoginTaskV1 task) {
            this.conf = conf;
            this.sync = sync;
            this.task = task;
        }

        @Override
        public void run() {
            PortalSession.setVpnAddress(this.conf.vpn_host, this.conf.vpn_port, this.conf.vpn_sni, true);
            String result = this.task.login();
            if (TextUtils.isEmpty((CharSequence)result)) {
                this.fireMsg(0, "");
                if (null != mainHandler) {
                    mainHandler.sendEmptyMessageDelayed(272, 10000L);
                }
            } else {
                this.fireMsg(256, result);
            }
            mLoginLock.set(false);
        }

        private void fireMsg(int msgid, String msgtext) {
            PLog.i("LOGIN RSP[%d, %s]", msgid, msgtext);
            if (null != sdkListener) {
                if (!this.sync && null != mainHandler) {
                    mainHandler.post((Runnable)new MsgTask(msgid, msgtext));
                } else {
                    sdkListener.onSPortalMessage(msgid, msgtext);
                }
            }
        }
    }

    public abstract class OnLoginCallback
    implements OnSPortalListener {
        @Override
        public void onSPortalMessage(int msgid, String msg) {
            this.OnSDKClientLoginMessage(msgid, msg, "");
        }

        public abstract void OnSDKClientLoginMessage(int var1, String var2, String var3);
    }

    public static interface OnSPortalListener {
        public void onSPortalMessage(int var1, String var2);
    }
}

