/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.deprecated;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.entry.SPPortalInfo;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.entry.SPUserInfo;
import com.secure.sportal.entry.SPortalConf;
import com.secure.sportal.gateway.GatewayAgentAppstore;
import com.secure.sportal.gateway.GatewayAgentAuth;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.service.PortalSession;
import java.util.List;
import org.json.JSONObject;

public class SPLoginTaskV1
extends AsyncTask<String, String, String> {
    private Context mContext;
    private SPPortalInfo mPortalInfo;
    private String mEMark = "";
    private String mAuthSvrName = "";
    private String mUsername = "";
    private String mPassword = "";
    private String mSdcardPin = "";
    private SPLiteBundle mExtras = null;
    private SPAppInfo mAppInfo = null;
    private OnLoginListener mListener;

    public static String disallowedNetworkMsg(int netinfo) {
        StringBuilder sb = new StringBuilder("[0F000011]\u60a8\u6240\u4f7f\u7528\u7684\u7f51\u7edc\u300e");
        if ((netinfo & 1) > 0) {
            sb.append("WIFI");
        } else if ((netinfo & 2) > 0) {
            sb.append("\u4e2d\u56fd\u79fb\u52a8");
        } else if ((netinfo & 4) > 0) {
            sb.append("\u4e2d\u56fd\u7535\u4fe1");
        } else if ((netinfo & 8) > 0) {
            sb.append("\u4e2d\u56fd\u8054\u901a");
        } else {
            sb.append("\u672a\u77e5\u7f51\u7edc");
        }
        sb.append("\u300f\u4e0d\u88ab\u5141\u8bb8\u767b\u5f55\u3002");
        return sb.toString();
    }

    public SPLoginTaskV1(Context context, SPPortalInfo portal, String emark, String authsvr, String username, String password, String sdcardPin, SPLiteBundle extras, OnLoginListener l) {
        this.mContext = context.getApplicationContext();
        this.mPortalInfo = portal;
        this.mEMark = emark;
        this.mAuthSvrName = authsvr;
        this.mUsername = username;
        this.mPassword = password;
        this.mSdcardPin = sdcardPin;
        this.mExtras = null != extras ? extras : new SPLiteBundle();
        this.mListener = null != l ? l : new OnLoginListener(){

            @Override
            public void onLoginFinish(String result, SPAppInfo appinfo) {
            }

            @Override
            public void onLoginBusy(boolean busy) {
            }
        };
    }

    public String login() {
        PortalSession session = PortalSession.instance(this.mContext);
        String vpn_host = PortalSession.vpnHost();
        int vpn_port = PortalSession.vpnPort();
        String vpn_sni = PortalSession.vpnSNI();
        PLog.i("LOGIN vpn=[%s/%s]:%d, username='%s'", vpn_host, vpn_sni, vpn_port, SPStringUtil.ellipsize(this.mUsername, 32));
        if (null == this.mPortalInfo) {
            GatewayRsp rsp = GatewayAgentAuth.getPortal(vpn_host, vpn_port, vpn_sni);
            if (rsp.errcode == 0) {
                this.mPortalInfo = (SPPortalInfo)rsp.getData();
            } else if (TextUtils.isEmpty((CharSequence)this.mEMark)) {
                return rsp.errmsg;
            }
        }
        if (null != this.mPortalInfo && this.mPortalInfo.carrierTypes > 0) {
            int netinfo = SPNetUtil.getActiveNetInfo(this.mContext);
            int mask = SPPortalInfo.terminalMask(this.mPortalInfo.carrierTypes);
            PLog.v("term_limit=0x%08x, term_mask=0x%08X, netinfo=0x%08X", this.mPortalInfo.carrierTypes, mask, netinfo);
            if ((netinfo & mask) == 0 && (netinfo & 0x100) == 0) {
                return SPLoginTaskV1.disallowedNetworkMsg(netinfo);
            }
        }
        SPAuthServerInfo authsvr = new SPAuthServerInfo();
        if (TextUtils.isEmpty((CharSequence)this.mEMark) && !this.mPortalInfo.authList.isEmpty()) {
            authsvr = this.mPortalInfo.authList.get(0);
            for (SPAuthServerInfo a : this.mPortalInfo.authList) {
                if (!a.name.equals(this.mAuthSvrName)) continue;
                authsvr = a;
                break;
            }
        }
        if (authsvr.sub_type == 5 && this.mPortalInfo.smxCertEnable) {
            if (null == SPFileUtil.getExtSdCardPath(this.mContext)) {
                return "\u6ca1\u6709\u53d1\u73b0\u56fd\u5bc6TF\u5361";
            }
            if (0 != SPLibBridge.setSSLSMX((String)this.mPortalInfo.smxAlgCipher, (String)this.mPortalInfo.smxContainer, (String)this.mPortalInfo.smxApp, (String)this.mSdcardPin).errcode) {
                return "\u521d\u59cb\u5316\u56fd\u5bc6TF\u5361\u5931\u8d25";
            }
        } else if (authsvr.sub_type == 19) {
            if (TextUtils.isEmpty((CharSequence)this.mUsername) || TextUtils.isEmpty((CharSequence)this.mPassword)) {
                if (null == SPFileUtil.getExtSdCardPath(this.mContext)) {
                    return "\u6ca1\u6709\u53d1\u73b0\u56fd\u5bc6TF\u5361";
                }
                JSONObject json = new JSONObject();
                SPJSONUtil.put(json, "container", authsvr.sub_key_container);
                SPJSONUtil.put(json, "app", authsvr.sub_key_app);
                SPJSONUtil.put(json, "pin", this.mSdcardPin);
                SPMsgRspEmpty cmdrsp = SPLibBridge.exeCmdEx("sys_ssl_sign_cert", json);
                if (0 != cmdrsp.errcode) {
                    return TextUtils.isEmpty((CharSequence)cmdrsp.errmsg) ? "\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25" : cmdrsp.errmsg;
                }
                this.mUsername = cmdrsp.json.optString("pem");
                this.mPassword = cmdrsp.json.optString("signature");
                this.mExtras.put("auth_cert_type", "SM2_SM3_SM2_SKF");
            } else {
                this.mExtras.put("auth_cert_type", "SM2_SM3_SM2_OPENSSL");
            }
        }
        GatewayRsp rsp = GatewayAgentAuth.login(vpn_host, vpn_port, vpn_sni, this.mEMark, this.mPortalInfo, authsvr, this.mUsername, this.mPassword, 0, this.mExtras);
        if (0 == rsp.errcode) {
            SPUserInfo me = (SPUserInfo)rsp.getData();
            session.username = this.mUsername;
            session.password = this.mPassword;
            session.authsvr = authsvr;
            session.setLogin(me, this.mExtras);
            if (me.uid < 1) {
                return "";
            }
            SPLiteBundle dataExtras = new SPLiteBundle();
            dataExtras.put("app_identify", session.app_identify);
            rsp = GatewayAgentAuth.getUserdata(vpn_host, vpn_port, vpn_sni, dataExtras);
            if (0 == rsp.errcode && null != rsp.getData() && ((SPUserDataInfo)rsp.getData()).needsBind != 0) {
                if (GatewayAgentAuth.putHostbind(vpn_host, vpn_port, vpn_sni)) {
                    rsp = GatewayAgentAuth.getUserdata(vpn_host, vpn_port, vpn_sni, dataExtras);
                } else {
                    return GatewayErrorText.getErrMsg(0xFFFFFFF);
                }
            }
            if (0 == rsp.errcode) {
                SPUserDataInfo userdata = (SPUserDataInfo)rsp.getData();
                userdata.smxAlgCipher = this.mPortalInfo.smxAlgCipher;
                SPortalConf config = SPortalConf.load(this.mContext);
                userdata.policy.pkgappNCEnable = false;
                userdata.policy.pkgappNotifyEnable = false;
                userdata.policy.pkgappUpgrade = 0;
                JSONObject json = SPJSONUtil.parseObject(config.app_policy);
                userdata.policy.pkgappNCEnable = 0 != json.optInt("nc_enable", 0);
                userdata.policy.pkgappNotifyEnable = 0 != json.optInt("notify_enable", 0);
                userdata.policy.pkgappUpgrade = json.optInt("upgrade_policy", 0);
                session.setUserdata(userdata);
                this.mAppInfo = null;
                if (userdata.policy.pkgappUpgrade != 0) {
                    String pkgname = SPApplication.getPkgName(this.mContext);
                    rsp = GatewayAgentAppstore.queryAppList(vpn_host, vpn_port, me.ticketstr, pkgname, session.app_identify);
                    if (rsp.errcode == 0) {
                        List appList = (List)rsp.getData();
                        SPAppInfo xapp = null;
                        for (SPAppInfo app : appList) {
                            if (!pkgname.equals(app.pkgname) || null != xapp && app.mtime <= xapp.mtime) continue;
                            xapp = app;
                        }
                        if (null != xapp && xapp.mtime != SPSystemUtil.getAppPackTime(this.mContext) / 1000L) {
                            this.mAppInfo = xapp;
                        }
                    }
                }
                return "";
            }
            session.setLogin(null, this.mExtras);
            return rsp.errmsg;
        }
        return rsp.errmsg;
    }

    protected void onPreExecute() {
        this.mListener.onLoginBusy(true);
        super.onPreExecute();
    }

    protected String doInBackground(String ... params) {
        return this.login();
    }

    protected void onPostExecute(String result) {
        this.mListener.onLoginBusy(false);
        this.mListener.onLoginFinish(result, this.mAppInfo);
        super.onPostExecute((Object)result);
    }

    public static interface OnLoginListener {
        public void onLoginBusy(boolean var1);

        public void onLoginFinish(String var1, SPAppInfo var2);
    }
}

