/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.deprecated;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.secure.comm.app.SPResourseKit;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPTripleDes;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopup;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPPortalInfo;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.entry.SPortalConf;
import com.secure.sportal.gateway.GatewayAgentAuth;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.app.SPLoginBaseActivity;
import com.secure.sportal.sdk.app.SPNotifyManager;
import com.secure.sportal.sdk.auth.SPAuthViewKit;
import com.secure.sportal.sdk.deprecated.SPLoginTaskV1;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.PortalSession;
import java.io.File;
import java.io.FilenameFilter;

public class SPLoginActivityV1
extends SPLoginBaseActivity
implements View.OnClickListener,
SPLoginTaskV1.OnLoginListener {
    private String mSvrIP;
    private int mSvrPort = 443;
    private View mRootView;
    private ImageView mTopBanner;
    private View mPaneAuthSvr;
    private View mPaneUsername;
    private View mPanePassword;
    private TextView mTextAuthSvr;
    private TextView mTextCertFile;
    private EditText mEditUsername;
    private EditText mEditPassword;
    private CheckBox mCkboxRemember;
    private CheckBox mCkboxAutoLogin;
    private Button mBtnLogin;
    private TextView mTextNotice;
    private ViewGroup mPaneCover;
    private ProgressBar mProgressBar;
    private SPortalConf mConfig;
    private SPPortalInfo mPortalInfo;
    private String mAuthSvrName = "";
    private String mUsername = "";
    private String mPassword = "";
    private boolean mRemember = false;
    private boolean mAutoLogin = false;
    private int mAuthProtocol = 0;
    private String[] mAuthSvrNameList = null;

    public static void initSecurePortal(Context context) {
        SPLibBridge.initLibrary(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mConfig = SPortalConf.load((Context)this);
        this.mPortalInfo = null;
        this.mRootView = View.inflate((Context)this, (int)SPResourseKit.getResId((Context)this, "layout", "sportal_activity_login_v1"), null);
        this.setContentView(this.mRootView);
        this.mTopBanner = (ImageView)SPResourseKit.findViewByName(this.mRootView, "sportal_login_banner");
        this.mPaneAuthSvr = SPResourseKit.findViewByName(this.mRootView, "sportal_login_pane_authsvr");
        this.mPaneUsername = SPResourseKit.findViewByName(this.mRootView, "sportal_login_pane_username");
        this.mPanePassword = SPResourseKit.findViewByName(this.mRootView, "sportal_login_pane_password");
        this.mTextAuthSvr = (TextView)SPResourseKit.findViewByName(this.mRootView, "sportal_login_txt_authsvr");
        this.mTextCertFile = (TextView)SPResourseKit.findViewByName(this.mRootView, "sportal_login_txt_certfile");
        this.mEditUsername = (EditText)SPResourseKit.findViewByName(this.mRootView, "sportal_login_edit_username");
        this.mEditPassword = (EditText)SPResourseKit.findViewByName(this.mRootView, "sportal_login_edit_password");
        this.mCkboxRemember = (CheckBox)SPResourseKit.findViewByName(this.mRootView, "sportal_login_chk_remmeber");
        this.mCkboxAutoLogin = (CheckBox)SPResourseKit.findViewByName(this.mRootView, "sportal_login_chk_autologin");
        this.mBtnLogin = (Button)SPResourseKit.findViewByName(this.mRootView, "sportal_login_btn_login");
        this.mTextNotice = (TextView)SPResourseKit.findViewByName(this.mRootView, "sportal_login_txt_notice");
        this.mPaneCover = (ViewGroup)SPResourseKit.findViewByName(this.mRootView, "sportal_login_pane_cover");
        this.mProgressBar = (ProgressBar)SPResourseKit.findViewByName(this.mRootView, "sportal_login_prog_waiting");
        this.optimizeBannerView(this.mRootView, this.mTopBanner);
        this.mAuthSvrName = this.mConfig.auth_server;
        this.mTextAuthSvr.setText((CharSequence)this.mAuthSvrName);
        if (Build.VERSION.SDK_INT < 17) {
            int padding = (int)SPViewUtil.dp2px((Context)this, 36.0f);
            this.mCkboxRemember.setPadding(padding, this.mCkboxRemember.getPaddingTop(), this.mCkboxRemember.getPaddingRight(), this.mCkboxRemember.getPaddingBottom());
            this.mCkboxAutoLogin.setPadding(padding, this.mCkboxAutoLogin.getPaddingTop(), this.mCkboxAutoLogin.getPaddingRight(), this.mCkboxAutoLogin.getPaddingBottom());
        }
        this.mTextAuthSvr.setOnClickListener((View.OnClickListener)this);
        this.mTextCertFile.setOnClickListener((View.OnClickListener)this);
        this.mCkboxRemember.setOnClickListener((View.OnClickListener)this);
        this.mCkboxAutoLogin.setOnClickListener((View.OnClickListener)this);
        this.mBtnLogin.setOnClickListener((View.OnClickListener)this);
        this.onAuthProtocolChanged();
        this.mRootView.postDelayed(new Runnable(){

            @Override
            public void run() {
                SPLoginActivityV1.this.onUILoaded();
            }
        }, 100L);
    }

    private void onUILoaded() {
        SPNotifyManager.showNotification((Context)this, false);
        if (this.mConfig.auth_autologin) {
            this.mUsername = this.mConfig.auth_username;
            this.mPassword = this.mConfig.auth_password;
            this.mPaneAuthSvr.setVisibility(4);
            this.mPaneUsername.setVisibility(4);
            this.mPanePassword.setVisibility(4);
            this.mCkboxRemember.setVisibility(4);
            this.mCkboxAutoLogin.setVisibility(4);
            this.mBtnLogin.setVisibility(4);
            this.startLogin();
        } else {
            this.readOrWriteConfig(true);
            if (this.mRemember) {
                this.mEditUsername.setText((CharSequence)this.mUsername);
                this.mEditPassword.setText((CharSequence)this.mPassword);
                this.mTextCertFile.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mUsername) ? "\u8bf7\u9009\u62e9\u8bc1\u4e66\u6587\u4ef6" : this.mUsername));
            }
            this.mCkboxRemember.setChecked(this.mRemember);
            this.mCkboxAutoLogin.setChecked(this.mAutoLogin);
            new SPortalGetPortalTask(this.mAutoLogin).execute(new String[0]);
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnLogin) {
            this.mAuthSvrName = this.mTextAuthSvr.getText().toString();
            this.mUsername = this.mAuthProtocol == 5 ? this.mTextCertFile.getText().toString() : this.mEditUsername.getEditableText().toString();
            this.mPassword = this.mEditPassword.getEditableText().toString();
            this.mAutoLogin = this.mCkboxAutoLogin.isChecked();
            boolean bl = this.mRemember = this.mAutoLogin || this.mCkboxRemember.isChecked();
            if (this.mAuthProtocol == 5) {
                if (!SPFileUtil.checkKeyStoreCertFile(SPFileUtil.getSdCardPath() + "/" + this.mTextCertFile.getText(), this.mPassword)) {
                    SPAuthViewKit.showMsgBox(this, "\u63d0\u793a", "\u8bc1\u4e66\u6587\u4ef6\u65e0\u6548\u6216\u5bc6\u7801\u9519\u8bef");
                    return;
                }
            } else {
                if (TextUtils.isEmpty((CharSequence)this.mUsername)) {
                    SPAuthViewKit.showMsgBox(this, "\u63d0\u793a", "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)this.mPassword)) {
                    SPAuthViewKit.showMsgBox(this, "\u63d0\u793a", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
            }
            this.startLogin();
        } else if (v == this.mCkboxRemember) {
            if (!this.mCkboxRemember.isChecked()) {
                this.mCkboxAutoLogin.setChecked(false);
            }
        } else if (v == this.mCkboxAutoLogin) {
            if (this.mCkboxAutoLogin.isChecked()) {
                this.mCkboxRemember.setChecked(true);
            }
        } else if (v == this.mTextAuthSvr) {
            this.onSelectAuthSvr();
        } else if (v == this.mTextCertFile) {
            this.onPickCertFile();
        }
    }

    private void startLogin() {
        SPNotifyManager.showNotification((Context)this, false);
        SPNCServiceManagement.startOrStopNC((Context)this, false, true, true);
        if (null != this.mTextNotice) {
            this.mTextNotice.setText((CharSequence)"");
        }
        if (null == this.mPortalInfo) {
            new SPortalGetPortalTask(true).execute(new String[0]);
        } else {
            this.performLogin();
        }
    }

    private void performLogin() {
        if (null == this.mConfig.extras) {
            this.mConfig.extras = new SPLiteBundle();
        }
        this.mConfig.extras.put("sportal", "0");
        String username = this.mUsername;
        if (this.mAuthProtocol == 5 && username.length() < 128 && new File(SPFileUtil.getSdCardPath() + "/" + username).exists()) {
            byte[] bytes = SPFileUtil.readFile(SPFileUtil.getSdCardPath() + "/" + username);
            username = Base64.encodeToString((byte[])bytes, (int)2);
        }
        new SPLoginTaskV1((Context)this, this.mPortalInfo, null, this.mAuthSvrName, username, this.mPassword, this.mConfig.sdcard_pin, this.mConfig.extras, this).execute(new String[0]);
    }

    private void onLoginSPortalSuccess(boolean manual, SPAppInfo appinfo) {
        if (!this.mConfig.auth_autologin && manual) {
            this.mRemember = this.mAutoLogin || this.mRemember;
            this.readOrWriteConfig(false);
        }
        SPUserDataInfo userdata = PortalSession.instance((Context)this).userdata();
        Bundle extras = new Bundle();
        extras.putString("vpn_username", this.mUsername);
        extras.putString("vpn_password", this.mPassword);
        if (null != appinfo) {
            this.updateAppSelf(userdata, extras, null);
        } else {
            this.commitLogin(userdata, extras, null);
        }
    }

    private void onSelectAuthSvr() {
        if (null != this.mAuthSvrNameList && this.mAuthSvrNameList.length > 1) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, SPPopup.theme());
            builder.setTitle((CharSequence)"\u9009\u62e9\u8ba4\u8bc1\u670d\u52a1\u5668").setCancelable(true);
            builder.setItems((CharSequence[])this.mAuthSvrNameList, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SPLoginActivityV1.this.mAuthSvrName = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)which).name;
                    SPLoginActivityV1.this.mTextAuthSvr.setText((CharSequence)SPLoginActivityV1.this.mAuthSvrName);
                    SPLoginActivityV1.this.mAuthProtocol = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)which).sub_type;
                    SPLoginActivityV1.this.onAuthProtocolChanged();
                }
            });
            builder.setNegativeButton((CharSequence)Html.fromHtml((String)"<font color='#13a0d6'>\u53d6\u6d88</font>"), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            builder.show().setCanceledOnTouchOutside(true);
        }
    }

    protected void onAuthProtocolChanged() {
        if (this.mAuthProtocol == 5) {
            this.mEditUsername.setVisibility(4);
            this.mTextCertFile.setVisibility(0);
        } else {
            this.mEditUsername.setVisibility(0);
            this.mTextCertFile.setVisibility(4);
        }
    }

    protected void onPickCertFile() {
        CharSequence[] pkfiles = new File(SPFileUtil.getSdCardPath()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".pfx") || filename.endsWith(".p12");
            }
        });
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, SPPopup.theme());
        builder.setTitle((CharSequence)"\u8bf7\u9009\u62e9\u8bc1\u4e66\u6587\u4ef6").setCancelable(true);
        builder.setItems(pkfiles, new DialogInterface.OnClickListener((String[])pkfiles){
            final /* synthetic */ String[] val$pkfiles;
            {
                this.val$pkfiles = stringArray;
            }

            public void onClick(DialogInterface dialog, int item) {
                if (null != this.val$pkfiles && item < this.val$pkfiles.length) {
                    SPLoginActivityV1.this.mTextCertFile.setText((CharSequence)this.val$pkfiles[item]);
                }
            }
        });
        builder.setNegativeButton((CharSequence)Html.fromHtml((String)"<font color='#13a0d6'>\u53d6\u6d88</font>"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.show().setCanceledOnTouchOutside(true);
    }

    private void readOrWriteConfig(boolean read) {
        if (read) {
            SharedPreferences sp = this.getSharedPreferences("sportal", 0);
            this.mAutoLogin = sp.getBoolean("autologin", false);
            this.mRemember = this.mAutoLogin || sp.getBoolean("remember", false);
            this.mAuthSvrName = this.mRemember ? sp.getString("auth_server", "") : "";
            this.mUsername = this.mRemember ? sp.getString("username", "") : "";
            this.mPassword = this.mRemember ? SPTripleDes.decrypt(sp.getString("password", "")) : "";
        } else {
            SharedPreferences.Editor sp = this.getSharedPreferences("sportal", 0).edit();
            sp.putBoolean("remember", this.mRemember);
            sp.putBoolean("autologin", this.mAutoLogin);
            sp.putString("auth_server", this.mAuthSvrName);
            sp.putString("username", this.mRemember ? this.mUsername : "");
            sp.putString("password", this.mRemember ? SPTripleDes.encrypt(this.mPassword) : "");
            sp.apply();
        }
    }

    @Override
    public void onLoginBusy(boolean busy) {
        this.mTextAuthSvr.setEnabled(!busy);
        this.mTextCertFile.setEnabled(!busy);
        this.mEditUsername.setEnabled(!busy);
        this.mEditPassword.setEnabled(!busy);
        this.mCkboxRemember.setEnabled(!busy);
        this.mCkboxAutoLogin.setEnabled(!busy);
        this.mBtnLogin.setEnabled(!busy);
        this.mPaneCover.setVisibility(busy ? 0 : 8);
    }

    @Override
    public void onLoginFinish(String result, SPAppInfo appinfo) {
        if (TextUtils.isEmpty((CharSequence)result)) {
            this.onLoginSPortalSuccess(true, appinfo);
        } else {
            if (!this.mConfig.auth_autologin) {
                this.onLoginBusy(false);
            }
            SPAuthViewKit.showMsgBox(this, "\u65e0\u6cd5\u767b\u5f55\u5e94\u7528", result);
            if (null != this.mTextNotice) {
                this.mTextNotice.setText((CharSequence)"");
            }
        }
    }

    static /* synthetic */ String[] access$602(SPLoginActivityV1 x0, String[] x1) {
        x0.mAuthSvrNameList = x1;
        return x1;
    }

    private class SPortalGetPortalTask
    extends AsyncTask<String, String, String> {
        private boolean andLogin = false;

        public SPortalGetPortalTask(boolean login) {
            this.andLogin = login;
        }

        protected String doInBackground(String ... params) {
            GatewayRsp rsp = GatewayAgentAuth.getPortal(PortalSession.vpnHost(), PortalSession.vpnPort(), PortalSession.vpnSNI());
            if (rsp.errcode == 0) {
                SPLoginActivityV1.this.mPortalInfo = (SPPortalInfo)rsp.getData();
                if (null == SPLoginActivityV1.this.mPortalInfo) {
                    SPLoginActivityV1.this.mPortalInfo = new SPPortalInfo();
                }
                return "";
            }
            return rsp.errmsg;
        }

        protected void onPreExecute() {
            SPLoginActivityV1.this.onLoginBusy(true);
            super.onPreExecute();
        }

        protected void onPostExecute(String result) {
            if (TextUtils.isEmpty((CharSequence)result)) {
                int i = 0;
                int pos = 0;
                while (i < ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.size()) {
                    SPAuthServerInfo auth = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get(i);
                    if (auth.id != auth.sub_id || auth.sub_qrcode == 2 || auth.sub_type == 9 || auth.sub_type == 14 || auth.sub_type == 12 || auth.sub_type == 6 || auth.sub_type == 4 || auth.sub_type == 13 || auth.sub_type == 18) {
                        ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.remove(i);
                        continue;
                    }
                    if (SPLoginActivityV1.this.mAuthSvrName.equals(((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)i).name)) {
                        pos = i;
                    }
                    ++i;
                }
                if (!((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.isEmpty()) {
                    SPLoginActivityV1.this.mAuthSvrName = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)pos).name;
                    SPLoginActivityV1.this.mAuthProtocol = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)pos).sub_type;
                    SPLoginActivityV1.this.mTextAuthSvr.setText((CharSequence)SPLoginActivityV1.this.mAuthSvrName);
                    SPLoginActivityV1.access$602(SPLoginActivityV1.this, new String[((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.size()]);
                    for (int ii = 0; ii < ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.size(); ++ii) {
                        ((SPLoginActivityV1)SPLoginActivityV1.this).mAuthSvrNameList[ii] = ((SPLoginActivityV1)SPLoginActivityV1.this).mPortalInfo.authList.get((int)ii).name;
                    }
                }
                boolean visible = !((SPLoginActivityV1)SPLoginActivityV1.this).mConfig.auth_autologin && i > 1;
                SPLoginActivityV1.this.mPaneAuthSvr.setVisibility(visible ? 0 : 4);
                SPLoginActivityV1.this.onLoginBusy(false);
                if (this.andLogin) {
                    SPLoginActivityV1.this.performLogin();
                } else {
                    SPLoginActivityV1.this.onAuthProtocolChanged();
                }
            } else {
                SPLoginActivityV1.this.mPaneCover.setVisibility(8);
                SPAuthViewKit.showMsgBox(SPLoginActivityV1.this, "\u65e0\u6cd5\u8fde\u63a5\u5e94\u7528", result);
            }
        }
    }
}

