/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.auth;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.Html;
import android.text.TextUtils;
import android.widget.Toast;
import com.secure.PLog;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.view.SPPopup;
import com.secure.comm.view.SPPopupInputBox;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.auth.SPAuthPositiveTask;
import java.util.HashSet;

public class SPAuthViewKit {
    private static String mem_pin = null;

    public static void showMsgBox(Activity activity, String title, String msg) {
        SPAuthViewKit.showMsgBox(activity, title, msg, null);
    }

    public static void showMsgBox(Activity activity, String title, String msg, final SPAuthPositiveTask positive) {
        if (activity.isFinishing()) {
            Toast.makeText((Context)activity, (CharSequence)msg, (int)1).show();
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity, SPPopup.theme());
        builder.setTitle((CharSequence)title).setMessage((CharSequence)Html.fromHtml((String)("<font color='#ff7900'>" + msg + "</font>")));
        builder.setCancelable(true);
        if (null != positive) {
            builder.setPositiveButton((CharSequence)Html.fromHtml((String)("<font color='#13a0d6'>" + positive.mText + "</font>")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    positive.run();
                }
            });
        }
        builder.setNegativeButton((CharSequence)Html.fromHtml((String)"<font color='#13a0d6'>\u786e\u5b9a</font>"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dlg = builder.show();
        dlg.setCanceledOnTouchOutside(true);
    }

    public static void clearCachedPin(Context context) {
        SPFileUtil.deletePrivateFile(context, "sdcard_pin.bin");
        mem_pin = null;
    }

    public static void verifySdcardPin(final Activity context, final String defaultPIN, final String cipher, final String container, final String app, final SPRunnable<String> postTask) {
        new Thread(){

            @Override
            public void run() {
                final HashSet<String> pins = new HashSet<String>();
                pins.add(SPStringUtil.opt(mem_pin));
                pins.add(SPStringUtil.opt((String)SPFileUtil.readObject((Context)context, "sdcard_pin.bin")));
                pins.add(SPStringUtil.opt(defaultPIN));
                for (String pin : pins) {
                    String cached_pin = SPStringUtil.opt(pin);
                    if (cached_pin.length() <= 0 || 0 != SPLibBridge.setSSLSMX((String)cipher, (String)container, (String)app, (String)cached_pin).errcode) continue;
                    mem_pin = cached_pin;
                    if (null != postTask) {
                        postTask.setUserObject(cached_pin);
                        context.runOnUiThread((Runnable)postTask);
                    }
                    return;
                }
                SPAuthViewKit.clearCachedPin((Context)context);
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        PLog.v("verifySdcardPin: Can not fund the corrent PIN in %s", pins.toString());
                        SPPopupInputBox.inputBox((Context)context, "\u8bf7\u8f93\u5165\u56fd\u5bc6\u5361PIN\u7801", 129, "\u8bb0\u4f4f", null, null, new SPPopupInputBox.SPInputBoxCallback(){

                            @Override
                            public void OnInputBoxText(final String text, final boolean remember) {
                                PLog.v("verifySdcardPin: user inputs pin=%s,remember=%s", text, remember ? "yes" : "no");
                                if (!TextUtils.isEmpty((CharSequence)text)) {
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            SPMsgRspEmpty rsp = SPLibBridge.setSSLSMX(cipher, container, app, text);
                                            if (0 == rsp.errcode) {
                                                mem_pin = text;
                                                if (remember) {
                                                    SPFileUtil.writeObject((Context)context, "sdcard_pin.bin", text);
                                                }
                                                if (null != postTask) {
                                                    postTask.setUserObject(text);
                                                    postTask.run();
                                                }
                                            } else {
                                                PLog.v("verifySdcardPin: setSSLSMX result [%d]%s", rsp.errcode, rsp.errmsg);
                                                final String errmsg = TextUtils.isEmpty((CharSequence)rsp.errmsg) ? GatewayErrorText.getErrMsg(rsp.errcode, "\u521d\u59cb\u5316\u56fd\u5bc6TF\u52a0\u5bc6\u5361\u5931\u8d25") : "\u521d\u59cb\u5316\u56fd\u5bc6TF\u52a0\u5bc6\u5361\u5931\u8d25: " + rsp.errmsg;
                                                SPIntentUtil.runOnMainThread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        SPPopupMsgBox.popup((Context)context, "\u9519\u8bef", errmsg);
                                                    }
                                                }, 0L);
                                            }
                                        }
                                    }.start();
                                }
                            }
                        });
                    }
                }, 0L);
            }
        }.start();
    }
}

