/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.auth;

import android.content.Context;
import android.text.TextUtils;
import com.secure.comm.app.SPOEM;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.SPVPNClient;
import com.secure.sportal.sdk.auth.SPAuthModel;
import java.util.Locale;
import java.util.Properties;

public class SPAuthSDKTask
implements GatewayBroker.BrokerCallback,
SPAuthModel.OnAuthModelCallback {
    private static final int STATE_CONNECTED = 1;
    private static final int STATE_AUTHEN_ONE = 2;
    private static final int STATE_SENT_CODE = 3;
    private static final int STATE_FINISHED = 4;
    private static final int STATE_ERROR = 10;
    private Context mContext;
    private SPVPNClient.OnVPNLoginCallback mCallback;
    private SPAuthModel mModel;
    private GatewayBroker mPendingTask;
    private int mState;
    private Properties mParams;

    public SPAuthSDKTask(Context context, SPVPNClient.OnVPNLoginCallback callback) {
        this.mContext = null != context ? context.getApplicationContext() : null;
        this.setCallback(callback);
        this.mPendingTask = null;
        this.mModel = new SPAuthModel(this.mContext, this, false);
        this.mState = 0;
    }

    public void setCallback(SPVPNClient.OnVPNLoginCallback callback) {
        if (null != callback) {
            this.mCallback = callback;
        }
    }

    @Override
    public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
        this.mPendingTask = null;
        if (0 != msgrsp.errcode) {
            this.fireErrorMessage(msgrsp.errcode, msgrsp.errmsg);
        }
    }

    public boolean isPending() {
        return null != this.mPendingTask || this.mModel.hasPendingTask();
    }

    public void abort() {
        if (null != this.mPendingTask) {
            this.mPendingTask.abort();
            this.mPendingTask = null;
        }
        this.mModel.vpnAbort();
    }

    public void vpnAuth(String vpn_host, int vpn_port, Properties param) {
        this.mState = 0;
        this.mParams = param;
        this.mModel.vpnConnect(vpn_host, vpn_port);
    }

    public void vpnVerifyCode(String username, String target, String code) {
        username = SPStringUtil.opt(username);
        target = SPStringUtil.opt(target);
        code = SPStringUtil.opt(code);
        if (this.mModel.currentAuthServer().sub_type == 16) {
            this.mModel.vpnAuth(username.length() > 0 ? username : this.mModel.getUsername(), "", code, null);
        } else if (target.length() > 0 && this.mState == 2) {
            GatewayReq req = new GatewayReq("sac_code_send");
            if (this.mModel.currentAuthServer().sub_type == 9) {
                req.data.put("code_type", "sms");
            } else if (this.mModel.currentAuthServer().sub_type == 14) {
                req.data.put("code_type", "email");
            } else {
                return;
            }
            this.mModel.currentAuthServer().vcode_target = target;
            req.data.put("code_target", target);
            this.mPendingTask = this.mModel.vpnRequest(req, this);
        } else if (code.length() > 0 && this.mState == 3) {
            this.mModel.vpnAuth(this.mModel.getUsername(), "", code, null);
        } else {
            this.fireLoginMessage(256, "[02000404]\u65e0\u6548\u7684\u8ba4\u8bc1\u4f1a\u8bdd", 10L);
        }
    }

    private void fireLoginMessage(final int msgid, final String msgtext, long delay) {
        if (null != this.mCallback) {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SPAuthSDKTask.this.mCallback.onVPNLoginMessage(msgid, msgtext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delay);
        }
    }

    private void fireErrorMessage(int errcode, String errmsg) {
        if (TextUtils.isEmpty((CharSequence)errmsg)) {
            this.fireLoginMessage(256, GatewayErrorText.getErrMsg(errcode), 10L);
        } else if (GatewayErrorText.withErrorCode) {
            this.fireLoginMessage(256, String.format(Locale.getDefault(), "[%08X]%s", errcode, errmsg), 10L);
        } else {
            this.fireLoginMessage(256, errmsg, 10L);
        }
    }

    @Override
    public void onAuthModelBusy(SPAuthModel model, boolean busy, String notice) {
    }

    @Override
    public void onAuthModelError(SPAuthModel model, int errcode, String errmsg) {
        this.mState = 10;
        this.fireErrorMessage(errcode, errmsg);
    }

    @Override
    public void onAuthModelStageChanged(final SPAuthModel model, final int stage) {
        if (stage == 1) {
            SPAuthServerInfo authsvr = this.mModel.currentAuthServer();
            if (authsvr.sub_type == 5 && this.mModel.portalInfo.smxCertEnable && SPSystemUtil.isRunInMainThread()) {
                new Thread(){

                    @Override
                    public void run() {
                        SPAuthSDKTask.this.onAuthModelStageChanged(model, stage);
                    }
                }.start();
                return;
            }
            this.mState = 1;
            this.mModel.setAuthServer(this.mParams.getProperty("auth_server"));
            String username = this.mParams.getProperty("auth_username");
            String password = this.mParams.getProperty("auth_password");
            String sdcardpin = this.mParams.getProperty("sdcard_pin");
            if (SPOEM.isOEM_MPolicyZJ() && TextUtils.isEmpty((CharSequence)sdcardpin)) {
                sdcardpin = "1111111";
            }
            String vcode = "";
            SPLiteBundle extras = new SPLiteBundle();
            for (Object key : this.mParams.keySet()) {
                String name = key.toString();
                if (!name.startsWith("extra_")) continue;
                extras.put(name, this.mParams.getProperty(name, "").trim());
            }
            if (authsvr.sub_type == 5 && this.mModel.portalInfo.smxCertEnable) {
                if (0 != SPLibBridge.setSSLSMX((String)this.mModel.portalInfo.smxAlgCipher, (String)this.mModel.portalInfo.smxContainer, (String)this.mModel.portalInfo.smxApp, (String)sdcardpin).errcode) {
                    this.onAuthModelError(null, 0xF0000F1, "\u521d\u59cb\u5316\u56fd\u5bc6TF\u5361\u5931\u8d25");
                }
                username = "";
                password = sdcardpin;
            } else if (authsvr.sub_type == 19) {
                vcode = sdcardpin;
            }
            this.mModel.vpnAuth(username, password, vcode, extras);
        } else if (stage == 2) {
            this.mState = 2;
            SPAuthServerInfo authsvr = this.mModel.currentAuthServer();
            if (authsvr.sub_type == 16) {
                this.fireLoginMessage(36, "", 10L);
            } else if (authsvr.sub_type == 12 || authsvr.sub_type == 20) {
                this.fireLoginMessage(35, "", 10L);
            } else {
                int msgid = 0;
                String msgtxt = SPStringUtil.opt(authsvr.vcode_target);
                String codeType = "";
                if (authsvr.sub_type == 9) {
                    msgid = TextUtils.isEmpty((CharSequence)authsvr.vcode_target) ? 17 : 33;
                    codeType = "sms";
                } else if (authsvr.sub_type == 14) {
                    msgid = TextUtils.isEmpty((CharSequence)authsvr.vcode_target) ? 18 : 34;
                    codeType = "email";
                } else {
                    this.onAuthModelError(null, 0xF0000E0, "\u4e0d\u652f\u6301\u7684\u591a\u6b65\u8ba4\u8bc1");
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)authsvr.vcode_target)) {
                    GatewayReq req = new GatewayReq("sac_code_send");
                    req.data.put("code_target", authsvr.vcode_target);
                    req.data.put("code_type", codeType);
                    this.mPendingTask = this.mModel.vpnRequest(req, this);
                    this.mState = 3;
                }
                this.fireLoginMessage(msgid, msgtxt, 10L);
            }
        } else if (stage == 10) {
            this.mState = 4;
            this.fireLoginMessage(0, "", 200L);
        }
    }

    @Override
    public void onAuthModelAuthChanged(SPAuthModel model, SPAuthServerInfo authsvr) {
    }
}

