/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.auth;

import android.content.Context;
import android.content.SharedPreferences;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPTripleDes;
import com.secure.sportal.entry.SPortalConf;
import org.json.JSONObject;

public class SPAuthRecord {
    public String vpn_host = "";
    public int vpn_port = 443;
    public String auth_server = "";
    public boolean auto_login = false;
    public int qrcode_flag = 0;
    public String username = "";
    public String password = "";
    public String second_authname = "";
    public String second_uname = "";

    public SPAuthRecord fromConfig(SPortalConf config) {
        this.vpn_host = config.vpn_host;
        this.vpn_port = config.vpn_port;
        this.auto_login = config.auth_autologin;
        this.auth_server = config.auth_server;
        this.username = config.auth_username;
        this.password = config.auth_password;
        this.qrcode_flag = 0;
        return this;
    }

    public void store(Context context) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "vpn_host", this.vpn_host);
        SPJSONUtil.put(json, "vpn_port", this.vpn_port);
        SPJSONUtil.put(json, "auto_login", this.auto_login ? "1" : "0");
        SPJSONUtil.put(json, "qrcode_flag", this.qrcode_flag);
        SPJSONUtil.put(json, "auth_server", this.auth_server);
        SPJSONUtil.put(json, "username", this.username);
        SPJSONUtil.put(json, "password", this.password);
        SPJSONUtil.put(json, "second_authname", this.second_authname);
        SPJSONUtil.put(json, "second_uname", this.second_uname);
        String text = SPTripleDes.encrypt(json.toString());
        SharedPreferences.Editor sp = context.getSharedPreferences("sportal", 0).edit();
        sp.putString("auth_data", text);
        sp.apply();
    }

    public void load(Context context) {
        SharedPreferences sp = context.getSharedPreferences("sportal", 0);
        String text = SPTripleDes.decrypt(sp.getString("auth_data", ""));
        JSONObject json = SPJSONUtil.parseObject(text);
        this.vpn_host = json.optString("vpn_host");
        this.vpn_port = json.optInt("vpn_port", 443);
        this.auth_server = json.optString("auth_server");
        this.username = json.optString("username");
        this.password = json.optString("password");
        this.auto_login = json.optInt("auto_login") == 1;
        this.qrcode_flag = json.optInt("qrcode_flag");
        this.second_uname = json.optString("second_uname");
        this.second_authname = json.optString("second_authname");
    }
}

