/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.auth;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.entry.SPX509Info;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.entry.SPPortalInfo;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.entry.SPUserInfo;
import com.secure.sportal.entry.SPortalConf;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.gateway.msg.LoginReq;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.sdk.auth.SPAuthRecord;
import com.secure.sportal.service.PortalSession;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPAuthModel
implements GatewayBroker.BrokerCallback {
    public static final int STAGE_CONNECT = 0;
    public static final int STAGE_AUTH_UNAME = 1;
    public static final int STAGE_AUTH_VCODE = 2;
    public static final int STAGE_AUTH_OVER = 10;
    private Context mContext = null;
    public int stage = 0;
    public boolean remember = false;
    public String vpn_host = "";
    public int vpn_port = 443;
    public SPPortalInfo portalInfo = null;
    public SPUserInfo userinfo = null;
    public SPUserDataInfo userdata = null;
    public boolean qrcode_state = true;
    public SPortalConf pkgconfig = null;
    public SPAuthRecord record = null;
    private OnAuthModelCallback mCallback = null;
    private SPAuthRecord mTrack = null;
    private List<SPAuthServerInfo> mAuthChain = new ArrayList<SPAuthServerInfo>();
    private SPLiteBundle mExtras = null;
    private GatewayReq mLoginReq = null;
    private GatewayBroker mPendingBroker = null;
    private boolean mIsRepacked = false;
    private boolean mHasBinded = false;
    private boolean mFirstTime = true;

    public SPAuthModel(Context context, OnAuthModelCallback callback, boolean repacked) {
        this.mContext = null == context ? SPApplication.appContext() : context;
        SPApplication.setAppContext(this.mContext);
        SPLibBridge.initLibrary(this.mContext);
        this.mIsRepacked = repacked;
        this.pkgconfig = this.mIsRepacked ? SPortalConf.load(this.mContext) : new SPortalConf();
        this.record = new SPAuthRecord();
        this.record.load(this.mContext);
        this.qrcode_state = this.record.qrcode_flag > 0;
        this.reset();
        this.mCallback = callback;
        this.vpn_host = SPStringUtil.opt(this.pkgconfig.vpn_host);
        this.vpn_port = this.pkgconfig.vpn_port;
    }

    private void reset() {
        this.vpn_host = "";
        this.vpn_port = 443;
        this.portalInfo = null;
        this.userinfo = null;
        this.stage = 0;
        this.mAuthChain.clear();
        this.mPendingBroker = null;
        this.mExtras = null;
        this.mLoginReq = null;
    }

    public String getUsername() {
        String uname = "";
        SPAuthServerInfo auth = this.currentAuthServer();
        if (auth.carry == 1 || auth.carry == 2) {
            uname = auth.carry_uname;
        } else if (this.mAuthChain.size() == 1) {
            if (this.pkgconfig.auth_autologin) {
                uname = SPStringUtil.opt(this.pkgconfig.auth_username);
            } else if (this.currentAuthServer().name.equals(this.record.auth_server) && SPStringUtil.opt(this.record.username).length() > 0) {
                uname = SPStringUtil.opt(this.record.username);
            }
        } else if (this.mAuthChain.size() == 2 && this.currentAuthServer().name.equals(this.record.second_authname)) {
            uname = SPStringUtil.opt(this.record.second_uname);
        }
        return SPStringUtil.opt(uname);
    }

    public String getPassword() {
        String passw = "";
        SPAuthServerInfo auth = this.currentAuthServer();
        if (auth.carry == 2) {
            passw = auth.carry_passw;
        } else if (this.mAuthChain.size() == 1) {
            if (this.pkgconfig.auth_autologin) {
                passw = this.pkgconfig.auth_password;
            } else if (this.record.auto_login && this.currentAuthServer().name.equals(this.record.auth_server) && !TextUtils.isEmpty((CharSequence)this.record.password)) {
                passw = this.record.password;
            }
        }
        return null != passw ? passw : "";
    }

    public void saveTracks() {
        if (null != this.mTrack) {
            if (this.pkgconfig.auth_autologin) {
                this.mTrack.username = "";
                this.mTrack.password = "";
                this.mTrack.qrcode_flag = 0;
                this.mTrack.auto_login = false;
            } else if (!this.mTrack.auto_login) {
                this.mTrack.password = "";
            }
            this.mTrack.store(this.mContext);
        }
    }

    public boolean hasPendingTask() {
        return null != this.mPendingBroker;
    }

    public void fireBusy(final boolean busy, final String notice) {
        if (null == this.mCallback) {
            return;
        }
        if (SPSystemUtil.isRunInMainThread()) {
            this.mCallback.onAuthModelBusy(this, busy, notice);
        } else {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPAuthModel.this.fireBusy(busy, notice);
                }
            }, 5L);
        }
    }

    private void fireError(final int errcode, final String errmsg) {
        if (null == this.mCallback) {
            return;
        }
        if (SPSystemUtil.isRunInMainThread()) {
            this.mCallback.onAuthModelError(this, errcode, errmsg);
        } else {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPAuthModel.this.mCallback.onAuthModelError(SPAuthModel.this, errcode, errmsg);
                }
            }, 5L);
        }
    }

    private void fireStageChanged(final int stage) {
        if (null == this.mCallback) {
            return;
        }
        if (SPSystemUtil.isRunInMainThread()) {
            this.mCallback.onAuthModelStageChanged(this, stage);
        } else {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPAuthModel.this.fireStageChanged(stage);
                }
            }, 5L);
        }
    }

    private void fireAuthServerChanged() {
        if (null == this.mCallback) {
            return;
        }
        if (SPSystemUtil.isRunInMainThread()) {
            this.mCallback.onAuthModelAuthChanged(this, this.currentAuthServer());
        } else {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPAuthModel.this.fireAuthServerChanged();
                }
            }, 5L);
        }
    }

    public SPAuthServerInfo currentAuthServer() {
        return this.mAuthChain.size() > 0 ? this.mAuthChain.get(this.mAuthChain.size() - 1) : null;
    }

    public SPAuthServerInfo setAuthServer(int index) {
        SPAuthServerInfo authsvr = this.portalInfo.authList.get(index);
        this.mAuthChain.clear();
        this.mAuthChain.add(authsvr);
        this.fireAuthServerChanged();
        return authsvr;
    }

    public SPAuthServerInfo setAuthServer(String name) {
        for (int i = 0; i < this.portalInfo.authList.size(); ++i) {
            if (!SPStringUtil.opt(this.portalInfo.authList.get((int)i).name).equals(name)) continue;
            return this.setAuthServer(i);
        }
        return this.setAuthServer(0);
    }

    @Override
    public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
        JSONObject json;
        this.mPendingBroker = null;
        this.fireBusy(false, "");
        PLog.v("onGatewayBrokerRsp msgid=%s, errcode=%d, errmsg=%s", msgrsp.msgid, msgrsp.errcode, msgrsp.errmsg);
        SPVPNTool.setLogFlush();
        if ("sac_auth".equals(msgrsp.msgid) || "sac_auth_sub".equals(msgrsp.msgid)) {
            this.onBrokerAuthResponse(msgrsp);
            return;
        }
        if ("sac_app_list".equals(msgrsp.msgid)) {
            if (0 == msgrsp.errcode && null != msgrsp.json) {
                String pkgname = this.mContext.getPackageName();
                JSONArray japps = msgrsp.json.optJSONArray("applist");
                SPAppInfo appinfo = null;
                for (int i = 0; null != japps && i < japps.length(); ++i) {
                    if (null == japps.optJSONObject(i) || !pkgname.equals(japps.optJSONObject(i).optString("package_name"))) continue;
                    SPAppInfo xappinfo = SPAppInfo.fromBrokerJSON(japps.optJSONObject(i));
                    if (null != appinfo && xappinfo.mtime <= appinfo.mtime) continue;
                    appinfo = xappinfo;
                }
                if (null != appinfo && appinfo.mtime != SPSystemUtil.getAppPackTime(this.mContext) / 1000L) {
                    if (!TextUtils.isEmpty((CharSequence)appinfo.iconfile)) {
                        appinfo.iconfile = String.format(Locale.ENGLISH, "https://%s:%d%s", this.vpn_host, this.vpn_port, appinfo.iconfile);
                    }
                    if (!TextUtils.isEmpty((CharSequence)appinfo.appfile)) {
                        appinfo.appfile = String.format(Locale.ENGLISH, "https://%s:%d/fw/down.php?id=%d", this.vpn_host, this.vpn_port, appinfo.appid);
                    }
                    this.userdata.pkg_appinfo = appinfo;
                }
            }
            this.accomplish();
        } else if (0 != msgrsp.errcode) {
            this.fireError(msgrsp.errcode, msgrsp.errmsg);
            return;
        }
        if ("sac_get_portal".equals(msgrsp.msgid)) {
            this.portalInfo = SPPortalInfo.fromBrokerJSON(msgrsp.json);
            json = new JSONObject();
            if (this.portalInfo.vpnPortEx > 0) {
                this.vpn_port = this.portalInfo.vpnPortEx;
                PortalSession.setVpnAddress(this.vpn_host, this.vpn_port, this.vpn_host);
                SPJSONUtil.put(json, "ssl_smx_global", "1");
            } else {
                SPJSONUtil.put(json, "ssl_smx_global", "0");
            }
            SPJSONUtil.put(json, "ssl_smx_global_only", "1");
            SPLibBridge.exeCmdEx("sys_set_oem", json);
            this.mAuthChain.clear();
            if (this.portalInfo.authList.size() > 0) {
                SPAuthServerInfo auth = this.portalInfo.getAuthServerByName(this.record.auth_server);
                if (null == auth) {
                    auth = this.portalInfo.getAuthServerByName(this.pkgconfig.auth_server);
                }
                if (null == auth) {
                    auth = this.portalInfo.authList.get(0);
                }
                this.mAuthChain.add(auth);
                this.stage = 1;
                this.fireStageChanged(this.stage);
            } else {
                this.fireError(0x2000402, "\u65e0\u6548\u8ba4\u8bc1\u670d\u52a1\u5668");
            }
        } else if ("sac_get_userdata".equals(msgrsp.msgid)) {
            this.userdata = SPUserDataInfo.fromBrokerJSON(msgrsp.json);
            if (this.userdata.needsBind != 0 && !this.mHasBinded) {
                this.vpnPutHostBinddings();
                return;
            }
            json = SPJSONUtil.parseObject(this.pkgconfig.app_policy);
            this.userdata.policy.pkgappNCEnable = 0 != json.optInt("nc_enable", 0);
            this.userdata.policy.pkgappNotifyEnable = 0 != json.optInt("notify_enable", 0);
            this.userdata.policy.pkgappUpgrade = json.optInt("upgrade_policy", 0);
            if (this.mIsRepacked && this.userdata.policy.pkgappUpgrade != 0) {
                PLog.v("Check Update", new Object[0]);
                this.fireBusy(true, "\u68c0\u67e5APP\u66f4\u65b0");
                GatewayReq req = new GatewayReq("sac_app_list");
                req.ticket_str = this.userinfo.ticketstr;
                req.data.put("app_identify", TextUtils.isEmpty((CharSequence)this.pkgconfig.app_identify) ? this.mContext.getPackageName() : this.pkgconfig.app_identify);
                req.data.put("package_name", this.mContext.getPackageName());
                req.data.put("os", "Android");
                this.mPendingBroker = this.vpnRequest(req, this);
            } else {
                this.accomplish();
            }
        } else if ("sac_bind_host".equals(msgrsp.msgid)) {
            this.vpnGetUserdata();
        }
    }

    private void accomplish() {
        PortalSession session = PortalSession.instance(this.mContext);
        PortalSession.setVpnAddress(this.vpn_host, this.vpn_port, this.vpn_host, true, this.portalInfo.vpnIPFixed);
        session.username = this.userinfo.username;
        session.password = this.userinfo.password;
        this.userinfo.authsvr = session.authsvr = this.mAuthChain.get(0);
        session.setLogin(this.userinfo, this.mExtras);
        session.portalInfo = this.portalInfo;
        if (null != this.mLoginReq) {
            this.mLoginReq.ticket_str = this.userinfo.ticketstr;
        }
        session.loginBrokerReq = this.mLoginReq;
        this.stage = 10;
        session.setUserdata(this.userdata);
        if (SPSystemUtil.isRunInMainThread()) {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPAuthModel.this.fireStageChanged(SPAuthModel.this.stage);
                }
            }, 1000L);
        } else {
            SPSystemUtil.sleepEx(200L);
            this.fireStageChanged(this.stage);
        }
    }

    private void onBrokerAuthResponse(GatewayRsp msgrsp) {
        if (msgrsp.errcode != 0 && msgrsp.errcode != 33555497) {
            this.fireError(msgrsp.errcode, msgrsp.errmsg);
            return;
        }
        SPUserInfo uinfo = SPUserInfo.fromBrokerJSON(msgrsp.json);
        SPAuthServerInfo next = uinfo.authsvr;
        PLog.v("onBrokerAuthResponse next.sub_id=%d, nex.sub_type=%d", next.sub_id, next.sub_type);
        if ("sac_auth".equals(msgrsp.msgid)) {
            this.userinfo = uinfo;
            this.userinfo.password = msgrsp.callbackData.getStr("password");
            this.mTrack = new SPAuthRecord();
            this.mTrack.vpn_host = this.vpn_host;
            this.mTrack.vpn_port = this.vpn_port;
            this.mTrack.auth_server = this.mAuthChain.get((int)0).name;
            this.mTrack.auto_login = this.remember;
            this.mTrack.qrcode_flag = msgrsp.callbackData.getInt("qrcode_flag");
            this.mTrack.username = msgrsp.callbackData.getStr("username");
            this.mTrack.password = msgrsp.callbackData.getStr("password");
        } else if ("sac_auth_sub".equals(msgrsp.msgid)) {
            this.mTrack.second_authname = this.mAuthChain.get((int)1).name;
            this.mTrack.second_uname = msgrsp.callbackData.getStr("username");
        }
        if (0 == next.sub_id) {
            this.mHasBinded = false;
            this.vpnGetUserdata();
        } else if ("sac_auth".equals(msgrsp.msgid) && (9 == next.sub_type || 14 == next.sub_type || 12 == next.sub_type || 20 == next.sub_type || 16 == next.sub_type)) {
            this.mAuthChain.add(next);
            this.stage = 2;
            this.fireStageChanged(this.stage);
        } else {
            this.fireError(0xF0000E0, "\u7b2c\u4e8c\u6b65\u8ba4\u8bc1 \u53ea\u652f\u6301360ID\u53e3\u4ee4\u3001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u3001\u90ae\u7bb1\u9a8c\u8bc1\u7801");
        }
    }

    public void goBack() {
        if (this.stage == 1 || this.stage == 2) {
            this.stage = 0;
            this.mAuthChain.clear();
            this.fireStageChanged(this.stage);
        }
    }

    public void vpnAbort() {
        if (null != this.mPendingBroker) {
            this.mPendingBroker.abort();
            this.fireBusy(false, "");
        }
        this.mPendingBroker = null;
    }

    public void vpnConnect(String host, int port) {
        PLog.v("vpnConnect addr=%s:%d", host, port);
        this.reset();
        this.vpn_host = host;
        this.vpn_port = port;
        this.mAuthChain.clear();
        this.fireBusy(true, "\u8fde\u63a5\u670d\u52a1\u5668");
        final GatewayReq req = new GatewayReq("sac_get_portal");
        req.data.put("hostname", this.vpn_host);
        if (this.mFirstTime) {
            this.mFirstTime = false;
            new Thread(){

                @Override
                public void run() {
                    SPOEM.setOEMName(SPAuthModel.this.pkgconfig.oem_name, true);
                    SPAuthModel.this.mPendingBroker = SPAuthModel.this.vpnRequest(req, SPAuthModel.this);
                }
            }.start();
        } else {
            this.mFirstTime = false;
            this.mPendingBroker = this.vpnRequest(req, this);
        }
    }

    public void vpnAuth(final String _username, final String _password, final String _vcode, final SPLiteBundle extras) {
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPAuthModel.this.vpnAuth(_username, _password, _vcode, extras);
                }
            }.start();
            return;
        }
        String username = _username;
        String password = _password;
        String vcode = _vcode;
        SPAuthServerInfo authsvr = this.currentAuthServer();
        if (null == authsvr) {
            this.fireError(0x2000402, "\u65e0\u6548\u8ba4\u8bc1\u670d\u52a1\u5668");
            return;
        }
        this.fireBusy(true, "\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f");
        GatewayReq req = new GatewayReq(0, true){

            @Override
            protected void buildJSON(JSONObject json) {
                super.buildJSON(json);
                if ("sac_auth".equals(this.msgid)) {
                    JSONObject devjson = LoginReq.devInfo(null, extras);
                    if (SPOEM.isOEM_MPolicyZJ()) {
                        SPJSONUtil.put(devjson, "devid", SPDeviceUtil.getDevID_Enhanced(SPAuthModel.this.mContext));
                    }
                    SPJSONUtil.put(json, "device_info", devjson);
                }
            }
        };
        req.callbackData.put("username", username);
        req.callbackData.put("password", password);
        if (this.mAuthChain.size() > 1) {
            req.msgid = "sac_auth_sub";
        } else {
            this.mExtras = extras;
            req.msgid = "sac_auth";
            req.data.put(extras);
            this.mLoginReq = req;
        }
        req.data.put("ticket", null != this.userinfo ? this.userinfo.ticketstr : "");
        req.data.put("auth_id", String.valueOf(authsvr.id));
        req.data.put("auth_sub_id", String.valueOf(authsvr.sub_id));
        req.data.put("auth_sub_type", String.valueOf(authsvr.sub_type));
        req.data.put("auth_sub_uname", authsvr.sub_uname);
        if (authsvr.sub_type == 5) {
            StringBuilder certb64 = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)username)) {
                File cfile = new File(username);
                if (cfile.isFile() && cfile.canRead()) {
                    certb64.append(Base64.encodeToString((byte[])SPFileUtil.readFile(cfile.getAbsolutePath()), (int)2));
                } else {
                    certb64.append(username);
                }
            }
            req.data.put("username", certb64.toString());
            req.ssl_twoway = true;
            if (this.portalInfo.smxCertEnable) {
                req.ssl_smx = 2;
            }
        } else if (authsvr.sub_type == 13) {
            req.data.put("username", SPStringUtil.opt(authsvr.sub_uname));
        } else if (authsvr.sub_type == 19) {
            String pem = SPStringUtil.opt(username);
            String sign = SPStringUtil.opt(password);
            String pin = SPStringUtil.opt(vcode);
            req.data.put("auth_key_container", this.portalInfo.smxContainer);
            req.data.put("auth_key_app", this.portalInfo.smxApp);
            req.data.put("auth_key_pin", pin);
            if (pem.length() > 0 && sign.length() > 0) {
                req.data.put("auth_cert_base64", pem);
                req.data.put("auth_cert_sign", sign);
                if (this.portalInfo.smxCertEnable) {
                    req.data.put("auth_cert_type", "SM2_SM3_SM2_SKF");
                } else {
                    req.data.put("auth_cert_type", "SM2_SM3_SM2_OPENSSL");
                }
            } else {
                SPX509Info x509Info = SPVPNTool.getTFCertInfo(pin, this.portalInfo.smxApp, this.portalInfo.smxContainer);
                if (x509Info.notAfter > 0L) {
                    req.data.put("auth_cert_base64", Base64.encodeToString((byte[])x509Info.pem.getBytes(), (int)2));
                    req.data.put("auth_cert_sign", x509Info.signature);
                    req.data.put("auth_cert_type", "SM2_SM3_SM2_SKF");
                } else {
                    SPMsgRspEmpty krsp = SPVPNTool.getTFKeyCertSignImpl(pin, this.portalInfo.smxApp, this.portalInfo.smxContainer, pem);
                    if (0 != krsp.errcode) {
                        this.fireError(0xF0000F4, krsp.errmsg);
                        return;
                    }
                    req.data.put("auth_cert_base64", krsp.json.optString("pem"));
                    req.data.put("auth_cert_sign", krsp.json.optString("signature"));
                    req.data.put("auth_cert_type", "SM2_SM3_SM2_SKF");
                }
            }
            req.data.put("username", "");
            password = "";
        } else {
            if ((username = SPStringUtil.opt(username)).length() < 1) {
                username = SPStringUtil.opt(authsvr.sub_uname);
            }
            req.data.put("username", username);
            if (authsvr.sub_qrcode > 0 && !TextUtils.isEmpty((CharSequence)vcode)) {
                req.data.put("qrcode_flag", "1");
                req.data.put("qrcode_token", vcode);
            }
        }
        req.data.put("password", SPStringUtil.opt(password));
        req.data.put("verify_code", SPStringUtil.opt(vcode));
        req.data.put("app_oem", SPOEM.oemName());
        String pkgname = TextUtils.isEmpty((CharSequence)this.pkgconfig.app_identify) ? this.mContext.getPackageName() : this.pkgconfig.app_identify;
        req.data.put("app_identify", pkgname);
        req.data.put("app_pkgname", pkgname);
        try {
            PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(pkgname, 0);
            req.data.put("app_version", pInfo.versionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.callbackData.put("qrcode_flag", req.data.getStr("qrcode_flag"));
        this.mPendingBroker = this.vpnRequest(req, this);
    }

    public void vpnGetUserdata() {
        PLog.v("vpnGetUserdata", new Object[0]);
        this.fireBusy(true, "\u83b7\u53d6\u7528\u6237\u6570\u636e");
        GatewayReq req = new GatewayReq("sac_get_userdata");
        req.data.put("app_identify", TextUtils.isEmpty((CharSequence)this.pkgconfig.app_identify) ? this.mContext.getPackageName() : this.pkgconfig.app_identify);
        req.data.put("hostbinds", SPNetUtil.getWifiMac(this.mContext));
        req.data.put("username", this.userinfo.username);
        this.mPendingBroker = this.vpnRequest(req, this);
    }

    public void vpnPutHostBinddings() {
        PLog.v("vpnPutHostBinddings", new Object[0]);
        this.fireBusy(true, "\u7ed1\u5b9a\u8bbe\u5907\u4fe1\u606f");
        this.mHasBinded = true;
        GatewayReq req = new GatewayReq("sac_bind_host");
        req.data.put("hostbinds", SPNetUtil.getWifiMac(this.mContext));
        this.mPendingBroker = this.vpnRequest(req, this);
    }

    public GatewayBroker vpnRequest(GatewayReq req, GatewayBroker.BrokerCallback callback) {
        String string2 = req.ticket_str = null != this.userinfo ? this.userinfo.ticketstr : "";
        if (!"sac_get_portal".equals(req.msgid) && null != this.portalInfo && this.portalInfo.vpnIPFixed && SPIPUtil.isIPv4(this.portalInfo.vpnIPAddr)) {
            return GatewayBroker.request(req, this.portalInfo.vpnIPAddr, this.vpn_port, this.vpn_host, callback);
        }
        return GatewayBroker.request(req, this.vpn_host, this.vpn_port, this.vpn_host, callback);
    }

    public static interface OnAuthModelCallback {
        public void onAuthModelBusy(SPAuthModel var1, boolean var2, String var3);

        public void onAuthModelError(SPAuthModel var1, int var2, String var3);

        public void onAuthModelStageChanged(SPAuthModel var1, int var2);

        public void onAuthModelAuthChanged(SPAuthModel var1, SPAuthServerInfo var2);
    }
}

