/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.secure.PLog;
import com.secure.comm.utils.SPNetUtil;
import com.secure.sportal.sdk.app.SPNotifyManager;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.PortalSession;

public class SPTunnelService
extends Service {
    private static final int WHAT_FLASH_DNS = 1431923200;
    private static final int WHAT_HOOK_HELPER = 0x556E5655;
    private static final long TIMER_PERIOD = 60000L;
    private Looper mServiceLooper;
    private ServiceHandler mServiceHandler;

    public static void spStart(Context context) {
        try {
            PLog.v("Starting SPTunnelService", new Object[0]);
            Intent intent = new Intent(context, SPTunnelService.class);
            intent.putExtra("SP_LOGIN", true);
            context.startService(intent);
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
    }

    public void onCreate() {
        PLog.v("SPTunnelService.onCreate()", new Object[0]);
        HandlerThread thread = new HandlerThread("ServiceStartArguments", 10);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        PLog.v("SPTunnelService.onStartCommand(), pid=%d, flags=%d, startId=%d, intent=%s", Process.myPid(), flags, startId, null != intent ? intent.toString() : "{}");
        boolean login = false;
        try {
            login = intent.getBooleanExtra("SP_LOGIN", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!login) {
            PortalSession.restore((Context)this);
        }
        this.mServiceHandler.sendEmptyMessageDelayed(0x556E5655, 200L);
        this.mServiceHandler.sendEmptyMessageDelayed(1431923200, 1800L);
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        PLog.v("SPTunnelService.onTaskRemoved()", new Object[0]);
        SPNCServiceManagement.stopNC((Context)this);
        SPNotifyManager.showNotification((Context)this, false);
        super.onTaskRemoved(rootIntent);
    }

    public void onDestroy() {
        PLog.v("SPTunnelService.onDestroy()", new Object[0]);
        this.mServiceLooper.quit();
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0x556E5655) {
                SPTunnelService.this.mServiceHandler.removeMessages(0x556E5655);
                long delay = 2000L;
                delay = 60000L;
                SPTunnelService.this.mServiceHandler.sendEmptyMessageDelayed(0x556E5655, delay);
            } else if (msg.what == 1431923200) {
                SPTunnelService.this.mServiceHandler.removeMessages(1431923200);
                SPTunnelService.this.mServiceHandler.sendEmptyMessageDelayed(1431923200, 1800L);
                PortalSession session = PortalSession.instance((Context)SPTunnelService.this);
                if (session.isLogin()) {
                    session.flushIPHost();
                    SPNetUtil.isNetworkAvailable((Context)SPTunnelService.this);
                }
            }
        }
    }
}

