/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.net.SPHttpDownloadPopup;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.view.SPPopupClosedListener;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.comm.view.SPPopupWaiting;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.gateway.GatewayAgentAppstore;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.service.PortalSession;
import java.util.List;

public class SPSecAppUpdater {
    public static void check(Context context, String app_identify) {
        CheckTask task = new CheckTask();
        task.context = context;
        task.appID = app_identify;
        task.execute(new String[0]);
    }

    private static class CheckTask
    extends AsyncTask<String, String, SPAppInfo> {
        private Context context;
        private String appID;
        private SPPopupWaiting waiting;

        private CheckTask() {
        }

        protected SPAppInfo doInBackground(String ... params) {
            List appList;
            String vpn_host = PortalSession.vpnHost();
            int vpn_port = PortalSession.vpnPort();
            String ticket = PortalSession.instance((Context)this.context).me().ticketstr;
            String pkgname = SPApplication.getPkgName(this.context);
            GatewayRsp rsp = GatewayAgentAppstore.queryAppList(vpn_host, vpn_port, ticket, pkgname, this.appID);
            if (rsp.errcode == 0 && !(appList = (List)rsp.getData()).isEmpty()) {
                SPAppInfo app = (SPAppInfo)appList.get(0);
                long apktime = SPSystemUtil.getAppPackTime(this.context) / 1000L;
                PLog.v("Check Update: local_time=" + apktime + ", store_time=" + app.mtime, new Object[0]);
                if (pkgname.equals(app.pkgname) && apktime != app.mtime) {
                    return app;
                }
            }
            return null;
        }

        protected void onPreExecute() {
            this.waiting = SPPopupWaiting.popup(this.context, "\u6b63\u5728\u68c0\u67e5\u66f4\u65b0\uff0c\u8bf7\u7a0d\u5019", null, null);
            super.onPreExecute();
        }

        protected void onPostExecute(final SPAppInfo result) {
            this.waiting.close(-1);
            if (null != result) {
                SPPopupMsgBox.msgbox(this.context, "\u53d1\u73b0\u66f4\u65b0 " + result.title, result.comment, new SPPopupClosedListener(){

                    @Override
                    public void onDismissPositive(DialogInterface dialog) {
                        super.onDismissPositive(dialog);
                        String apkfile = SPFileUtil.getSdCardPath() + "/secdownloads/" + SPApplication.getPkgName(CheckTask.this.context) + ".apk";
                        SPHttpDownloadPopup.download(CheckTask.this.context, result.appfile, apkfile, true, null);
                    }
                }, "\u4e0b\u8f7d\u5e76\u66f4\u65b0", "\u653e\u5f03", null);
            } else {
                SPPopupMsgBox.popup(this.context, "\u63d0\u793a", "\u6ca1\u6709\u66f4\u65b0");
            }
            super.onPostExecute((Object)result);
        }
    }
}

