/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import com.secure.comm.app.SPResourseKit;
import com.secure.sportal.sdk.app.SPNotificationActivity;
import com.secure.sportal.service.PortalSession;

public class SPNotifyManager {
    public static void showNotification(Context context, boolean visible) {
        context = context.getApplicationContext();
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        int nid = SPResourseKit.getResId(context, "layout", "sportal_activity_notification");
        if (visible) {
            PortalSession session = PortalSession.instance(context.getApplicationContext());
            if (session.userdata().policy.pkgappNotifyEnable) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setClass(context, SPNotificationActivity.class);
                int flags = 0x10200000;
                flags = Build.VERSION.SDK_INT < 21 ? (flags |= 0x24000000) : (flags |= 0x80000);
                intent.setFlags(flags);
                PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
                SPNotifyManager.notifyMsg(context, nm, nid, contentIntent);
            }
        } else {
            nm.cancel(nid);
        }
    }

    private SPNotifyManager() {
    }

    private static void notifyMsg(Context context, NotificationManager nm, int nid, PendingIntent contentIntent) {
        try {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
            builder.setContentTitle((CharSequence)"\u5df2\u542f\u7528\u5b89\u5168\u8fde\u63a5").setContentText((CharSequence)"\u70b9\u51fb\u8fdb\u5165\u914d\u7f6e\u754c\u9762");
            builder.setSmallIcon(SPResourseKit.getResId(context, "drawable", "sportal_ic_notify"));
            builder.setLargeIcon(SPResourseKit.getBitmap(context, "sportal_ic_notify"));
            builder.setWhen(System.currentTimeMillis()).setAutoCancel(false);
            builder.setContentIntent(contentIntent);
            nm.notify(nid, builder.build());
        }
        catch (Throwable ex) {
            Notification.Builder builder = new Notification.Builder(context);
            builder.setContentTitle((CharSequence)"\u5df2\u542f\u7528\u5b89\u5168\u8fde\u63a5").setContentText((CharSequence)"\u70b9\u51fb\u8fdb\u5165\u914d\u7f6e\u754c\u9762");
            builder.setSmallIcon(SPResourseKit.getResId(context, "drawable", "sportal_ic_notify"));
            builder.setLargeIcon(SPResourseKit.getBitmap(context, "sportal_ic_notify"));
            builder.setWhen(System.currentTimeMillis()).setAutoCancel(false);
            builder.setContentIntent(contentIntent);
            nm.notify(nid, builder.getNotification());
        }
    }
}

