/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPViewUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.sdk.LibSecIDSDKLite;
import com.secure.sportal.sdk.app.SPLoginPageHolder;
import com.secure.sportal.sdk.auth.SPAuthViewKit;

public class SPLoginPageVerify
extends SPLoginPageHolder
implements GatewayBroker.BrokerCallback {
    private View mTargetPane;
    private ImageView mTargetImage;
    private EditText mTargetText;
    private EditText mCodeText;
    private TextView mRequestBtn;
    private TextView mSecTokenBtn;
    private View mBackBtn;
    private GatewayBroker mPendingTask;
    private Runnable mTimerTask;
    private long mCodeMS;

    @Override
    public int index() {
        return 2;
    }

    @Override
    protected String layoutResName(Context context) {
        return "sportal_page_login_valid";
    }

    @Override
    protected void onInflatedView() {
        this.mTargetPane = this.findSubView("sportal_login_pane_target");
        this.mTargetImage = (ImageView)this.findSubView("sportal_login_img_target");
        this.mTargetText = (EditText)this.findSubView("sportal_login_edit_target");
        this.mCodeText = (EditText)this.findSubView("sportal_login_edit_code");
        this.mRequestBtn = (TextView)this.findSubView("sportal_login_btn_request");
        this.mSecTokenBtn = (TextView)this.findSubView("sportal_login_btn_secid");
        this.mSubmitBtn = (Button)this.findSubView("sportal_login_btn_validate");
        this.mBackBtn = this.findSubView("sportal_login_img_back");
        this.mSecIDUnameText = this.mTargetText;
        this.mSecIDTokenText = this.mCodeText;
        SPViewUtil.disableAutoKB((Context)this.mActivity, (View)this.mCodeText);
        this.mRequestBtn.setOnClickListener((View.OnClickListener)this);
        this.mSecTokenBtn.setOnClickListener((View.OnClickListener)this);
        this.mSubmitBtn.setOnClickListener((View.OnClickListener)this);
        this.mBackBtn.setOnClickListener((View.OnClickListener)this);
        this.mRequestBtn.setVisibility(0);
        this.mSecTokenBtn.setVisibility(8);
    }

    @Override
    public void onClick(View v) {
        if (v == this.mSubmitBtn) {
            String uname = this.mAuthModel.currentAuthServer().sub_type == 16 ? this.mTargetText.getText().toString().trim() : "";
            this.mAuthModel.vpnAuth(uname, "", this.mCodeText.getText().toString(), null);
        } else if (v == this.mRequestBtn) {
            String target = SPStringUtil.opt(this.mTargetText.getText().toString());
            if (target.length() > 0) {
                this.mRequestBtn.setEnabled(false);
                this.vpnRequestVerifyCode(target);
            }
        } else if (v == this.mSecTokenBtn) {
            LibSecIDSDKLite.generateToken(this.mActivity, "", 443, "", true);
        } else if (v == this.mBackBtn) {
            this.mAuthModel.goBack();
        }
    }

    @Override
    public void setPageActived(boolean active) {
        if (active) {
            SPAuthServerInfo authsvr = this.mAuthModel.currentAuthServer();
            if (authsvr.sub_type == 9) {
                this.mTargetPane.setVisibility(0);
                this.mTargetText.setText((CharSequence)authsvr.vcode_target);
                this.mTargetText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
                this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u77ed\u4fe1\u9a8c\u8bc1\u7801");
                SPViewUtil.setTextReadonly((TextView)this.mTargetText, !TextUtils.isEmpty((CharSequence)authsvr.vcode_target));
                this.mTargetImage.setImageLevel(1);
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPLoginPageVerify.this.onClick((View)SPLoginPageVerify.this.mRequestBtn);
                    }
                }, 100L);
            } else if (authsvr.sub_type == 14) {
                this.mTargetPane.setVisibility(0);
                this.mTargetText.setText((CharSequence)authsvr.vcode_target);
                this.mTargetText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u7535\u5b50\u90ae\u4ef6\u5730\u5740");
                this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u7801");
                SPViewUtil.setTextReadonly((TextView)this.mTargetText, !TextUtils.isEmpty((CharSequence)authsvr.vcode_target));
                this.mTargetImage.setImageLevel(2);
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPLoginPageVerify.this.onClick((View)SPLoginPageVerify.this.mRequestBtn);
                    }
                }, 100L);
            } else if (authsvr.sub_type == 16) {
                if (authsvr.sub_token == 1) {
                    this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u5bc6\u7801+360ID\u52a8\u6001\u53e3\u4ee4");
                } else if (authsvr.sub_token == 2) {
                    this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u524d\u7f00+360ID\u52a8\u6001\u53e3\u4ee4");
                } else {
                    this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165360ID\u52a8\u6001\u53e3\u4ee4");
                }
                this.mTargetText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u7528\u6237\u540d");
                this.mTargetText.setText((CharSequence)this.mAuthModel.getUsername());
                this.mTargetImage.setImageLevel(0);
                this.mRequestBtn.setVisibility(4);
                this.mSecTokenBtn.setVisibility(0);
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPLoginPageVerify.this.onClick((View)SPLoginPageVerify.this.mSecTokenBtn);
                    }
                }, 100L);
            } else {
                this.mCodeText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u52a8\u6001\u53e3\u4ee4");
                this.mTargetPane.setVisibility(4);
            }
        } else {
            this.mAuthModel.fireBusy(false, "");
            if (null != this.mPendingTask) {
                this.mPendingTask.abort();
            }
            this.mPendingTask = null;
            SPIntentUtil.removeMainCallbacks(this.mTimerTask);
            this.mTimerTask = null;
        }
    }

    @Override
    public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
        this.mPendingTask = null;
        this.mAuthModel.fireBusy(false, "");
        if ("sac_code_send".equals(msgrsp.msgid)) {
            if (0 == msgrsp.errcode) {
                Toast.makeText((Context)this.mActivity, (CharSequence)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u67e5\u6536\u3002", (int)0).show();
                this.sheduleTimerTask();
            } else {
                this.mRequestBtn.setEnabled(true);
                SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25: " + (TextUtils.isEmpty((CharSequence)msgrsp.errmsg) ? GatewayErrorText.getErrMsg(msgrsp.errcode) : msgrsp.errmsg));
            }
        }
    }

    private void vpnRequestVerifyCode(String target) {
        this.mAuthModel.fireBusy(true, "\u8bf7\u6c42\u9a8c\u8bc1\u7801");
        GatewayReq req = new GatewayReq("sac_code_send");
        if (this.mAuthModel.currentAuthServer().sub_type == 9) {
            req.data.put("code_type", "sms");
        } else if (this.mAuthModel.currentAuthServer().sub_type == 14) {
            req.data.put("code_type", "email");
        } else {
            return;
        }
        req.data.put("code_target", target);
        this.mPendingTask = this.mAuthModel.vpnRequest(req, this);
    }

    private void sheduleTimerTask() {
        this.mCodeMS = System.currentTimeMillis();
        if (null == this.mTimerTask) {
            this.mTimerTask = new Runnable(){

                @Override
                public void run() {
                    long sec = (System.currentTimeMillis() - SPLoginPageVerify.this.mCodeMS) / 1000L;
                    if (sec < 60L) {
                        SPLoginPageVerify.this.mRequestBtn.setText((CharSequence)String.valueOf(60L - sec));
                        SPIntentUtil.runOnMainThread(this, 1000L);
                    } else {
                        SPLoginPageVerify.this.mRequestBtn.setText((CharSequence)"\u53d1\u9001");
                        SPLoginPageVerify.this.mRequestBtn.setEnabled(true);
                    }
                }
            };
        }
        SPIntentUtil.runOnMainThread(this.mTimerTask, 1L);
    }
}

