/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.ViewFlipper;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopupChoice;
import com.secure.sportal.entry.SPAuthQRCodeInfo;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.sdk.LibSecIDSDKLite;
import com.secure.sportal.sdk.app.SPLoginPageHolder;
import com.secure.sportal.sdk.auth.SPAuthModel;
import com.secure.sportal.sdk.auth.SPAuthViewKit;
import java.io.File;

public class SPLoginPageAuth
extends SPLoginPageHolder
implements GatewayBroker.BrokerCallback {
    private ViewFlipper mModeFlipper;
    private View mAuthsvrPane;
    private TextView mAuthsvrText;
    private View mAuthsvrMoreView;
    private TextView mCertfileText;
    private EditText mUnameText;
    private View mUnameMoreView;
    private EditText mPasswText;
    private ImageView mPasswmaskImage;
    private TextView mSecTokenBtn;
    private CheckBox mRememberCKBox;
    private View mSecidBtn;
    private TextView mModeText;
    private ImageView mModeImage;
    private View mBackBtn;
    private SPAuthQRCodeInfo qrcode = null;
    private long qrtime = 0L;
    private GatewayBroker mQRCodeTask = null;

    @Override
    public int index() {
        return 1;
    }

    @Override
    protected String layoutResName(Context context) {
        return "sportal_page_login_auth";
    }

    @Override
    protected void onInflatedView() {
        this.mModeFlipper = (ViewFlipper)this.findSubView("sportal_login_flipper_mode");
        this.mAuthsvrPane = this.findSubView("sportal_login_pane_authsvr");
        this.mAuthsvrText = (TextView)this.findSubView("sportal_login_txt_authsvr");
        this.mAuthsvrMoreView = this.findSubView("sportal_login_ic_authsvr_more");
        this.mCertfileText = (TextView)this.findSubView("sportal_login_txt_certfile");
        this.mUnameMoreView = this.findSubView("sportal_login_ic_uname_more");
        this.mUnameText = (EditText)this.findSubView("sportal_login_edit_username");
        this.mPasswText = (EditText)this.findSubView("sportal_login_edit_password");
        this.mPasswmaskImage = (ImageView)this.findSubView("sportal_login_img_passmask");
        this.mSecTokenBtn = (TextView)this.findSubView("sportal_login_btn_secid");
        this.mRememberCKBox = (CheckBox)this.findSubView("sportal_login_chk_autologin");
        this.mSubmitBtn = (Button)this.findSubView("sportal_login_btn_login");
        this.mSecidBtn = this.findSubView("sportal_login_img_mode_qrcode");
        this.mModeText = (TextView)this.findSubView("sportal_login_txt_mode");
        this.mModeImage = (ImageView)this.findSubView("sportal_login_img_mode_ic");
        this.mBackBtn = this.findSubView("sportal_login_img_back");
        this.mSecIDTokenText = this.mPasswText;
        SPViewUtil.disableAutoKB((Context)this.mActivity, (View)this.mUnameText);
        this.mBackBtn.setVisibility(4);
        this.mAuthsvrText.setOnClickListener((View.OnClickListener)this);
        this.mCertfileText.setOnClickListener((View.OnClickListener)this);
        this.mPasswmaskImage.setOnClickListener((View.OnClickListener)this);
        this.mSubmitBtn.setOnClickListener((View.OnClickListener)this);
        this.mSecidBtn.setOnClickListener((View.OnClickListener)this);
        this.mModeText.setOnClickListener((View.OnClickListener)this);
        this.mModeImage.setOnClickListener((View.OnClickListener)this);
        this.mBackBtn.setOnClickListener((View.OnClickListener)this);
        this.mSecTokenBtn.setOnClickListener((View.OnClickListener)this);
        this.mModeImage.setVisibility(4);
        this.mModeText.setVisibility(4);
    }

    @Override
    public void setBusy(boolean busy) {
        super.setBusy(busy);
        this.mSubmitBtn.setEnabled(!busy);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 36023) {
            this.setPageActived(false);
            this.qrtime = System.currentTimeMillis();
            int errcode = 0;
            try {
                errcode = data.getIntExtra("secid_errcode", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (0 == errcode) {
                this.qrcodeCheck();
            }
            return true;
        }
        return super.onActivityResult(requestCode, resultCode, data);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View v) {
        if (v == this.mSubmitBtn) {
            String uname;
            block15: {
                this.mAuthModel.remember = this.mRememberCKBox.isChecked();
                SPAuthServerInfo authsvr = this.mAuthModel.currentAuthServer();
                uname = null;
                if (authsvr.sub_type == 5) {
                    File cfile = new File(this.mCertfileText.getText().toString());
                    if (cfile.exists() && cfile.length() < 10240L) {
                        uname = cfile.getAbsolutePath();
                        break block15;
                    } else {
                        if (null != SPFileUtil.getExtSdCardPath((Context)this.mActivity) && this.mAuthModel.portalInfo.smxCertEnable) {
                            SPAuthViewKit.verifySdcardPin(this.mActivity, "", this.mAuthModel.portalInfo.smxAlgCipher, this.mAuthModel.portalInfo.smxContainer, this.mAuthModel.portalInfo.smxApp, new SPRunnable<String>(){

                                @Override
                                public void run() {
                                    SPLoginPageAuth.this.mAuthModel.vpnAuth("", "", null, null);
                                }
                            });
                            return;
                        }
                        SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u8bc1\u4e66\u6587\u4ef6");
                        return;
                    }
                }
                if (TextUtils.isEmpty((CharSequence)this.mUnameText.getText().toString())) {
                    SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u540d");
                    return;
                }
                uname = this.mUnameText.getText().toString();
            }
            this.mAuthModel.vpnAuth(uname, this.mPasswText.getText().toString(), null, null);
            return;
        }
        if (v == this.mAuthsvrText) {
            if (this.mAuthModel.portalInfo.authList.size() <= 1) return;
            CharSequence[] authNames = new String[this.mAuthModel.portalInfo.authList.size()];
            int selected = 0;
            int i = 0;
            while (true) {
                if (i >= this.mAuthModel.portalInfo.authList.size()) {
                    SPPopupChoice.singleChoice((Context)this.mActivity, "\u6307\u5b9a\u8ba4\u8bc1\u670d\u52a1\u5668", authNames, selected, new SPPopupChoice.SPChoiceCallback(){

                        @Override
                        public void OnPopupChoicedIndex(int index, CharSequence item) {
                            SPLoginPageAuth.this.mAuthModel.setAuthServer(index);
                        }
                    });
                    return;
                }
                authNames[i] = this.mAuthModel.portalInfo.authList.get((int)i).name;
                if (((String)authNames[i]).equals(this.mAuthsvrText.getText())) {
                    selected = i;
                }
                ++i;
            }
        }
        if (v == this.mSecidBtn) {
            this.qrcodeGet();
            return;
        }
        if (v == this.mModeText || v == this.mModeImage) {
            this.onAuthViewFliped(0 == this.mModeFlipper.getDisplayedChild());
            return;
        }
        if (v == this.mBackBtn) {
            this.mAuthModel.goBack();
            return;
        }
        if (v == this.mPasswmaskImage) {
            this.setPasswordMask(this.mPasswmaskImage.isSelected());
            return;
        }
        if (v == this.mCertfileText) {
            SPPopupChoice.choiceFile((Context)this.mActivity, new String[]{".pfx", ".p12", ".pem"}, new SPPopupChoice.SPChoiceCallback(){

                @Override
                public void OnPopupChoicedIndex(int index, CharSequence item) {
                    SPLoginPageAuth.this.mCertfileText.setText(item);
                }
            });
            return;
        }
        if (v != this.mSecTokenBtn) return;
        LibSecIDSDKLite.generateToken(this.mActivity, "", 443, "", true);
    }

    @Override
    public void onAuthModelAuthChanged(SPAuthModel model, SPAuthServerInfo authsvr) {
        this.mAuthsvrText.setText((CharSequence)authsvr.name);
        this.mUnameText.setVisibility(0);
        this.mUnameMoreView.setVisibility(4);
        this.mCertfileText.setVisibility(4);
        this.mModeImage.setVisibility(4);
        this.mModeText.setVisibility(4);
        this.mSecTokenBtn.setVisibility(8);
        this.mPasswmaskImage.setSelected(true);
        this.mPasswmaskImage.setVisibility(0);
        boolean mask = true;
        this.onAuthViewFliped(authsvr.sub_qrcode > 0 && (authsvr.sub_qrcode > 1 || this.mAuthModel.qrcode_state));
        if (authsvr.sub_type == 5) {
            this.mUnameText.setVisibility(4);
            this.mUnameMoreView.setVisibility(0);
            this.mCertfileText.setVisibility(0);
            this.mCertfileText.setText((CharSequence)this.mAuthModel.getUsername());
            this.mCertfileText.setHint((CharSequence)"\u8bf7\u5355\u51fb\u9009\u62e9\u8bc1\u4e66\u6587\u4ef6");
            this.mPasswText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u8bc1\u4e66\u5bc6\u7801");
        } else if (authsvr.sub_type == 16) {
            if (authsvr.sub_token == 1) {
                this.mPasswText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u5bc6\u7801+360ID\u52a8\u6001\u53e3\u4ee4");
            } else if (authsvr.sub_token == 2) {
                this.mPasswText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u524d\u7f00+360ID\u52a8\u6001\u53e3\u4ee4");
            } else {
                this.mPasswText.setHint((CharSequence)"\u8bf7\u8f93\u5165360ID\u52a8\u6001\u53e3\u4ee4");
            }
            mask = false;
            this.mSecTokenBtn.setVisibility(0);
            this.mPasswmaskImage.setVisibility(4);
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    SPLoginPageAuth.this.onClick((View)SPLoginPageAuth.this.mSecTokenBtn);
                }
            }, 50L);
        } else {
            this.mUnameText.setText((CharSequence)this.mAuthModel.getUsername());
            this.mModeImage.setVisibility(authsvr.sub_qrcode > 0 ? 0 : 4);
            this.mModeText.setVisibility(authsvr.sub_qrcode > 0 ? 0 : 4);
            this.mPasswText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
        }
        this.setPasswordMask(mask);
        this.mPasswText.setText((CharSequence)this.mAuthModel.getPassword());
    }

    private void setPasswordMask(boolean mask) {
        this.mPasswmaskImage.setSelected(!mask);
        int type = mask ? 129 : 145;
        this.mPasswText.setInputType(type);
        this.mPasswText.setSelection(this.mPasswText.getText().length());
    }

    private void onAuthViewFliped(boolean secid) {
        this.mAuthModel.qrcode_state = secid;
        this.mModeFlipper.setDisplayedChild(secid ? 1 : 0);
        this.mModeImage.setSelected(!secid);
        this.mModeText.setText((CharSequence)(!secid ? "360ID\u5feb\u901f\u767b\u5f55" : "\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55"));
    }

    @Override
    public void setPageActived(boolean active) {
        if (active) {
            SPAuthServerInfo authsvr = this.mAuthModel.currentAuthServer();
            this.mAuthsvrText.setText((CharSequence)authsvr.name);
            this.mAuthsvrMoreView.setVisibility(this.mAuthModel.portalInfo.authList.size() > 1 ? 0 : 8);
            if (this.mAuthModel.portalInfo.showAuthen == 2 || this.mAuthModel.portalInfo.showAuthen == 0 && this.mAuthModel.portalInfo.authList.size() == 1) {
                this.mAuthsvrPane.setVisibility(4);
            }
            this.onAuthModelAuthChanged(null, authsvr);
            if (this.mAuthModel.pkgconfig.auth_autologin || this.mAuthModel.record.auto_login) {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPLoginPageAuth.this.onClick((View)SPLoginPageAuth.this.mSubmitBtn);
                    }
                }, 100L);
            }
        } else {
            this.mAuthModel.fireBusy(false, "");
            if (null != this.mQRCodeTask) {
                this.mQRCodeTask.abort();
            }
            this.mQRCodeTask = null;
            this.qrtime = 0L;
        }
    }

    private void qrcodeGet() {
        this.qrcode = null;
        GatewayReq req = new GatewayReq("sac_qrcode_get");
        req.data.put("auth_sub_id", String.valueOf(this.mAuthModel.currentAuthServer().sub_id));
        this.mQRCodeTask = this.mAuthModel.vpnRequest(req, this);
    }

    private void qrcodeCheck() {
        if (this.qrtime > 0L) {
            GatewayReq req = new GatewayReq("sac_qrcode_check");
            req.data.put("auth_sub_id", String.valueOf(this.mAuthModel.currentAuthServer().sub_id));
            req.data.put("token", this.qrcode.token);
            this.mQRCodeTask = this.mAuthModel.vpnRequest(req, this);
        }
    }

    @Override
    public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
        this.mQRCodeTask = null;
        if (0 != msgrsp.errcode) {
            SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "360ID\u5feb\u901f\u8ba4\u8bc1\u5931\u8d25: " + (TextUtils.isEmpty((CharSequence)msgrsp.errmsg) ? GatewayErrorText.getErrMsg(msgrsp.errcode) : msgrsp.errmsg));
        } else if ("sac_qrcode_get".equals(msgrsp.msgid)) {
            this.qrcode = new SPAuthQRCodeInfo();
            this.qrcode.parse(msgrsp.json);
            if (this.qrcode.status == 200) {
                LibSecIDSDKLite.authorizeApp(this.mActivity, "", 443, "", this.qrcode.qrcode_data, "", "");
            } else {
                SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "360ID\u5feb\u901f\u8ba4\u8bc1\u5931\u8d25: " + this.qrcode.message);
            }
        } else if ("sac_qrcode_check".equals(msgrsp.msgid) && null != this.qrcode) {
            SPAuthQRCodeInfo restrsp = new SPAuthQRCodeInfo();
            restrsp.parse(msgrsp.json);
            this.qrcode.uid = restrsp.uid;
            if (restrsp.status == 200) {
                this.mAuthModel.vpnAuth(this.qrcode.uid, "", this.qrcode.token, null);
            } else if (restrsp.status == 405) {
                if (System.currentTimeMillis() - this.qrtime > 60000L) {
                    SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "SecID\u5feb\u901f\u8ba4\u8bc1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
                } else {
                    SPIntentUtil.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            SPLoginPageAuth.this.qrcodeCheck();
                        }
                    }, 1000L);
                }
            } else {
                SPAuthViewKit.showMsgBox(this.mActivity, "\u63d0\u793a", "360ID\u5feb\u901f\u8ba4\u8bc1\u5931\u8d25: " + restrsp.message);
            }
        }
    }
}

