/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.VpnService;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPResourseKit;
import com.secure.comm.net.SPHttpDownloadPopup;
import com.secure.comm.utils.SPErrorHandler;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPMetaDataUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopupClosedListener;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.sdk.app.SPNotifyManager;
import com.secure.sportal.sdk.app.SPTunnelService;
import com.secure.sportal.sdk.auth.SPAuthViewKit;
import com.secure.sportal.sdk.gesture.SPGestureControl;
import com.secure.sportal.sdk.gesture.SPGestureHolder;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.PortalSession;
import java.util.ArrayList;
import java.util.List;

public class SPLoginBaseActivity
extends Activity {
    protected String mMainClsName = null;
    protected List<Runnable> mPostLoginTasks = new ArrayList<Runnable>();

    public static void initSecurePortal(Context context) {
        SPLibBridge.initLibrary(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.isTaskRoot()) {
            Log.e((String)"sportal", (String)"SPLoginActivity isTaskRoot() equals FALSE!");
            this.finish();
            return;
        }
        if (!(this.getApplication() instanceof SPApplication)) {
            SPApplication.spInitApp(this.getApplication());
        }
        SPLoginBaseActivity.initSecurePortal(this.getApplicationContext());
        if (!SPLibBridge.isDebug()) {
            Thread.setDefaultUncaughtExceptionHandler(SPErrorHandler.instance());
        }
        GatewayErrorText.withErrorCode = false;
        this.mMainClsName = SPMetaDataUtil.readActivityValue(this, "sp_activity", null);
        SPIntentUtil.requestPermission(this, new String[]{"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, 0);
        this.setTheme(SPResourseKit.getResId((Context)this, "style", "SPortalAppTheme"));
        this.requestWindowFeature(1);
        this.setRequestedOrientation(7);
        int mode = 16;
        if (Build.VERSION.SDK_INT < 23) {
            mode |= 2;
        }
        this.getWindow().setSoftInputMode(mode);
        SPTunnelService.spStart((Context)this);
    }

    protected void optimizeBannerView(final View rootView, final ImageView topBanner) {
        Point ssize = SPViewUtil.screenSize((Context)this);
        ViewGroup.LayoutParams lp = topBanner.getLayoutParams();
        lp.width = Math.min(ssize.x, ssize.y);
        lp.height = lp.width * 5 / 8;
        topBanner.setScaleType(ImageView.ScaleType.FIT_XY);
        topBanner.setLayoutParams(lp);
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                rootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = rootView.getRootView().getHeight();
                int keypadHeight = screenHeight - r.bottom;
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)topBanner.getLayoutParams();
                lp.topMargin = (double)keypadHeight > (double)screenHeight * 0.15 ? (int)SPViewUtil.dp2px(SPLoginBaseActivity.this.getApplicationContext(), 48.0f) - lp.height : 0;
                topBanner.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 36010) {
            if (resultCode == -1) {
                SPNCServiceManagement.startOrStopNC((Context)this, true, true, true);
                this.postRunLoginTasks();
            } else {
                PLog.i("SPLoginBaseActivity.onActivityResult(NCRequest) resultCode=%d (OK:-1, CANCELED:0)", resultCode);
                SPAuthViewKit.showMsgBox(this, "\u63d0\u793a", "\u542f\u52a8 NC \u96a7\u9053\u5931\u8d25");
                new Thread(){

                    @Override
                    public void run() {
                        SPVPNTool.setLogFlush();
                    }
                }.start();
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void startNC() {
        Intent intent = VpnService.prepare((Context)this.getApplicationContext());
        if (intent != null) {
            this.startActivityForResult(intent, 36010);
        } else {
            this.onActivityResult(36010, -1, null);
        }
    }

    protected void updateAppSelf(final SPUserDataInfo userdata, final Bundle extras, final Runnable leaver) {
        final Runnable failure = new Runnable(){

            @Override
            public void run() {
                SPLoginBaseActivity.this.onBackPressed();
                SPLoginBaseActivity.this.finish();
            }
        };
        if (userdata.policy.pkgappUpgrade == 1) {
            SPHttpDownloadPopup.download((Context)this, userdata.pkg_appinfo.appfile, null, true, failure);
            return;
        }
        if (userdata.policy.pkgappUpgrade == 2) {
            SPPopupMsgBox.msgbox((Context)this, "\u5e94\u7528\u6709\u66f4\u65b0", "\u662f\u5426\u4e0b\u8f7d\u5e76\u5347\u7ea7\uff1f", new SPPopupClosedListener(){

                @Override
                public void onDismissPositive(DialogInterface dialog) {
                    SPHttpDownloadPopup.download((Context)SPLoginBaseActivity.this, userdata.pkg_appinfo.appfile, null, true, failure);
                }

                @Override
                public void onDismissNegative(DialogInterface dialog) {
                    SPLoginBaseActivity.this.commitLogin(PortalSession.instance((Context)SPLoginBaseActivity.this).userdata(), extras, leaver);
                }
            }, "\u7acb\u5373\u5347\u7ea7", "\u4e0b\u6b21\u518d\u8bf4", null);
            return;
        }
        this.commitLogin(userdata, extras, leaver);
    }

    protected void commitLogin(SPUserDataInfo userdata, final Bundle extras, final Runnable leaver) {
        if (userdata.policy.gestureExpires > 0) {
            this.mPostLoginTasks.add(new SPRunnable<SPUserDataInfo>(userdata){

                @Override
                public void run() {
                    SPLoginBaseActivity.this.gestureValidate((SPUserDataInfo)this.mUserObject);
                }
            });
        }
        if (userdata.policy.pkgappNCEnable && userdata.ncSvcList.size() > 0) {
            this.mPostLoginTasks.add(new Runnable(){

                @Override
                public void run() {
                    SPLoginBaseActivity.this.startNC();
                }
            });
        }
        this.mPostLoginTasks.add(new SPRunnable<SPUserDataInfo>(userdata){

            @Override
            public void run() {
                if (((SPUserDataInfo)this.getUserObject()).policy.pkgappNotifyEnable) {
                    SPNotifyManager.showNotification(SPLoginBaseActivity.this.getApplicationContext(), true);
                }
                if (null != leaver) {
                    leaver.run();
                }
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPLoginBaseActivity.this.jumpToAppPage(extras);
                    }
                }, 200L);
            }
        });
        this.postRunLoginTasks();
    }

    protected void postRunLoginTasks() {
        if (!this.mPostLoginTasks.isEmpty()) {
            Runnable runnable = this.mPostLoginTasks.remove(0);
            this.runOnUiThread(runnable);
        }
    }

    protected void gestureValidate(SPUserDataInfo userdata) {
        SPGestureControl.startVerify(this, PortalSession.instance((Context)this).me().uid, userdata.policy.gestureExpires, userdata.policy.gestureLogin, new SPGestureHolder.OnSPGestureCallback(){

            @Override
            public void OnGestureClose(int result) {
                SPLoginBaseActivity.this.postRunLoginTasks();
            }
        });
    }

    protected void jumpToAppPage(Bundle extras) {
        PLog.v("SPLoginBaseActivity.jumpToAppPage %s", this.mMainClsName);
        try {
            Intent intent = new Intent((Context)this, Class.forName(this.mMainClsName));
            int flags = intent.getFlags();
            String pkgname = this.getPackageName();
            flags |= 0x4000;
            if (!pkgname.startsWith("com.epoint.mobileframe.")) {
                flags |= 0x8000;
                flags |= 0x10000000;
            }
            intent.setFlags(flags);
            if (null != extras) {
                if (null != this.getIntent() && null != this.getIntent().getExtras()) {
                    Bundle data = this.getIntent().getExtras();
                    data.putAll(extras);
                    intent.putExtras(data);
                } else {
                    intent.putExtras(extras);
                }
            }
            this.startActivity(intent);
            this.finish();
        }
        catch (Exception ex) {
            PLog.e("Failed to load main activity", ex);
        }
    }
}

