/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.secure.PLog;
import com.secure.comm.app.SPResourseKit;
import com.secure.comm.view.SPPopupClosedListener;
import com.secure.comm.view.SPPopupWaiting;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.sdk.SPVPNClient;
import com.secure.sportal.sdk.app.SPLoginBaseActivity;
import com.secure.sportal.sdk.app.SPLoginPageAuth;
import com.secure.sportal.sdk.app.SPLoginPageConnect;
import com.secure.sportal.sdk.app.SPLoginPageHolder;
import com.secure.sportal.sdk.app.SPLoginPageVerify;
import com.secure.sportal.sdk.app.SPNotifyManager;
import com.secure.sportal.sdk.auth.SPAuthModel;
import com.secure.sportal.sdk.auth.SPAuthViewKit;
import com.secure.sportal.service.PortalSession;

public class SPLoginActivity
extends SPLoginBaseActivity
implements SPAuthModel.OnAuthModelCallback,
View.OnClickListener {
    private SPAuthModel mAuthModel;
    private int mStage;
    private View mRootView;
    private ImageView mTopBanner;
    private FrameLayout mPageBox;
    private AlertDialog mWaiting;
    private SPLoginPageHolder mConnPage;
    private SPLoginPageAuth mAuthPage;
    private SPLoginPageVerify mVerifyPage;
    private SPLoginPageHolder[] mPageHolders;
    private int mPageIndex;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRootView = View.inflate((Context)this, (int)SPResourseKit.getResId((Context)this, "layout", "sportal_activity_login"), null);
        this.setContentView(this.mRootView);
        this.mTopBanner = (ImageView)SPResourseKit.findViewByName(this.mRootView, "sportal_login_banner");
        this.mPageBox = (FrameLayout)SPResourseKit.findViewByNameEx(this.mRootView, "sportal_login_frag_container");
        this.mConnPage = new SPLoginPageConnect();
        this.mAuthPage = new SPLoginPageAuth();
        this.mVerifyPage = new SPLoginPageVerify();
        this.mPageHolders = new SPLoginPageHolder[]{this.mConnPage, this.mAuthPage, this.mVerifyPage};
        this.mTopBanner.post(new Runnable(){

            @Override
            public void run() {
                PortalSession session = PortalSession.instance((Context)SPLoginActivity.this);
                if (!SPVPNClient.getTunnelStatus().isStoped() && session.isLogin()) {
                    PLog.v("SPLoginActivity.onCreate() %s", SPVPNClient.getTunnelStatus().toString());
                    Bundle extras = new Bundle();
                    extras.putString("vpn_username", session.username);
                    extras.putString("vpn_password", session.password);
                    SPLoginActivity.this.commitLogin(session.userdata(), extras, null);
                    return;
                }
                session.cleanup();
                SPLoginActivity.this.mAuthModel = new SPAuthModel((Context)SPLoginActivity.this, SPLoginActivity.this, true);
                for (int i = SPLoginActivity.this.mPageHolders.length - 1; i >= 0; --i) {
                    SPLoginActivity.this.mPageBox.addView(SPLoginActivity.this.mPageHolders[i].inflate(SPLoginActivity.this, SPLoginActivity.this.mAuthModel), -1, -1);
                }
                SPLoginActivity.this.optimizeBannerView(SPLoginActivity.this.mRootView, SPLoginActivity.this.mTopBanner);
                SPLoginActivity.this.changePage();
                SPNotifyManager.showNotification((Context)SPLoginActivity.this, false);
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.mPageHolders[this.mPageIndex].onActivityResult(requestCode, resultCode, data)) {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    private SPLoginPageHolder changePage() {
        this.mStage = this.mAuthModel.stage;
        if (this.mAuthModel.pkgconfig.auth_autologin && this.mStage != 2) {
            this.mPageBox.setVisibility(4);
        } else {
            this.mPageBox.setVisibility(0);
        }
        this.mPageIndex = 0;
        switch (this.mStage) {
            case 1: {
                this.mPageIndex = 1;
                break;
            }
            case 2: {
                this.mPageIndex = 2;
                break;
            }
            default: {
                this.mPageIndex = 0;
            }
        }
        for (int i = 0; i < this.mPageHolders.length; ++i) {
            this.mPageHolders[i].rootView().setVisibility(i == this.mPageIndex ? 0 : 8);
            this.mPageHolders[i].setPageActived(i == this.mPageIndex);
        }
        return this.mPageHolders[this.mPageIndex];
    }

    public void onClick(View v) {
    }

    @Override
    public void onAuthModelBusy(SPAuthModel model, boolean busy, String msg) {
        if (busy) {
            if (null == this.mWaiting) {
                this.mWaiting = SPPopupWaiting.create((Context)this, "", new SPPopupClosedListener(){

                    @Override
                    public void onDismissNegative(DialogInterface dialog) {
                        super.onDismissNegative(dialog);
                        SPLoginActivity.this.mAuthModel.vpnAbort();
                    }
                }, null, "\u53d6\u6d88", null).dialog();
            }
            this.mWaiting.setMessage((CharSequence)msg);
            this.mWaiting.show();
        } else if (null != this.mWaiting) {
            this.mWaiting.dismiss();
        }
        this.mPageHolders[this.mPageIndex].setBusy(busy);
    }

    @Override
    public void onAuthModelError(SPAuthModel model, int errcode, String errmsg) {
        SPAuthViewKit.showMsgBox(this, "\u9519\u8bef", errmsg);
    }

    @Override
    public void onAuthModelStageChanged(SPAuthModel model, int stage) {
        if (stage == 10) {
            model.saveTracks();
            PortalSession session = PortalSession.instance((Context)this);
            Bundle extras = new Bundle();
            extras.putString("vpn_username", session.username);
            extras.putString("vpn_password", session.password);
            Runnable leaver = new Runnable(){

                @Override
                public void run() {
                    SPLoginActivity.this.mPageHolders[SPLoginActivity.this.mPageIndex].setPageActived(false);
                }
            };
            if (null != model.userdata.pkg_appinfo) {
                this.updateAppSelf(model.userdata, extras, leaver);
            } else {
                this.commitLogin(model.userdata, extras, leaver);
            }
        } else if (this.mStage != stage) {
            this.changePage();
        }
    }

    @Override
    public void onAuthModelAuthChanged(SPAuthModel model, SPAuthServerInfo authsvr) {
        this.mPageHolders[this.mPageIndex].onAuthModelAuthChanged(model, authsvr);
    }
}

