/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.comm.SPLog;
import com.secure.comm.entry.SPMessageCallbackEx;
import com.secure.comm.entry.SPX509Info;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.vpn.SPToolConnectTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public final class SPVPNTool {
    private static AtomicReference<SPX509Info> mX509Info = new AtomicReference<Object>(null);

    public static void setLogcatLevel(int level) {
        String cmd = "log_set_info";
        switch (level) {
            case 0: 
            case 2: {
                SPLog.level = level;
                cmd = "log_set_trace";
                break;
            }
            case 3: {
                SPLog.level = level;
                cmd = "log_set_debug";
                break;
            }
            case 4: 
            case 5: {
                SPLog.level = level;
                cmd = "log_set_info";
                break;
            }
            case 6: 
            case 8: {
                SPLog.level = level;
                cmd = "log_set_error";
                break;
            }
            default: {
                return;
            }
        }
        SPLibBridge.exeCmd(cmd, "{}", null);
    }

    public static String setLogFlush() {
        JSONObject reqjson = new JSONObject();
        SPJSONUtil.put(reqjson, "action", "flush");
        SPMsgRspEmpty rsp = SPLibBridge.exeCmdEx("sys_log_perform", reqjson);
        return rsp.errcode == 0 && null != rsp.json ? rsp.json.optString("filepath") : "";
    }

    public static boolean encryptFile(String srcFile, String dstFile, String password) {
        return SPLibBridge.encryptFile(true, srcFile, dstFile, password);
    }

    public static boolean decryptFile(String srcFile, String dstFile, String password) {
        return SPLibBridge.encryptFile(false, srcFile, dstFile, password);
    }

    public static boolean putSSLFingerprint(String host, int port, String fingerprint) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        return 0 == SPLibBridge.putSSLFingerprint(host, port, fingerprint);
    }

    public static void clearSSLFingerprint() {
        SPLibBridge.putSSLFingerprint(null, 0, "");
    }

    public static boolean checkSSLFingerprint(String host, int port, String servername, String fingerprint) {
        return SPLibBridge.checkSSLFingerprint(host, port, servername, fingerprint);
    }

    public static String[] extractPEMs(Context context, byte[] pfx, String password) {
        SPLibBridge.initLibrary(context);
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "pfx_base64", Base64.encodeToString((byte[])pfx, (int)2));
        SPJSONUtil.put(json, "password", password);
        SPMsgRspEmpty rsp = SPLibBridge.loopbackExeCmdEx("sys_ssl_extract_pfx", json);
        ArrayList<String> pems = new ArrayList<String>();
        if (0 == rsp.errcode) {
            JSONArray pemList = rsp.json.optJSONArray("pem_base64");
            for (int i = 0; null != pemList && i < pemList.length(); ++i) {
                pems.add(new String(Base64.decode((String)pemList.optString(i), (int)2)));
            }
        }
        return pems.toArray(new String[pems.size()]);
    }

    public static SPX509Info getTFCertInfo(String pin, String app, String container) {
        if (null != mX509Info.get()) {
            return mX509Info.get();
        }
        SPX509Info xinfo = new SPX509Info();
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "pin", pin);
        SPJSONUtil.put(json, "app", app);
        SPJSONUtil.put(json, "container", container);
        SPMsgRspEmpty rsp = SPLibBridge.loopbackExeCmdEx("sys_ssl_read_key", json);
        SPVPNTool.setLogFlush();
        if (0 == rsp.errcode) {
            xinfo.key_serial = rsp.json.optString("key_serial");
            String pemb64 = rsp.json.optString("pem");
            xinfo.pem = new String(Base64.decode((byte[])pemb64.getBytes(), (int)2));
            xinfo.version = rsp.json.optInt("version");
            xinfo.notBefore = rsp.json.optLong("not_before") * 1000L;
            xinfo.notAfter = rsp.json.optLong("not_after") * 1000L;
            xinfo.subject = rsp.json.optString("subject_name");
            xinfo.subject = SPStringUtil.decodeHexMixed(xinfo.subject);
            xinfo.issuer = rsp.json.optString("issuer_name");
            xinfo.issuer = SPStringUtil.decodeHexMixed(xinfo.issuer);
            xinfo.sn = rsp.json.optString("sn");
            xinfo.signature = rsp.json.optString("signature");
            int pos = xinfo.subject.indexOf("CN=");
            if (pos > 0) {
                xinfo.subject_cn = xinfo.subject.substring(pos + 3);
                pos = xinfo.subject_cn.indexOf("/");
                if (pos > 0) {
                    xinfo.subject_cn = xinfo.subject_cn.substring(0, pos);
                }
            } else {
                xinfo.subject_cn = xinfo.subject;
            }
            if (!TextUtils.isEmpty((CharSequence)xinfo.subject_cn)) {
                mX509Info.set(xinfo);
            }
        } else {
            xinfo.subject = rsp.errmsg;
        }
        return xinfo;
    }

    public static boolean getTFKeyCertSign(String pin, String app, String container, String pembase64, JSONObject output) {
        SPMsgRspEmpty cmdrsp = SPVPNTool.getTFKeyCertSignImpl(pin, app, container, pembase64);
        SPVPNTool.setLogFlush();
        if (0 == cmdrsp.errcode) {
            SPJSONUtil.put(output, "auth_cert_base64", cmdrsp.json.optString("pem"));
            SPJSONUtil.put(output, "auth_cert_sign", cmdrsp.json.optString("signature"));
            SPJSONUtil.put(output, "auth_cert_type", "SM2_SM3_SM2_SKF");
            return true;
        }
        return false;
    }

    public static SPMsgRspEmpty getTFKeyCertSignImpl(String pin, String app, String container, String pembase64) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "container", container);
        SPJSONUtil.put(json, "app", app);
        SPJSONUtil.put(json, "pin", pin);
        pembase64 = SPStringUtil.opt(pembase64);
        if (pembase64.length() > 0) {
            SPJSONUtil.put(json, "pem", pembase64);
        }
        return SPLibBridge.loopbackExeCmdEx("sys_ssl_sign_cert", json);
    }

    public static boolean specifyTFVendor(String vendor) {
        return false;
    }

    public static String getVpnAddress() {
        SPMsgRspEmpty rsp = SPLibBridge.exeCmdEx("session_get_vpn", new JSONObject());
        if (0 == rsp.errcode) {
            return rsp.json.optString("vpn_ip") + ":" + rsp.json.optString("vpn_port");
        }
        return "";
    }

    public static void probeConnectivity(List<String> urls, SPMessageCallbackEx callback) {
        AtomicInteger counter = new AtomicInteger(urls.size());
        for (String url : urls) {
            new Thread(new SPToolConnectTask(counter, url, callback)).start();
        }
    }

    public static void setSSLSM4CBCMode(boolean cbcMode) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "sm4_mode", cbcMode ? "cbc" : "ecb");
        SPLibBridge.loopbackExeCmdEx("sys_set_ssl_smx", json);
    }
}

