/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import android.webkit.WebView;
import com.secure.PLog;
import com.secure.comm.app.SPAppLifecycleHandler;
import com.secure.comm.app.SPApplication;
import com.secure.comm.net.SPInetAddress;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPUriUtil;
import com.secure.comm.utils.SPWebViewUtil;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.sportal.entry.SPOnlineInfo;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPTunStatus;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.jni.LibSecurePortal;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.sdk.auth.SPAuthSDKTask;
import com.secure.sportal.sdk.vpn.SPNCService;
import com.secure.sportal.sdk.vpn.SPNCServiceManagement;
import com.secure.sportal.service.PortalSession;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class SPVPNClient {
    public static final int MSGID_LOGIN_SUCC = 0;
    public static final int MSGID_LOGIN_NEED_PHONE_NUM = 17;
    public static final int MSGID_LOGIN_NEED_EMAIL_ADDR = 18;
    public static final int MSGID_LOGIN_NEED_VCCODE_SMS = 33;
    public static final int MSGID_LOGIN_NEED_VCCODE_EMAIL = 34;
    public static final int MSGID_LOGIN_NEED_VCCODE_TOKEN = 35;
    public static final int MSGID_LOGIN_NEED_SECID_TOKEN = 36;
    public static final int MSGID_LOGIN_FAIL = 256;
    public static final String PARAM_OEM_NAME = "oem_name";
    public static final String PARAM_VPN_HOST = "vpn_host";
    public static final String PARAM_VPN_PORT = "vpn_port";
    public static final String PARAM_AUTH_SERVER = "auth_server";
    public static final String PARAM_AUTH_USERNAME = "auth_username";
    public static final String PARAM_AUTH_PASSWORD = "auth_password";
    public static final String PARAM_VCODE_TARGET = "vcode_target";
    public static final String PARAM_VERIFY_CODE = "verify_code";
    public static final String PARAM_SDCARD_PIN = "sdcard_pin";
    public static final String PARAM_PROXY_AUTHEN_ENABLE = "proxy_authen_enable";
    public static final String PARAM_PROXY_AUTHEN_USER = "proxy_authen_user";
    public static final String PARAM_PROXY_AUTHEN_PASS = "proxy_authen_pass";
    public static final String PARAM_PROXY_NO_BYPASS = "proxy_no_bypass";
    public static final String PARAM_PROXY_NO_HTTP = "proxy_no_http";
    public static final String PARAM_PROXY_NO_SOCKS4 = "proxy_no_socks4";
    public static final String PARAM_PROXY_NO_SOCKS5 = "proxy_no_socks5";
    public static final int REQUEST_CODE_VPN_TUNNEL = 36010;
    public static final String ACTION_SESSION_NOTIFY = "com.secure.sdk.session.notification";
    public static final String ACTION_NC_TUNNEL_STATE = "com.secure.sportal.sdk.vpn.MSG_ACTION";
    public static final String EXTRA_KEY_NC_TUNNEL_STATE = "com.secure.sportal.sdk.vpn.MSG_EXTRA_STATE";
    public static final String EXTRA_KEY_NC_TUNNEL_ERRCODE = "com.secure.sportal.sdk.vpn.MSG_EXTRA_ERRCODE";
    public static final String EXTRA_KEY_NC_TUNNEL_IP = "com.secure.sportal.sdk.vpn.MSG_EXTRA_TUN_IP";
    public static final int NC_TUNNEL_STATE_STOPED = 0;
    public static final int NC_TUNNEL_STATE_CONNECTING = 1;
    public static final int NC_TUNNEL_STATE_CONNECTED = 2;
    public static final int NC_TUNNEL_STATE_ERROR = 3;
    private static AtomicReference<SPAuthSDKTask> mAuthTask = new AtomicReference<Object>(null);

    public static void loadNativeLibrary(String name) {
        LibSecurePortal.systemLoadLibrary(name);
    }

    public static void login(Context context, Properties param, OnVPNLoginCallback callback) {
        PLog.i("SPVPNClient.login()", new Object[0]);
        if (null != mAuthTask.get() && mAuthTask.get().isPending()) {
            if (null != callback) {
                PLog.i("SPVPNClient.login() repeated", new Object[0]);
                callback.onVPNLoginMessage(256, "[0F000009]\u53e6\u4e00\u4e2a\u767b\u5f55\u6d41\u7a0b\u6b63\u5728\u8fdb\u884c\u4e2d");
            }
            return;
        }
        SPApplication.setAppContext(context);
        if (null == SPAppLifecycleHandler.activedHook) {
            SPAppLifecycleHandler.activedHook = new Runnable(){

                @Override
                public void run() {
                    SPVPNTool.setLogFlush();
                }
            };
        }
        String vpn_host = param.getProperty(PARAM_VPN_HOST, "");
        int vpn_port = SPStringUtil.propOptInt(param, PARAM_VPN_PORT, 443);
        URL url = SPUriUtil.parseURL(vpn_host);
        if (null != url) {
            if (!TextUtils.isEmpty((CharSequence)url.getHost())) {
                vpn_host = url.getHost();
            }
            if (vpn_port < 1 && url.getPort() > 0) {
                vpn_port = url.getPort();
            }
        }
        vpn_host = SPStringUtil.opt(vpn_host);
        String oem_name = SPStringUtil.opt(param.getProperty(PARAM_OEM_NAME, ""));
        if (oem_name.length() > 0) {
            SPApplication.setOEMName(oem_name);
        } else if (vpn_host.endsWith(".bankcomm.com")) {
            SPApplication.setOEMName("bankcomm");
        } else if (vpn_host.indexOf(".sinopec.com") != -1) {
            SPApplication.setOEMName("sinopec");
        }
        PortalSession.disablePersist = true;
        if (vpn_host.length() > 0 && vpn_port > 0) {
            if ("true".equalsIgnoreCase(param.getProperty("hook_disable", "")) || "yes".equalsIgnoreCase(param.getProperty("hook_disable", ""))) {
                PortalSession.hookDisabled.set(true);
            }
            PortalSession.proxyServerOption.initialize();
            PortalSession.proxyServerOption.fromProperties(param);
            String access_token = param.getProperty("extra_access_token", "");
            if (TextUtils.isEmpty((CharSequence)access_token)) {
                SPVPNClient.logout();
            }
            if (null != mAuthTask.get()) {
                mAuthTask.get().abort();
            }
            mAuthTask.set(new SPAuthSDKTask(context, callback));
            mAuthTask.get().vpnAuth(vpn_host, vpn_port, param);
        } else if (null == mAuthTask.get()) {
            callback.onVPNLoginMessage(256, "[02000404]\u65e0\u6548\u7684\u767b\u5f55\u4f1a\u8bdd");
        } else {
            mAuthTask.get().setCallback(callback);
            mAuthTask.get().vpnVerifyCode(param.getProperty(PARAM_AUTH_USERNAME), param.getProperty(PARAM_VCODE_TARGET), param.getProperty(PARAM_VERIFY_CODE));
        }
    }

    public static void logout() {
        if (null != mAuthTask.get()) {
            PLog.i("SPVPNClient.logout()", new Object[0]);
            mAuthTask.get().abort();
        }
        SPNCServiceManagement.stopNC(null);
        if (null != SPApplication.appContext()) {
            PortalSession session = PortalSession.instance(SPApplication.appContext());
            if (session.isLogin()) {
                PLog.i("SPVPNClient.logout()", new Object[0]);
                GatewayReq req = new GatewayReq("sac_logout");
                req.ticket_str = SPStringUtil.opt(session.me().ticketstr);
                GatewayBroker.request(req, PortalSession.vpnHost(), PortalSession.vpnPort(), PortalSession.vpnSNI(), null);
            }
            session.setLogin(null, null);
        }
    }

    public static void changePassword(String oldPassword, String newPassword, OnVPNLoginCallback callback) {
        PortalSession session = PortalSession.instance(SPApplication.appContext());
        if (!session.isLogin()) {
            if (null != callback) {
                callback.onVPNLoginMessage(0x2000404, "[02000404]\u8bf7\u5728\u767b\u5f55\u6210\u529f\u540e\u518d\u4fee\u6539\u5bc6\u7801");
            }
            return;
        }
    }

    public static GatewayRsp sessionRenew() {
        GatewayReq req = new GatewayReq("sp_vpn_session_renew");
        return GatewayBroker.request(req, "", 0);
    }

    public static SPOnlineInfo getOnlineInfo() {
        if (null != SPApplication.appContext()) {
            return PortalSession.instance(SPApplication.appContext()).onlineInfo();
        }
        return null;
    }

    public static void heartbeat(final OnVPNLoginCallback callback) {
        PortalSession session = PortalSession.instance(null);
        if (session.isLogin()) {
            GatewayReq req = new GatewayReq("sac_heartbeat");
            req.ticket_str = SPStringUtil.opt(session.me().ticketstr);
            GatewayBroker.request(req, PortalSession.vpnHost(), PortalSession.vpnPort(), PortalSession.vpnSNI(), new GatewayBroker.BrokerCallback(){

                @Override
                public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
                    callback.onVPNLoginMessage(msgrsp.errcode, msgrsp.errmsg);
                }
            });
        } else {
            callback.onVPNLoginMessage(0x2000404, "\u65e0\u6548\u4f1a\u8bdd");
        }
    }

    public static boolean needsVPNTunnel() {
        PortalSession session = PortalSession.instance(null);
        return session.isLogin() && session.userdata().ncSvcList.size() > 0;
    }

    public static void startVPNTunnel(Context context, boolean showToast, int tryTimes) {
        SPNCServiceManagement.startOrStopNC(context, true, showToast, true, tryTimes);
    }

    public static void registVPNTunnelStateReceiver(Context context, BroadcastReceiver receiver) {
        SPIntentUtil.registLocalReceiver(context, ACTION_NC_TUNNEL_STATE, receiver);
    }

    public static void registSessionStateReceiver(Context context, BroadcastReceiver receiver) {
        SPIntentUtil.registLocalReceiver(context, ACTION_SESSION_NOTIFY, receiver);
    }

    public static void unregistBroadcastReceiver(Context context, BroadcastReceiver receiver) {
        SPIntentUtil.unregistLocalReceiver(context, receiver);
    }

    public static boolean isNetHooking() {
        return SPLibBridge.isNetHooking();
    }

    public static Proxy getHttpProxy() {
        InetSocketAddress sa = new InetSocketAddress("127.0.0.1", SPLibBridge.getProxyPort());
        return new Proxy(Proxy.Type.HTTP, sa);
    }

    public static int getProxyPort() {
        return SPLibBridge.getProxyPort();
    }

    public static void setSSLTimeout(int conn_timeout, int so_timeout) {
        String param = String.format(Locale.ENGLISH, "{\"vpn_timeout_connect\":\"%d\", \"vpn_timeout_io\":\"%d\"}", conn_timeout, so_timeout);
        SPLibBridge.exeCmd("sys_set_ssl_timeout", param, null);
    }

    public static void addBypassPackageName(String pkgName) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            PortalSession.bypassPkgNames.clear();
        } else if (!PortalSession.bypassPkgNames.contains(pkgName)) {
            PortalSession.bypassPkgNames.add(pkgName);
        }
    }

    public static void addBypassAddress(String host, int fromPort, int toPort) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            PortalSession.bypassAddresses.clear();
        } else {
            try {
                SPInetAddress addr = new SPInetAddress();
                addr.ip = InetAddress.getByName(host).getHostAddress();
                addr.port1 = Math.min(fromPort, toPort);
                addr.port2 = Math.max(fromPort, toPort);
                if (addr.port1 > 1 && addr.port2 < 65536) {
                    for (int i = 0; i < PortalSession.bypassAddresses.size(); ++i) {
                        SPInetAddress ax = PortalSession.bypassAddresses.get(i);
                        if (!ax.ip.equals(addr.ip) || !ax.mergePort(addr.port1, addr.port2)) continue;
                        return;
                    }
                    PortalSession.bypassAddresses.add(addr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setWebViewProxy(WebView webview) {
        SPWebViewUtil.setProxy(webview, "127.0.0.1", SPVPNClient.getProxyPort());
    }

    public static List<SPServiceInfo> getServiceList() {
        ArrayList<SPServiceInfo> svcList = new ArrayList<SPServiceInfo>();
        svcList.addAll(PortalSession.instance((Context)SPApplication.appContext()).userdata().proxySvcList);
        svcList.addAll(PortalSession.instance((Context)SPApplication.appContext()).userdata().ncSvcList);
        return svcList;
    }

    public static Socket sconnect(String host, int port, int timeout, int sotimeout, String proxyUser, String proxyPass) throws IOException {
        String response;
        Socket conn = new Socket();
        conn.connect(SPVPNClient.getHttpProxy().address(), timeout);
        if (sotimeout > 0) {
            conn.setSoTimeout(sotimeout);
        }
        StringBuilder request = new StringBuilder();
        request.append("CONNECT ").append(host).append(":").append(port).append(" HTTP/1.1\r\n");
        request.append("Proxy-Authorization: Basic ");
        String userpass = proxyUser + ":" + proxyPass;
        request.append(Base64.encodeToString((byte[])userpass.getBytes(), (int)2)).append("\r\n\r\n");
        conn.getOutputStream().write(request.toString().getBytes());
        byte[] bytes = new byte[128];
        InputStream input = conn.getInputStream();
        int len = 0;
        while (len < 128) {
            bytes[len++] = (byte)input.read();
            if (len <= 4 || bytes[len - 4] != 13 || bytes[len - 3] != 10 || bytes[len - 2] != 13 || bytes[len - 1] != 10) continue;
        }
        if ((response = new String(bytes, 0, Math.min(len, bytes.length), "UTF-8")).startsWith("HTTP/1.1 200 ")) {
            return conn;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IOException("Connect failed");
    }

    public static Socket sconnect(String host, int port, int timeout) throws IOException {
        return SPVPNClient.sconnect(host, port, timeout, 0, null, null);
    }

    public static Socket sconnect(String host, int port, int timeout, String proxyUser, String proxyPass) throws IOException {
        return SPVPNClient.sconnect(host, port, timeout, 0, proxyUser, proxyPass);
    }

    public static Socket sconnect(String host, int port, String proxyUser, String proxyPass) throws IOException {
        return SPVPNClient.sconnect(host, port, 6000, proxyUser, proxyPass);
    }

    public static int mapToLoopback(String host, int port) {
        return SPLibBridge.openProxyMapping(0, host, port);
    }

    public static void updateAuthExtras(Properties extras) {
        if (null != extras) {
            SPLibBridge.exeCmdEx("session_set_auth_extra", SPJSONUtil.propertiesToObject(extras));
        }
    }

    public static SPTunStatus getTunnelStatus() {
        return SPNCService.tunnelStatus.clone();
    }

    public static String diagnose(Context context, boolean silent) {
        String sdkInfo = "";
        if (!silent) {
            SPPopupMsgBox.popup(context, "SDK \u4fe1\u606f", sdkInfo);
        }
        return sdkInfo;
    }

    public static String getAccessToken(Context context) {
        PortalSession session = PortalSession.instance(context.getApplicationContext());
        if (session.me() != null) {
            return session.me().access_token;
        }
        return "";
    }

    public static interface OnVPNLoginCallback {
        public void onVPNLoginMessage(int var1, String var2);
    }
}

